<?php
/**
 * Export module
 * 
 * Set report options and retrieve data from database
 * 
 * @package linea21\utils\export
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */

/////////////////////////////////////////
//	TRAITEMENT DES DONNEES PHP - RAPPORT
/////////////////////////////////////////


if (!isset($_POST['sauver'])) exit;

include_once('../dashboard/'.SQL.'.inc.php');
include_once('../project/'.SQL.'.inc.php');
include_once(override('../level/display.php', THEME_ADMIN_PATH));
include_once(override('../project/display.php'));

// paramètres utilisateurs.

$report_settings = array();

$report_settings['file'] = 'D';
$report_settings['title'] = isset($_POST['title_report']) ? $_POST['title_report'] : '';
$report_settings['author'] = isset($_POST['author']) ? $_POST['author'] : '';
$report_settings['mail_author'] = isset($_POST['mail_author']) ? $_POST['mail_author'] : '';
$report_settings['service_author'] = isset($_POST['service_author']) ? $_POST['service_author'] : '';
$report_settings['adress_author'] = isset($_POST['adress_author']) ? strip_tags($_POST['adress_author']) : ''; // remove HTML tags
$report_settings['adress_author'] = str_replace("\r\n", " ", trim($report_settings['adress_author']));

$report_settings['quick_export'] = isset($_POST['quick_export']) ? true : false;

$report_settings['finalities'] = isset($_POST['finalities']) ? true : false;

$report_settings['finalities_description'] = isset($_POST['finalities_description']) ? true : false;

$report_settings['dashboard_values'] = isset($_POST['dashboard_values']) ? true : false;

$report_settings['status'] = isset($_POST['notpublished']) ? 'ALL' : 'PUBLIC';

$report_settings['summary'] = isset($_POST['summary']) ? true : false;

$report_settings['publi_infos'] = isset($_POST['publi_info']) ? true : false;

$report_settings['export_module'] = 'project';

/////////////////////////////////////////////////////////////
// when exporting a single value we disable some features
/////////////////////////////////////////////////////////////
if(isset($_REQUEST['id'])) {
	$report_settings['finalities'] = false;
	$report_settings['finalities_description'] = false;
	$report_settings['dashboard_values']= true;
	$report_settings['status']='ALL';
	$report_settings['summary']=false;
	$report_settings['publi_infos']=false;
	$_POST['projects']='det';
	$_POST['projects_id']=$_REQUEST['id'];
}

// // préparation tableau dénomination des échelles.
// $scale_temp = $sql_object->DBSelect(SQL_getAllScale());
// //print_r($scale_temp);
// $scale_denomination_array = array();
// for($i=0; $i<count($scale_temp); $i++) {
//   $scale_denomination_array[$scale_temp[$i]['scale_id']] = $scale_temp[$i]['scale_denomination'];
// }

// if ($_POST['scale'] == 'det') {
//   $report_settings['scale'] = 'EACH';
//   $scale_array = $_POST['eachscale'];
// } else {
//   $report_settings['scale'] = 'ALL';
//   // initialisation de $scale_array
//   $scale_array = array();
//   for($i=0; $i<count($scale_temp); $i++) {
//     $scale_array[$i] = $scale_temp[$i]['scale_id'];
//   }
// }




if ($_POST['projects'] == 'det') {
	// if no indicator is projects_id - we send all
	if(!isset($_POST['projects_id'])) {
		$report_settings['projects'] = 'ALL';
		$projects_array = -1;
	} else {
		$report_settings['projects'] = 'EACH';
		$projects_array = $_POST['projects_id'];
	}
} else  {
  $report_settings['projects'] = 'ALL';
  $projects_array = -1;
}


/////////////////////////////////////////
//	TRAITEMENT DES DONNEES PHP
/////////////////////////////////////////

// we retrieve all data regarding projects
$project = $sql_object->DBSelect(GetAllProjectsInfo($report_settings['status'], $report_settings['projects'], $projects_array));

// we add extra field with level root
$project = add_root_level($project, 'project_level_id', 'level_root');

// First - we group all projects by finality ID
usort($project, function($a, $b) {
	return $a['level_root'] - $b['level_root'];
});

// Then we prepare multi-sort
// @see http://php.net/manual/fr/function.array-multisort.php
foreach ($project as $key => $row) {
	isset($row['level_root_range']) ? $level_root_range[$key] = $row['level_root_range'] : $level_root_range[$key] = 0; // test because some of project may not be associated with levels - may cause issue when sorting !!!
	isset($row['level_root_name']) ? $level_root_name[$key] = $row['level_root_name'] : $level_root_name[$key] = ''; // test because some of project may not be associated with levels - may cause issue when sorting !!!
	$level_project_id[$key] = $row['project_level_id'];
	$level_project_range[$key] = $row['project_range'];
	$level_project_range[$key] = $row['project_name'];
}

array_multisort($level_root_range, SORT_ASC, $level_root_name, SORT_ASC, $project);

// we need to initiate this var to display finalities as chapter if asked
if($report_settings['finalities'] === true) {
	$current_root_level = 0;
	$bookmark_level = 1;
} else {
	$bookmark_level = 0;
}

// // First, include Requests
// include('../lib/vendor/Requests/library/Requests.php');

// // Next, make sure Requests can load internal classes
// Requests::register_autoloader();

// $options = array('cookies' => array(session_name() => session_id()));
// $rSession = new Requests_Session(SITE_ROOT_URL . 'admin/', array(), array(), $options);

// $response = $rSession->get('index.php?rub=projet&todo=det&id=2');

// // $response = Requests::get(SITE_ROOT_URL . 'admin/index.php?rub=projet&todo=det&id=2');

// var_dump($response->status_code);

// //var_dump($response->raw);

// exit;


?>