<?php


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Generics actions : Finally we update config.ini and add new constants if necessary
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// we parse the current config.ini file (before update)
$config_ini = parse_ini_file("../config/config.ini");


// we set right value to config file
if(isset($config_ini['UPLOAD_MAX_MO']) && $config_ini['UPLOAD_MAX_MO'] > 50) $config_ini['UPLOAD_MAX_MO'] = 3;

$l21config->setParams($config_ini);

// we add BREADCRUMB_SEPARATOR constant if needed
if(!isset($config_ini['BREADCRUMB_SEPARATOR'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'BREADCRUMB_SEPARATOR', "»")));

// we add PROJECT_FINALITIES constant if needed
if(!isset($config_ini['PROJECT_FINALITIES'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'PROJECT_FINALITIES', "1")));

// we add FREE_REGISTRATION constant if needed
if(!isset($config_ini['FREE_REGISTRATION'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'FREE_REGISTRATION', "1")));

// we add FORCE_PUBLIC_AUTH if needed
if(!isset($config_ini['FORCE_PUBLIC_AUTH'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'FORCE_PUBLIC_AUTH', "0")));

// we delete TIMELINE_HEIGHT constant
if(isset($config_ini['TIMELINE_HEIGHT'])) $l21config->rmParams(array(array('SYSTEM_SETTINGS', 'TIMELINE_HEIGHT')));


// we write the new file
if($l21config->writeReleaseParams()) {
	echo "<p><strong>Writing new configuration file : /config/config.ini</strong></p>";
} else {
	echo "<p><strong>Problem writing new configuration file : /config/config.ini</strong></p>";
}

?>