# BUILD Linea21 DB script - UTF-8 format
# ENGINE var is not specified in queries - from MySQL 5.5 it will automatically create innoDB tables
# CREATE DATABASE IF NOT EXISTS `linea` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;
# USE linea;

# One query per line !!!!! DO NOT CHANGE

SET SESSION SQL_MODE='';

DROP TABLE IF EXISTS `l21_bibliography_resources`;
CREATE TABLE l21_bibliography_resources (  bibliores_id int(10) unsigned NOT NULL AUTO_INCREMENT,  bibliores_author varchar(200) NOT NULL,  bibliores_title varchar(255) NOT NULL,  bibliores_sub_title varchar(255) NOT NULL,  bibliores_editor varchar(255) NOT NULL,  bibliores_date varchar(100) NOT NULL,  bibliores_range tinyint(3) unsigned NOT NULL  DEFAULT '0', bibliores_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00', bibliores_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  bibliores_validity enum('Y','N') NOT NULL DEFAULT 'Y', PRIMARY KEY (bibliores_id) ) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_category_user`;
CREATE TABLE l21_category_user (  catus_id tinyint(4) unsigned NOT NULL AUTO_INCREMENT,  catus_name varchar(100) NOT NULL,  catus_description varchar(255) NOT NULL,  catus_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  catus_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  PRIMARY KEY (catus_id)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_comment`;
CREATE TABLE l21_comment (  comment_id int(11) NOT NULL AUTO_INCREMENT,  comment_module varchar(100) NOT NULL,  comment_module_id varchar(255) NOT NULL,  comment_user_id int(11) NOT NULL,  comment_name varchar(255) NOT NULL,  comment_email varchar(255) NOT NULL,  comment_url varchar(255) NOT NULL,  comment_body text NOT NULL,  comment_notification varchar(1) NOT NULL,   comment_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  comment_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  comment_status enum('D','P','E') NOT NULL DEFAULT 'D',  PRIMARY KEY (comment_id),  FULLTEXT KEY comment_index (comment_name,comment_email,comment_body)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_email_collector`;
CREATE TABLE l21_email_collector (  emailcol_id int(10) unsigned NOT NULL AUTO_INCREMENT,  emailcol_email varchar(200) NOT NULL,  emailcol_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  emailcol_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  emailcol_validity enum('Y','N') NOT NULL DEFAULT 'Y',  PRIMARY KEY (emailcol_id)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_j_biblio`;
CREATE TABLE l21_j_biblio (  j_root_id int(11) NOT NULL DEFAULT '0',  j_biblio_id int(11) NOT NULL DEFAULT '0',  j_type enum('P','W') NOT NULL DEFAULT 'P') DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_j_link`;
CREATE TABLE l21_j_link (  j_root_id int(11) NOT NULL DEFAULT '0',  j_link_id int(11) NOT NULL DEFAULT '0',  j_type enum('P','W') NOT NULL DEFAULT 'P') DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_j_multi`;
CREATE TABLE l21_j_multi (  j_root_id int(11) NOT NULL DEFAULT '0',  j_multi_id int(11) NOT NULL DEFAULT '0',  j_type enum('P','W') NOT NULL DEFAULT 'P') DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_j_parts`;
CREATE TABLE l21_j_parts (  j_root_id int(11) NOT NULL DEFAULT '0',  j_parts_id int(11) NOT NULL DEFAULT '0',  j_type enum('P','W') NOT NULL DEFAULT 'P') DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_j_project_sdi`;
CREATE TABLE l21_j_project_sdi (  jps_project_id int(11) NOT NULL DEFAULT '0',  jps_sdi_id int(11) NOT NULL DEFAULT '0') DEFAULT CHARSET=utf8 COLLATE utf8_general_ci ;

DROP TABLE IF EXISTS `l21_j_work_users`;
CREATE TABLE l21_j_work_users (  jwu_id int(10) unsigned NOT NULL AUTO_INCREMENT,  jwu_workshop_id int(10) unsigned NOT NULL DEFAULT '0',  jwu_user_id int(10) unsigned NOT NULL DEFAULT '0',  jwu_user_right enum('A','O','U') NOT NULL DEFAULT 'U',  `jwu_last_modify` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (jwu_id)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_link_resources`;
CREATE TABLE l21_link_resources (  linkres_id int(10) unsigned NOT NULL AUTO_INCREMENT,  linkres_text text NOT NULL,  linkres_mask varchar(200) NOT NULL,  linkres_range tinyint(3) unsigned NOT NULL DEFAULT '0',  linkres_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  linkres_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  linkres_validity enum('Y','N') NOT NULL DEFAULT 'Y',  PRIMARY KEY (linkres_id)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_multimedia_resources`;
CREATE TABLE l21_multimedia_resources (  multires_id int(11) unsigned NOT NULL AUTO_INCREMENT,  multires_name varchar(200) NOT NULL,  multires_description text NOT NULL,  multires_media_uri varchar(255) NOT NULL,  multires_range tinyint(11) unsigned NOT NULL DEFAULT '0',  multires_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  multires_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  multires_validity enum('Y','N') NOT NULL DEFAULT 'Y',  PRIMARY KEY (multires_id)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_news`;
CREATE TABLE l21_news (  news_id int(10) unsigned NOT NULL AUTO_INCREMENT,  news_title varchar(200) NOT NULL,  news_header text NOT NULL,  news_body text NOT NULL,  news_level tinyint(4) NOT NULL DEFAULT '0',  news_scale tinyint(4) NOT NULL DEFAULT '0', news_range tinyint(3) unsigned NOT NULL DEFAULT '0',  news_posted_by int(11) NOT NULL DEFAULT '0',  news_published_date datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  news_perempt_date datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  news_is_national enum('Y','N') NOT NULL DEFAULT 'N',  news_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  news_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  news_statut enum('D','P','AA','PA','E') NOT NULL DEFAULT 'D',  PRIMARY KEY (news_id),  FULLTEXT KEY news_index (news_title,news_header,news_body)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_newsletter`;
CREATE TABLE l21_newsletter (  newsletter_id mediumint(9) NOT NULL AUTO_INCREMENT,  newsletter_title varchar(200) DEFAULT NULL,  newsletter_body text NOT NULL,  newsletter_posted_by int(11) NOT NULL DEFAULT '0',  newsletter_published_date datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  newsletter_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  newsletter_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  newsletter_statut enum('D','W','P','E') NOT NULL DEFAULT 'D',  PRIMARY KEY (newsletter_id),  FULLTEXT KEY newsletter_index (newsletter_title,newsletter_body)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_priority`;
CREATE TABLE l21_priority (  priority_id int(11) NOT NULL AUTO_INCREMENT,  priority_name varchar(255) NOT NULL,  priority_date_crea datetime DEFAULT NULL,  priority_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  PRIMARY KEY (priority_id)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_profile`;
CREATE TABLE l21_profile (  profile_id int(11) unsigned NOT NULL,  profile_firstname varchar(200) NOT NULL DEFAULT '',  profile_lastname varchar(200) NOT NULL DEFAULT '',  profile_email varchar(200) NOT NULL,  profile_email_display enum('Y','N') NOT NULL DEFAULT 'Y',  profile_city varchar(100) NOT NULL,  profile_birthdate date NOT NULL DEFAULT '0001-01-01',  profile_leisures varchar(150) NOT NULL,  profile_job varchar(150) NOT NULL,  profile_avatar varchar(255) NOT NULL,  profile_quotation varchar(150) NOT NULL, profile_signature varchar(200) NOT NULL,  profile_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  profile_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  PRIMARY KEY (profile_id)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_project`;
CREATE TABLE IF NOT EXISTS `l21_project` ( `project_id` int(11) NOT NULL AUTO_INCREMENT, `project_parent_id` int(11) NOT NULL, `project_priority_id` int(11) NOT NULL, `project_scale_id` int(11) NOT NULL, `project_level_id` int(10) unsigned NOT NULL DEFAULT '0', `project_name` varchar(255) NOT NULL, `project_goal` text, `project_description` text, `project_body` text NOT NULL, `project_budget` int(11) DEFAULT NULL, `project_budget_comment` text, `project_elected` varchar(255) DEFAULT NULL, `project_team` text, `project_begin_date` date NOT NULL DEFAULT '0001-01-01', `project_estimated_date` date NOT NULL DEFAULT '0001-01-01', `project_end_date` date NOT NULL DEFAULT '0001-01-01', `project_completed` int(11) NOT NULL DEFAULT '0', `project_range` int(11) NOT NULL DEFAULT '0', `project_workshop_id` int(10) unsigned NOT NULL DEFAULT '0', `project_comment` text, `project_posted_by` int(11) NOT NULL, `project_published_date` datetime NOT NULL DEFAULT '0001-01-01 00:00:00', `project_date_crea` datetime NOT NULL DEFAULT '0001-01-01 00:00:00', `project_last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, `project_statut` enum('D','P','AA','PA','E') NOT NULL, PRIMARY KEY (`project_id`),  FULLTEXT KEY project_index (`project_name`, `project_goal`, `project_description`, `project_body`, `project_comment`, `project_budget_comment`, `project_elected`, `project_team`)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_publication`;
CREATE TABLE l21_publication (  publi_id int(10) unsigned NOT NULL AUTO_INCREMENT,  publi_title varchar(200) NOT NULL,  publi_resume text NOT NULL,  publi_level tinyint(4) NOT NULL DEFAULT '0',  publi_scale tinyint(4) NOT NULL DEFAULT '0', publi_range int(11) NOT NULL DEFAULT '0',  publi_posted_by tinyint(4) NOT NULL DEFAULT '0',  publi_published_date datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  publi_comment text NOT NULL,  publi_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  publi_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  publi_statut enum('D','P','AA','PA','E') NOT NULL DEFAULT 'D',  PRIMARY KEY (publi_id),  FULLTEXT KEY publi_index (publi_title,publi_resume)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_publication_contents`;
CREATE TABLE l21_publication_contents (  publicon_id int(10) unsigned NOT NULL AUTO_INCREMENT,  publicon_title varchar(200) NOT NULL,  publicon_body text NOT NULL,  publicon_range int(11) NOT NULL DEFAULT '0',  publicon_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  publicon_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  publicon_validity enum('Y','N') NOT NULL DEFAULT 'Y',  PRIMARY KEY (publicon_id),  FULLTEXT KEY publication_contents_index (publicon_title,publicon_body)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_rights`;
CREATE TABLE l21_rights (  rights_id int(11) unsigned NOT NULL,  rights_dashboard enum('A','O','U') NOT NULL DEFAULT 'U',  rights_workshop enum('A','O','U') NOT NULL DEFAULT 'U',  rights_project enum('A','O','U') NOT NULL DEFAULT 'U',  rights_publication enum('A','O','U') NOT NULL DEFAULT 'U',  rights_news enum('A','O','U') NOT NULL DEFAULT 'U',  rights_yellowpages enum('A','O','U') NOT NULL DEFAULT 'U',  rights_level enum('A','U') NOT NULL DEFAULT 'U',  rights_scale enum('A','U') NOT NULL DEFAULT 'U', rights_category_user enum('A','U') NOT NULL DEFAULT 'U',  rights_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  rights_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  PRIMARY KEY (rights_id)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_scale`;
CREATE TABLE l21_scale (  scale_id tinyint(4) unsigned NOT NULL AUTO_INCREMENT, scale_denomination varchar(200) NOT NULL,  scale_surface double unsigned NOT NULL DEFAULT '0',  scale_inhabitantsnumber bigint(20) unsigned NOT NULL DEFAULT '0',  scale_cin varchar(100) NOT NULL DEFAULT '', scale_extradata text NOT NULL, scale_root tinyint(3) unsigned NOT NULL DEFAULT '0',  scale_comment text NOT NULL,  scale_dependencies tinyint(3) unsigned NOT NULL DEFAULT '0',  scale_range int(11) NOT NULL DEFAULT '0',  scale_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  scale_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  scale_statut enum('P','D','E','I') NOT NULL DEFAULT 'P',  PRIMARY KEY (scale_id)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_sdi_evaluation`;
CREATE TABLE l21_sdi_evaluation (  sdie_id int(10) unsigned NOT NULL AUTO_INCREMENT,  sdie_scale_compare tinyint(3) unsigned NOT NULL DEFAULT '0',  sdie_fiability tinyint(3) unsigned NOT NULL DEFAULT '0',  sdie_accessibility tinyint(3) unsigned NOT NULL DEFAULT '0',  sdie_lisibility tinyint(3) unsigned NOT NULL DEFAULT '0',  sdie_relevance tinyint(3) unsigned NOT NULL DEFAULT '0',  sdie_global_performance tinyint(3) unsigned NOT NULL DEFAULT '0',  sdie_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  sdie_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  PRIMARY KEY (sdie_id)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_sdi_info`;
CREATE TABLE l21_sdi_info (  sdii_id int(10) unsigned NOT NULL AUTO_INCREMENT,  sdii_type VARCHAR( 255 ) NOT NULL DEFAULT 'quantitative', sdii_dashboard_viz VARCHAR( 255 ) NOT NULL DEFAULT 'gauge', sdii_detail_viz VARCHAR( 255 ) NOT NULL DEFAULT 'column', sdii_value_type VARCHAR( 50 ) NOT NULL DEFAULT 'unique', sdii_name varchar(255) NOT NULL,  sdii_description text NOT NULL,  sdii_comment text NOT NULL,  sdii_level tinyint(3) unsigned NOT NULL DEFAULT '0',  sdii_range tinyint(3) unsigned NOT NULL DEFAULT '0',  sdii_goal text NOT NULL,  sdii_consulting text NOT NULL,  sdii_unit varchar(100) NOT NULL,  sdii_max_value float NULL DEFAULT NULL,  sdii_min_value float NULL DEFAULT NULL,  sdii_threshold_value float NULL DEFAULT NULL,  sdii_threshold_relative enum('Y','N') NOT NULL DEFAULT 'Y',  sdii_frequency int(11) NOT NULL DEFAULT '0',  `sdii_to_dashboard` VARCHAR( 1 ) NOT NULL DEFAULT 'Y', sdii_provider int(10) unsigned NOT NULL DEFAULT '0',  sdii_evaluation int(10) unsigned NOT NULL DEFAULT '0',  sdii_reglementation int(10) unsigned NOT NULL DEFAULT '0',  sdii_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  sdii_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  sdii_statut enum('P','D','E') NOT NULL DEFAULT 'P',  PRIMARY KEY (sdii_id),  FULLTEXT KEY sdi_info_index (sdii_name,sdii_description,sdii_goal,sdii_consulting)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_sdi_provider`;
CREATE TABLE l21_sdi_provider (  sdip_id int(10) unsigned NOT NULL AUTO_INCREMENT,  sdip_name varchar(255) NOT NULL,  sdip_service varchar(255) NOT NULL,  sdip_description text NOT NULL,  sdip_incharge varchar(150) NOT NULL,  sdip_address text NOT NULL,  sdip_phone varchar(10) NOT NULL,  sdip_fax varchar(12) NOT NULL,  sdip_email varchar(200) NOT NULL,  sdip_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  sdip_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  PRIMARY KEY (sdip_id)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_sdi_reglementation`;
CREATE TABLE l21_sdi_reglementation (  sdir_id int(10) unsigned NOT NULL AUTO_INCREMENT,  sdir_title varchar(255) NOT NULL,  sdir_body text NOT NULL,  sdir_referer_uri text NOT NULL,  sdir_mask_uri varchar(255) NOT NULL,  sdir_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  sdir_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  PRIMARY KEY (sdir_id)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_sdi_value`;
CREATE TABLE l21_sdi_value (  sdiv_id int(10) unsigned NOT NULL AUTO_INCREMENT,  sdiv_value float NOT NULL DEFAULT '0', sdiv_multivalue TEXT NOT NULL, sdiv_threshold FLOAT NULL DEFAULT NULL, sdiv_comment text NOT NULL,  sdiv_comment_display varchar(1) NOT NULL DEFAULT 'N',  sdiv_sdi_info int(10) unsigned NOT NULL DEFAULT '0', sdiv_user_id int(11) NOT NULL DEFAULT '1', sdiv_scale tinyint(3) unsigned NOT NULL DEFAULT '0',  sdiv_date_published date NOT NULL DEFAULT '0001-01-01',  sdiv_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  sdiv_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  sdiv_statut enum('P','D','E') NOT NULL DEFAULT 'P',  PRIMARY KEY (sdiv_id)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_user`;
CREATE TABLE l21_user (  user_id int(11) unsigned NOT NULL AUTO_INCREMENT,  user_login varchar(50) NOT NULL,  user_password varchar(200) NOT NULL,  user_community int(11) NOT NULL DEFAULT '0',  user_category tinyint(4) NOT NULL DEFAULT '0',  user_rights int(11) NOT NULL DEFAULT '0',  user_profile int(11) NOT NULL DEFAULT '0', user_forget_passkey varchar(50) NOT NULL DEFAULT '', user_cookiehash varchar(50) NOT NULL DEFAULT '', user_old_logins varchar(255) NOT NULL DEFAULT '', user_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  user_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  user_last_con datetime NOT NULL DEFAULT '0001-01-01 00:00:00', user_validity enum('D','Y','N') NOT NULL DEFAULT 'Y',  PRIMARY KEY (user_id),  KEY user_login (user_login)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_workshop`;
CREATE TABLE l21_workshop (  workshop_id int(10) unsigned NOT NULL AUTO_INCREMENT,  workshop_denomination varchar(255) NOT NULL,  workshop_resume text NOT NULL,  workshop_level tinyint(4) NOT NULL DEFAULT '0',  workshop_comment text NOT NULL,  workshop_restricted INT NOT NULL DEFAULT '0', workshop_range int(11) NOT NULL DEFAULT '0',  workshop_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  workshop_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  workshop_statut enum('D','P','AA','PA','E') NOT NULL DEFAULT 'D',  PRIMARY KEY (workshop_id),  FULLTEXT KEY workshop_index (workshop_denomination,workshop_resume)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_workshop_calendar`;
CREATE TABLE l21_workshop_calendar (  workcal_id int(10) unsigned NOT NULL AUTO_INCREMENT,  workcal_task_date datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  workcal_task varchar(200) NOT NULL,  workcal_task_details text NOT NULL,  workcal_workshop_id int(11) NOT NULL DEFAULT '0',  workcal_posted_by tinyint(4) NOT NULL DEFAULT '0',  workcal_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  workcal_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  workcal_validity enum('Y','N') NOT NULL DEFAULT 'Y',  PRIMARY KEY (workcal_id),  FULLTEXT KEY workshop_cal_index (workcal_task,workcal_task_details)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_workshop_com`;
CREATE TABLE l21_workshop_com (  workcom_id int(10) unsigned NOT NULL AUTO_INCREMENT,  workcom_subject varchar(200) NOT NULL,  workcom_body text NOT NULL,  workcom_parent int(10) unsigned NOT NULL DEFAULT '0',  workcom_workshop_id tinyint(3) unsigned NOT NULL DEFAULT '0',  workcom_user_id int(10) unsigned NOT NULL DEFAULT '0',  workcom_last_user_id int(10) unsigned NOT NULL DEFAULT '0',  workcom_viewed int(10) unsigned NOT NULL DEFAULT '0',  workcom_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  workcom_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  workcom_statut enum('P','C','E') NOT NULL DEFAULT 'P',  PRIMARY KEY (workcom_id),  FULLTEXT KEY workshop_com_index (workcom_subject,workcom_body)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_workshop_notify_exception`;
CREATE TABLE l21_workshop_notify_exception (  workshop_id int(11) NOT NULL,  user_id int(11) NOT NULL,  `type` varchar(100) NOT NULL) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci ;

DROP TABLE IF EXISTS `l21_workshop_report`;
CREATE TABLE l21_workshop_report (  workrep_id int(10) unsigned NOT NULL AUTO_INCREMENT,  workrep_title varchar(200) NOT NULL,  workrep_resume text NOT NULL,  workrep_workshop_id int(10) unsigned NOT NULL DEFAULT '0',  workrep_published_date datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  workrep_comment text NOT NULL,  workrep_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  workrep_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  workrep_statut enum('D','P','AA','PA','E') NOT NULL DEFAULT 'D',  PRIMARY KEY (workrep_id),  FULLTEXT KEY workshop_report_index (workrep_title,workrep_resume)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_workshop_report_contents`;
CREATE TABLE l21_workshop_report_contents (  workrepcon_id int(10) unsigned NOT NULL AUTO_INCREMENT,  workrepcon_title varchar(100) NOT NULL,  workrepcon_body text NOT NULL,  workrepcon_range int(11) NOT NULL DEFAULT '0',  workrepcon_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  workrepcon_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  workrepcon_validity enum('Y','N') NOT NULL DEFAULT 'Y',  PRIMARY KEY (workrepcon_id),  FULLTEXT KEY workshop_report_contents_index (workrepcon_title,workrepcon_body)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_yellowpages`;
CREATE TABLE l21_yellowpages (  yellowp_id int(10) unsigned NOT NULL AUTO_INCREMENT,  yellowp_name varchar(150) NOT NULL,  yellowp_activity varchar(255) NOT NULL,  yellowp_level tinyint(4) NOT NULL DEFAULT '0',  yellowp_street varchar(200) NOT NULL,  yellowp_postal_code varchar(6) NOT NULL,  yellowp_city varchar(100) NOT NULL,  yellowp_country varchar(100) NOT NULL,  yellowp_phone varchar(12) NOT NULL,  yellowp_fax varchar(12) NOT NULL,  yellowp_email varchar(150) NOT NULL,  yellowp_website varchar(150) NOT NULL,  yellowp_latitude float NOT NULL DEFAULT '0',  yellowp_longitude float NOT NULL DEFAULT '0',  yellowp_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  yellowp_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  yellowp_statut enum('D','P','AA','E') NOT NULL DEFAULT 'D',  PRIMARY KEY (yellowp_id)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_plugins`;
CREATE TABLE IF NOT EXISTS `l21_plugins` ( `plugin_id` int(11) NOT NULL AUTO_INCREMENT, `plugin_name` varchar(255) NOT NULL,  `plugin_values` text NOT NULL, `plugin_date_crea` datetime NOT NULL DEFAULT '0001-01-01 00:00:00', `plugin_last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,   PRIMARY KEY (`plugin_id`)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_page`;
CREATE TABLE IF NOT EXISTS `l21_page` ( page_id int(11) NOT NULL AUTO_INCREMENT, page_parent_id int(11) NOT NULL DEFAULT '0', page_homepage VARCHAR( 1 ) NOT NULL DEFAULT 'N' , page_title varchar(200) NOT NULL, page_header text NOT NULL, page_body text NOT NULL, page_range int(11) NOT NULL DEFAULT '0', page_posted_by int(11) NOT NULL, page_published_date datetime NOT NULL DEFAULT '0001-01-01 00:00:00', page_date_crea datetime NOT NULL DEFAULT '0001-01-01 00:00:00',   page_last_modify timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, page_status varchar(1) NOT NULL DEFAULT 'D', PRIMARY KEY (page_id),  FULLTEXT KEY page_index (page_title,page_header,page_body)) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci  ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_actor`;
CREATE TABLE `l21_actor` (`actor_id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,`actor_name` VARCHAR( 255 ) NOT NULL) DEFAULT CHARSET=utf8 COLLATE utf8_general_ci ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_j_project_actor`;
CREATE TABLE `l21_j_project_actor` (  `jpa_id` int(11) NOT NULL AUTO_INCREMENT,  `jpa_project_id` int(11) NOT NULL,  `jpa_actor_id` int(11) NOT NULL,  `jpa_type` varchar(50) NOT NULL,  PRIMARY KEY (`jpa_id`)) DEFAULT CHARSET=utf8  ENGINE=InnoDB ;

# Adding tags table
DROP TABLE IF EXISTS `l21_tag`;
CREATE TABLE IF NOT EXISTS `l21_tag` (  `tag_id` int(11) NOT NULL AUTO_INCREMENT,  `tag_name` varchar(255) NOT NULL, `tag_comment` text NOT NULL, `tag_date_crea` datetime NOT NULL,  `tag_last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  PRIMARY KEY (`tag_id`)) DEFAULT CHARSET=utf8 ENGINE=InnoDB ;

DROP TABLE IF EXISTS `l21_j_tag`;
CREATE TABLE `l21_j_tag` (  `jta_id` int(11) NOT NULL AUTO_INCREMENT,  `jta_module` varchar(100) NOT NULL,  `jta_module_id` int(11) NOT NULL,  `jta_tag_id` int(11) NOT NULL,  PRIMARY KEY (`jta_id`)) DEFAULT CHARSET=utf8 ENGINE=InnoDB ;

# Adding l21_j_project_manager table
CREATE TABLE IF NOT EXISTS `l21_j_project_manager` (  `jpm_id` int(11) NOT NULL AUTO_INCREMENT,  `jpm_project_id` int(11) NOT NULL,  `jpm_manager_id` int(11) NOT NULL,  PRIMARY KEY (`jpm_id`)) DEFAULT CHARSET=utf8 ENGINE=InnoDB ;

# Adding l21_email_queue table
CREATE TABLE IF NOT EXISTS `l21_email_queue` (  `eq_id` int(11) NOT NULL AUTO_INCREMENT,  `eq_recipient` varchar(255) NOT NULL,  `eq_subject` text NOT NULL,  `eq_htmlbody` text NOT NULL,  `eq_textbody` text NOT NULL,  `eq_module` varchar(255) NOT NULL,  `eq_priority` INT NOT NULL DEFAULT '2' COMMENT '1 = high, 2 = medium, 3 =low', `eq_date_crea` datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  `eq_last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  `eq_status` varchar(255) NOT NULL,  PRIMARY KEY (`eq_id`))  DEFAULT CHARSET=utf8 ENGINE=InnoDB ;

# Adding l21_level table
CREATE TABLE IF NOT EXISTS `l21_level` (  `level_id` tinyint(4) unsigned NOT NULL AUTO_INCREMENT,  `level_name` varchar(200) NOT NULL,  `level_code` varchar(100) NOT NULL DEFAULT '',  `level_label` varchar(255) NOT NULL,  `level_parent` tinyint(3) unsigned NOT NULL DEFAULT '0',  `level_desc_project` text NOT NULL, `level_desc_dashboard` text NOT NULL,  `level_desc_publication` text NOT NULL,  `level_desc_news` text NOT NULL,  `level_desc_workshop` text NOT NULL,  `level_range` tinyint(4) unsigned NOT NULL DEFAULT '0',  `level_date_crea` datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  `level_last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  `level_status` enum('P','D','E') NOT NULL DEFAULT 'P',  PRIMARY KEY (`level_id`)) DEFAULT CHARSET=utf8  ENGINE=InnoDB ;

# Adding Finalities table (used for french only)
CREATE TABLE `l21_finalities` (  `finality_id` int(11) NOT NULL AUTO_INCREMENT,  `finality_name` varchar(255) NOT NULL,  `finality_date_crea` datetime NOT NULL DEFAULT '0001-01-01 00:00:00',  `finality_last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  `finality_status` enum('D','P','E') NOT NULL DEFAULT 'P',  PRIMARY KEY (`finality_id`)) DEFAULT CHARSET=utf8 ENGINE=InnoDB ;

# Create join tables
CREATE TABLE `l21_j_project_finality` (  `jpf_id` int(11) NOT NULL AUTO_INCREMENT,  `jpf_project_id` int(11) NOT NULL,  `jpf_finality_id` int(11) NOT NULL,  `jpf_value` varchar(1) NOT NULL,  PRIMARY KEY (`jpf_id`)) DEFAULT CHARSET=utf8 ENGINE=InnoDB ;

