<?php
/**
 * Level module
 * 
 * Display levels list in back-office
 * 
 * @package linea21\core\level
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////


//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

$current_title=_t('level','list');
$result=$sql_object->DBSelect(SQL_getLevelsList());

function display_level($parent, $dep, $array, $rub_link) {
	$html = "";
	$prev_dep = 0;
	$link_sup=$rub_link."&amp;todo=sup&amp;id=";
	$link_mod=$rub_link."&amp;todo=mod&amp;id=";
	$link_det=$rub_link."&amp;todo=det&amp;id=";

	if (!$dep && !$prev_dep) $html .= "\n<ul>\n";
	foreach ($array as $item) {

		$current_id=$item['level_id'];
		$current_label = ' <span class="label-info">(' .formatText( $item['level_label'], '2HTML'). ')</span>';
		$current_denomination=formatText($item['level_name'], '2HTML');

		if ($parent == $item['level_parent']) {
			if ($prev_dep < $dep) $html .= "\n<ul>\n";

			$link =	"\t<a href=\"".$link_det.$current_id."\">" .$current_denomination. $current_label . "</a>\n";
			$link.="\t<a href=\"".$link_sup.$current_id."\" class=\"ico_sup\" title=\""._t('level','sup')."\"><i class=\"icon-trash\"></i><span>" . _t('level','sup') . "</span></a>\n";
			$link.="\t<a href=\"".$link_mod.$current_id."\" class=\"ico_mod\" title=\""._t('level','mod')."\"><i class=\"icon-pencil\"></i><span>" . _t('level','mod') . "</span></a>\n";


			$html .= "<li class=\"contextual-menu li".$dep."\">" . $link;
			$prev_dep = $dep;
			$html .= display_level($item['level_id'], ($dep + 1), $array, $rub_link);
		}
	}
	if (($prev_dep == $dep) && ($prev_dep != 0)) $html .= "</ul>\n</li>\n";
	else if ($prev_dep == $dep) $html .= "</ul>\n";
	else $html .= "</li>\n";
	return $html;
}

?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','level'); ?></a></li>
	<li><span><?php echo formatNavTitle($current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
<div id="content">
	<div id="tree">
	<?php echo display_level(0,0,$result, $rub_link); ?>
	</div>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->