<?php
/**
 * Mail module
 * 
 * Provide a function to send email using Swift class
 * 
 * @package linea21\core\mail
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

/**
 * @param array $emailContainer
 * @return boolean True if sent, else false
 */
function send_email($emailContainer) {
	
	require_once '../lib/vendor/swift/lib/swift_required.php';
	
	// We create the Transport
	if (defined ( 'MAIL_MAILER' )) {
		
		// by default
		$transport = Swift_MailTransport::newInstance ();
		
		// sendmail
		if (MAIL_MAILER == 'sendmail') {
			
			$transport = Swift_SendmailTransport::newInstance ( MAIL_SENDMAIL );
		}
		// smtp
		if (MAIL_MAILER == 'smtp') {
			if (defined ( 'MAIL_SMTP_AUTH' ) && MAIL_SMTP_AUTH == 1) {
				
				$transport = Swift_SmtpTransport::newInstance ( MAIL_HOST, MAIL_PORT )->setUsername ( MAIL_SMTP_USER )->setPassword ( MAIL_SMTP_PASS );
			} else {
				
				$transport = Swift_SmtpTransport::newInstance ( MAIL_HOST, MAIL_PORT );
			}
		}
	}
	
	// echo "destinataire : ".$emailContainer['recipient']."<br />";
	// echo "sujet : ".$emailContainer['subject']."<br />";
	// echo "body : ".$emailContainer['html_body']."<br />";
	// echo "body (txt) : ".$emailContainer['txt_body']."<br />";
	
	// Create the Mailer using the Transport
	$mailer = Swift_Mailer::newInstance ( $transport );
	
	isset ( $emailContainer ['from'] ) ? $from = $emailContainer ['from'] : $from = MAIL_FROM;
	isset ( $emailContainer ['from_name'] ) ? $fromname = $emailContainer ['from_name'] : $fromname = MAIL_FROMNAME;
	// $replyto must be an array()
	isset ( $emailContainer ['reply_to'] ) ? $replyto = $emailContainer ['reply_to'] : $replyto = array( MAIL_REPLY => MAIL_REPLYNAME );
	$emailContainer ['txt_body'] = str_replace ( '&amp;', '&', $emailContainer ['txt_body'] );
	
	// if only one email is given we put it an array
	if (is_string ( $emailContainer ['recipient'] )) {
		$tmp = $emailContainer ['recipient'];
		$emailContainer ['recipient'] = array ();
		array_push ( $emailContainer ['recipient'], $tmp );
	}
	
	// Create a message
	$message = Swift_Message::newInstance ( $emailContainer ['subject'] )->setFrom ( array (
			$from => $fromname 
	) )->setBody ( $emailContainer ['html_body'], 'text/html' )->addPart ( $emailContainer ['txt_body'], 'text/plain' )->setReplyTo ( $replyto );
	
	if (is_array ( $emailContainer ['recipient'] )) {
		
		for($i = 0; $i < count ( $emailContainer ['recipient'] ); $i ++) {
			
			$message->setTo ( $emailContainer ['recipient'] [$i] );
			$r = $mailer->Send ( $message, $failures );
			
			if (! $r) {
				$logmsg = 'not sent';
			} else {
				$logmsg = 'sent';
			}
			
			logfile ( LOG_MAILER, array (
					$emailContainer ['subject'],
					$emailContainer ['recipient'] [$i],
					$logmsg 
			) );
			if (! $r && MOD_DEBUG == 1) {
				_debug ( '<b>Mail has not been sent</b>. "' . $emailContainer ['recipient'] [$i] . ' / ' . $emailContainer ['subject'] . '" : ' . $logmsg );
			}
		}
	}
	
	if (! $r)
		return false;
	else
		return true;
}

?>