<?php
/**
 * Newsletter module - auto-populate textarea with latest news using ajax
 * 
 * Auto-populate textarea with latest news using  ajax. Called from back-office only
 *  
 * @package linea21\modules\newsletter
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
session_start();

$noplugin = true; // flag for ../config/define.php file
include_once('../config/define.php');

if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

include_once(override('../newsletter/'.SQL.'.inc.php'));
include_once('../languages/' . U_L . '/lang_news.' . CHARSET . '.php');
include_once('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');

if(isset($_POST['content'])) $content = $_POST['content'];
else exit('no way!');


$r = $sql_object->DBSelect(SQL_get_latest_newletter());

if(!isset($r[0]['latest_date'])) $date = '2000-01-01 08:00:00';
else $date = $r[0]['latest_date'];


$r = $sql_object->DBSelect(SQL_getLatestNewsSince($date));

$nodes = '';
if(isset($r[0]['news_id'])) {
	
	foreach($r as $el) {
		
		$title=formatText($el['news_title'],'2HTML');
		$link = array('rub' => $GLOBALS['links'][U_L]['news']['linkvalue'], 'id' => $el['news_id'], 'name' => $el['news_title']);
		
		if(!empty($el['news_header'])) $excerpt = formatText($el['news_header'],'2HTML');
		else $excerpt = cutText(formatText($el['news_body'],'2HTML'), 200);
		
		$nodes .= '<div class="nl-news">';
		$nodes .= '<h2>'.$title.'</h2>';
		$nodes .= '<div class="excerpt">'.$excerpt.'</div>';
		$nodes .= '<a class="readmore" href="'.SITE_ROOT_URL.'public/'.HrefMaker($link).'">'._t('btn', 'read_more').'</a>';
		$nodes .= '</div>';
	}
	
}

// get content with SIMPLEHTMLDOM
$html = new simple_html_dom();
$html->load($content);

// we get the #main container and load latest news
if($nodes != '') {
	if($html->find('#main', 0)) $html->find('#main', 0)->innertext = $nodes;
}

// we return new html content
echo $html;

// we clear SimpleHTMLDom to prevent memory leaks
$html->clear();
?>