<?php
/**
 * Newsletter module
 * 
 * Add newsletter page
 * 
 * @package linea21\modules\newsletter
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////
?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','newsletter'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('newsletter','add')); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
$form_title='';
$form_body='';
$mask_statut_D='checked="checked"';
$mask_statut_W='';


// Simple HTML DOM library call (included in config/define.php file
$html = file_get_html(override("../newsletter/input/template.html", THEME_PUBLIC_PATH));
$html = str_replace('##SITEURL##', SITE_ROOT_URL, $html);
$form_body = str_replace('##CONTENTS##', '<p>'._t('newsletter', 'content').'</p>', $html);



$newsletter_object = new newsletter;

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$newsletter_object->AddNewsletter($data_table, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if(is_numeric($result)) header("Location: ".$link_confirm);
  else  system_error();
}

if(isset($_POST['valider'])) {
  $table[0]=$_POST['newsletter_title'];

  $html = $_POST['newsletter_body'];
  if (get_magic_quotes_gpc()) $html=stripslashes($html);

  $html = removeEmptyP($html);



  $flow = str_get_html($html);
  $body_content = $flow->find('#main', 0)->innertext;
  _debug($body_content);

  $table[1]=$body_content;
  $table[2]=$l21auth->GetSessionElement('id'); // ID posteur
  $table[3]=$_POST['newsletter_statut'];

  $newsletter_object= new newsletter;
  $integrity=$newsletter_object->CheckDataIntegrity($table);

  if(is_string($integrity)) {
    $text_format='2FIELD';
    $body_content=$_POST['newsletter_body'];
  } else {
    $text_format='2HTML';
  }
  $form_title=formatText($_POST['newsletter_title'], $text_format);
  $form_body=formatText($body_content, $text_format);


  if($_POST['newsletter_statut']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($_POST['newsletter_statut']=='W') $mask_statut_W="checked=\"checked\""; else $mask_statut_P='';
  $table=urlencode(serialize($table));
}

?>

<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2(_t('newsletter','add_title')); ?></h2>
<form id="addnews" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
  <label for="newsletter_title"><?php echo mb_ucfirst(_t('newsletter','title')); ?> : *</label>
  <input name="newsletter_title" type="text" class="textfield" id="newsletter_title" maxlength="200" value="<?php echo $form_title; ?>" required />
</p>
<p>
  <label for="newsletter_body"><?php echo mb_ucfirst(_t('newsletter','body')); ?> : *</label>
  <textarea id="newsletter_body" name="newsletter_body" class="largetextfield" <?php echo AREA_SETTINGS; ?> required><?php echo $form_body; ?></textarea>
  <div class="clearfix mrl">
  	<button id="auto-populate" class="small button regular"><?php echo  mb_ucfirst(_t('newsletter','auto_populate')); ?></button>
  </div>
</p>
<div class="label"><?php echo mb_ucfirst(_t('newsletter','statut')); ?> : *</div>
<div class="rightpanel">
  <input name="newsletter_statut" type="radio" id="statut_D" value="D" <?php echo $mask_statut_D; ?> required />
  <label for="statut_D"><?php echo mb_ucfirst(_t('statut','draft')); ?></label>
  <input name="newsletter_statut" type="radio" id="statut_W" value="W" <?php echo $mask_statut_W; ?> />
  <label for="statut_W"><?php echo mb_ucfirst(_t('newsletter','nightsend')); ?></label>
</div>
<div>
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <?php echo cancel_button('javascript:history.go(-1);'); ?>
  <input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
$str = '$("#auto-populate").click(function() {
					if("'.RICH_TEXT_EDITOR.'" == "cke") var ccontent = $( "textarea.largetextfield").val();
					if("'.RICH_TEXT_EDITOR.'" == "tinymce") var ccontent = tinyMCE.activeEditor.getContent();
	 				$.ajax({
					  url: "'.override('../newsletter/_ajax_auto-populate.php', THEME_ADMIN_PATH).'",
					  type: "POST",
					  dataType: "html",
 						data: { content : ccontent }
					}).done(function ( data ) {
							// Set the editor data.
							if("'.RICH_TEXT_EDITOR.'" == "cke") $( "textarea.largetextfield" ).val( data);
							if("'.RICH_TEXT_EDITOR.'" == "tinymce") tinyMCE.activeEditor.setContent(data);
					});
					return false;
 		
				});';
footerAddInlineJS($str);

// Récapitulatif
} else	{

  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<?php
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('newsletter','title'))." :</dt>\n";
echo "<dd>". $form_title."</dd>\n";
echo "<dt>".mb_ucfirst(_t('newsletter','body'))." :</dt>\n";
echo "<dd>".linkin_content($form_body)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','statut'))." :</dt>\n";
echo "<dd>". display_statut($_POST['newsletter_statut']). "</dd>\n";
echo "</dl>\n";
?>
<form id="addscale" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<div>
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
  <?php echo cancel_button('?rub=newsletter&amp;todo=list'); ?>
  <input name="retour" type="button" value="<?php echo _t('btn','preview'); ?>" class="button" id="retour" onclick="history.go(-1);" />
  <input name="enregistrer" type="submit" value="<?php echo _t('btn','save'); ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
}
?>