<?php
/**
 * Page module
 * 
 * Provides basics methods called from public templates. Available in the whole public UI
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\modules\page
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../page/' . SQL . '.inc.php'));


if(!function_exists('get_page')) {

	/**
	 * Get page corresponding to $page_id
	 * 
	 * @param integer $page_id
	 * @param boolean $display_title
	 * @param boolean $display_header
	 * @param boolean $html_title
	 * @param boolean $breadcrumb
	 * @return boolean|string
	 */
	function get_page($page_id, $display_title = true, $display_header = true, $html_title = false, $breadcrumb = false) 	{

		$data = $GLOBALS['sql_object']->DBSelect(SQL_getoneCompletePage($page_id, array('P')));
		$content = '';

		if (!isset($data[0]['page_title'] )) {
			_debug(__FUNCTION__ . ' : no data retrieved (the given ID may be incorrect or the page is not public).');
			return false;
		} else {
			$title = formatText($data[0]['page_title'], '2HTML');
			$header = linkin_content(formatText($data[0]['page_header'], '2HTML'));
			$body = linkin_content(formatText($data[0]['page_body'], '2HTML'));
			$posted_on = formatText($data[0]['page_published_date_display'], '2HTML');
			$modify_on = formatText($data[0]['page_last_modify_display'], '2HTML');
			$posted_by = formatText($data[0]['user_login'], '2HTML');
			$statut = $data[0]['page_status'];

			$link_user = array('rub' => $GLOBALS['links'][U_L]['user-profile']['linkvalue'], 'id' => $data[0]['page_posted_by'], 'name' => $data[0]['user_login']);
			$link_self = array('rub' => $GLOBALS['links'][U_L]['page']['linkvalue'], 'id' => $page_id, 'name' => $title);


			if($html_title) SetHTMLTitle($title);
			if($breadcrumb) setBreadcrumb(array($title => false));

			if($display_title) $content .= '<h1>' . $title . '</h1>' . PHP_EOL;


			if($display_header) $content .= '<div class="chapo clear">' . $header . '</div>' . PHP_EOL;

			$content .= '<div class="body">' . $body . '</div>' . PHP_EOL;

			return $content;
		}

	}
}


if(!function_exists('display_page')) {

	/**
	 * Display page by echoing get_page() returned function
	 * 
	 * @param integer $page_id
	 * @param boolean $display_title
	 * @param boolean $display_header
	 * @param boolean $html_title
	 * @param boolean $breadcrumb
	 */
	function display_page($page_id, $display_title = true, $display_header = true, $html_title = false, $breadcrumb = false) {
		echo get_page($page_id, $display_title, $display_header, $html_title, $breadcrumb);
	}

}


if(!function_exists('get_page_slot')) {
	
	/**
	 * Get slot page corresponding to $page_id
	 * Rely on get_page() function with all options parameters set to false
	 * to get only main content
	 * 
	 * @param integer $page_id
	 * @param boolean $display_title
	 * @return string
	 */
	function get_page_slot($page_id, $display_title = false) {
		
		$content  = '<div class="page-slot slot-'.$page_id.'">';
		$content .= get_page($page_id, $display_title, false, false, false);
		$content .='</div>';

		return $content;
	}

}


if(!function_exists('display_page_slot')) {
	
	/**
	 * Display page slot by echoing get_page_slot() returned function
	 * 
	 * @param integer $page_id
	 * @param string $display_title
	 */
	function display_page_slot($page_id, $display_title = false) {
		
		echo get_page_slot($page_id, $display_title, false, false, false);
	}

}


if(!function_exists('get_page_link')) {
	
	/**
	 * Return page URL
	 * (url rewrited if enables)
	 * 
	 * @param integer $page_id
	 * @return boolean|string
	 */
	function get_page_link($page_id) {

		$data = $GLOBALS['sql_object']->DBSelect(SQL_getoneCompletePage($page_id, array('P')));
		$content = '';

		if (!isset($data[0])) {
			_debug(__FUNCTION__ . ' : no data retrieved (the given ID may be incorrect).');
			return false;
		} else {
			$title = formatText($data[0]['page_title'], '2HTML');
			$link = array('rub' => $GLOBALS['links'][U_L]['page']['linkvalue'], 'id' => $page_id, 'name' => $title);
			
			return HrefMaker($link);
		}
		
	}
	
}

/**
 * display_page_title()
 *
 * @param  $page_id
 * @return void
 */
if(!function_exists('display_page_title')) {
	
	/**
	 * Display page title
	 * Rely on get_page_title() function
	 * 
	 * @param integer $page_id
	 */
	function display_page_title($page_id) {
		
		echo get_page_title($page_id);
	}
	
}


if(!function_exists('get_page_title')) {

	/**
	 * Get page title
	 * 
	 * @param integer $page_id
	 * @return boolean|string
	 */
	function get_page_title($page_id) {

		$data = $GLOBALS['sql_object']->DBSelect(SQL_getPageTitle($page_id, array('P')));
		$content = '';

		if (!isset($data[0])) {
			_debug(__FUNCTION__ . ' : no data retrieved (the given ID may be incorrect).');
			return false;
		} else {
			$title = formatText($data[0]['page_title'], '2HTML');
			return $title;
		}
	}

}

?>