<?php
/**
 * Project module
 * 
 * Provides basics methods called from public templates
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\modules\project
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../project/' . SQL . '.inc.php'));


/**
 * generate_html_recursive()
 * 
 * @see : http://stackoverflow.com/questions/7577396/php-walking-and-print-multi-dimensional-array
 * @param unknown $data
 * @return string
 */
/**
 * 
 * @param array $data
 * @param unknown $statut
 * @param unknown $filter
 * @param unknown $id_filter
 * @param unknown $depth
 * @param unknown $display_first
 * @return string
 */
function generate_html_recursive($data, $statut, $filter, $id_filter, $depth)
{
	// begin with an empty html string
	$html = '';

	// loop through all items in this level
	foreach($data as $key => &$item)
	{
		// echo "$key <br ><br>";
		// where only interested in numeric items
		// as those are the actual children
		if( !is_numeric( $key ) )
		{
			// otherwise continue
			continue;
		}
		

			// we display link only on main levels
			if($item['level_parent'] == 0) {
				$link_level = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['level']['linkvalue'], 'id' => $item['level_id'], 'name' => $item['level_name']);
				$html .= '<h2><a href="' . HrefMaker($link_level) . '" title="' . formatText($item['level_name'], '2ATT') . '">' . $item['level_name'] . '</a></h2>' . PHP_EOL;
			} else {
				$html .= '<h'.($depth+2).'>' . $item['level_name'] . '</h'.($depth+2).'>' . PHP_EOL;
					
			}

		// echo "<br ><br>";
		
		// 			print_r($data[$j]);
		// 			 echo "<br />";
		// we pass the level ID to the SQL query
		if($filter == 'TAG') {
			$projects = $GLOBALS['sql_object']->DBSelect(SQL_getProjectsList(0, 999, $statut, 'LEVEL_TAG', $item['level_id'], $id_filter));
		} else {
			$projects = $GLOBALS['sql_object']->DBSelect(SQL_getProjectsList(0, 999, $statut, 'LEVEL', $item['level_id']));
		}
		
		// 			// we sort values on level names
		// 			// Obtain a list of columns
		// 			foreach ($projects as $key => $row) {
		// 				$level[$key]  = $row['level_name'];
		// 			}
			
		// 			// Sort the data with level descending
		// 			// Add $projects as the last parameter, to sort by the common key
		// 			array_multisort($level, SORT_DESC, $projects);
		
		if ($projects != 0) {
		
			$current_link = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue']);
			$current_level = '';
			
			$html .= '<div class="projects-set">' . PHP_EOL;
			
			for($i = 0; $i < count($projects); $i++) {
				$link_detail = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'id' => $projects[$i]['project_id'], 'name' => $projects[$i]['project_name']);
				
				$project_name = formatText($projects[$i]['complete_project_name'], '2HTML');
				$project_description = formatText($projects[$i]['project_description'], '2HTML');

				$html .= '<p>' . PHP_EOL;
				$html .= '<a href="' . HrefMaker($link_detail) . '" title="' . formatText($project_name, '2ATT') . '">' . $project_name . '</a>' . PHP_EOL;
				$html .= '</p>' . PHP_EOL;
					
			}
			$html .= '</div>' . PHP_EOL;
				
		}
		
		// call this funcion recursively
		// with the next level ($item)
		// it will figure out again whether that level has numeric children as well
		// returns a new complete set, if applicable, otherwise an empty string
		if(isset($item['children'])) $html .= generate_html_recursive($item['children'], $statut, $filter, $id_filter, $depth+1);

	}
	
	// return the resulting html
	return $html;
}



/**
 * DisplayListProjectByLevels()
 * Affichage de la liste des projets publics par niveaux
 *
 * @param string $statut
 * @param integer $filter
 * @param string $id_filter
 * @param integer $debut
 * @return string $content
 */


if(!function_exists('DisplayListProjectByLevels')) {

	function DisplayListProjectByLevels($statut, $filter, $id_filter)
	{

		$data = $GLOBALS['sql_object']->DBSelect(SQL_getLevelsList());

		// we retrieve main levels
		if($filter != 'LEVEL') {
			$data = getLevelChildren($data, 0); // 0 is parentid
			$depth = 0;
		} else {
			$current = $GLOBALS['sql_object']->DBSelect(SQL_getoneLevel($id_filter));
			$data = getLevelChildren($GLOBALS['sql_object']->DBSelect(SQL_getLevelsList()), $id_filter);
			$id_filter =  array_extract($data, 'level_id', true, 'children');
			
			$content  = '<h2>' . $current[0]['level_name'] . '</h2>' . PHP_EOL;
			$content .= '<p class="description">' . $current[0]['level_desc_project'] . '</p>' . PHP_EOL;
			$depth = 1;
		}
		
		echo '<div class="bylevels">';
		if(isset($content)) echo $content;
		echo generate_html_recursive($data, $statut, $filter, $id_filter, $depth);
		echo '</div>';
	}
}


/**
 * DisplayListProject()
 * Affichage de la liste des projets publics
 *
 * @param string $statut
 * @param integer $filter
 * @param string $id_filter
 * @param integer $debut
 * @return string $content
 */
if(!function_exists('DisplayListProject')) {

  function DisplayListProject($statut, $filter, $id_filter, $debut)
  {
  	
  	// getting tags
  	include_once('../class/class.tag.php');
  	
    if ($statut == 'public') {
      $pas = 100;
      $suffix = '';
    } else $pas = SELECT_LIMIT;
    
    $sep = ' <span class="separator">/</span> ';
    
    if ($statut == 'archives_p') $suffix = ' "'.strtolower(_t('statut','PA')).'"';
    $data = $GLOBALS['sql_object']->DBSelect(SQL_getProjectsList($debut, $pas, $statut, $filter, $id_filter));
    $datacount = $GLOBALS['sql_object']->DBSelect(SQL_getCountProjectsList($statut, $filter, $id_filter));
    $bdd_nb_com = $datacount[0]['num_rows'];
    $bdd_nb_com_display = '<p>' . $bdd_nb_com . ' ' . _t('project','name') . $suffix . '</p>' . PHP_EOL;
    $content = '';
    if ($data != 0) {
      // echo $bdd_nb_com_display;	// affichage du nombre d'enregistrements
      $current_link = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue']);
      $content .= get_linkin_page($current_link, $bdd_nb_com, $debut, $pas);

      for($i = 0; $i < count($data); $i++) {
      	
      	$levels = $GLOBALS['sql_object']->DBSelect(SQL_getLevelsList());
      	$level = getLevelParent($levels, $data[$i]['project_level_id'], 0);
      	if(is_array($level)) {
      		$link_level = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['level']['linkvalue'], 'id' => $level['id'], 'name' => $level['name']);
      	}
      	
        $link_detail = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'], 'id' => $data[$i]['project_id'], 'name' => $data[$i]['project_name']);
        $link_scale = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['scale']['linkvalue'], 'id' => $data[$i]['project_scale_id'], 'name' => $data[$i]['scale_denomination']);
        $link_priority = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['priority']['linkvalue'], 'id' => $data[$i]['priority_id'] , 'name' => $data[$i]['priority_name']);
        $link_user = array('rub' => $GLOBALS['links'][U_L]['user-profile']['linkvalue'], 'id' => $data[$i]['project_posted_by'], 'name' => $data[$i]['user_login']);
        $link_tag = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'], 'filter' => 'tag');
        
        $project_name = formatText($data[$i]['complete_project_name'], '2HTML');
        $project_description = formatText($data[$i]['project_description'], '2HTML');
        $scale_denomination = formatText($data[$i]['scale_denomination'], '2HTML');
        $project_posted_on = formatText($data[$i]['project_published_date_display'], '2HTML');
        $project_posted_by = formatText($data[$i]['user_login'], '2HTML');
        $project_priority = formatText($data[$i]['priority_name'], '2HTML');
        $project_level_id = $data[$i]['project_level_id'];
        
        $otag = new tag();
        $tags = $otag->getTags('project', $data[$i]['project_id'], false);

        $content .= '<h2>' . PHP_EOL;
        $content .= '<a href="' . HrefMaker($link_detail) . '" title="' . formatText($project_name, '2ATT') . '">' . $project_name . '</a>' . PHP_EOL;
        $content .= '</h2>' . PHP_EOL;
        $content .= '<p class="published_by">' . PHP_EOL;
        $content .= '<span class="published-on">'._t('statut','published_on') . '</span> <span class="date">' . $project_posted_on . '</span> ';
        $content .= _t('divers','by').' <a href="' . HrefMaker($link_user) . '" title="' . $GLOBALS['links'][U_L]['user-profile']['desc'] . ' (' . $project_posted_by . ')">' . $project_posted_by . '</a>';
        $content .= '</p>' . PHP_EOL;

        $content .= '<div class="chapo clear">' . $project_description . '</div>' . PHP_EOL;
        $content .= '<a class="readmore" href="'.HrefMaker($link_detail).'">'._t('btn', 'read_more').'</a>';
        $content .= '<div class="filter_info">';
        $content .= mb_ucfirst(_t('project','priority')) . ' : <a href="' . HrefMaker($link_priority) . '" title="' . $GLOBALS['filters'][U_L]['priority']['desc'] . ' : ' . formatText($project_priority, '2ATT') . '" class="filter_info_priority">' . mb_ucfirst($project_priority) . '</a>' . $sep . PHP_EOL;
        $content .= _t('divers','scale') . ' : <a href="' . HrefMaker($link_scale) . '" title="' . $GLOBALS['filters'][U_L]['scale']['desc'] . ' : ' . formatText($scale_denomination, '2ATT') . '" class="filter_info_scale">' . $scale_denomination . '</a>' . $sep . PHP_EOL;
        if(is_array($level)) $content .=  ' ' . $level['label'] . ' : <a href="' . HrefMaker($link_level) . '" title="' . $GLOBALS['filters'][U_L]['level']['desc'] . ' : ' . formatText($level['name'], '2ATT') . '" class="filter_info_theme">' . $level['name'] . '</a>'. PHP_EOL;
      	if(!empty($tags)) {
		      $content .= '<div class="tags">' . PHP_EOL;
		      $content .= mb_ucfirst(_t('tag','name')) . ' : ' . $otag->linkTags($tags, $link_tag). PHP_EOL;
		      $content .= '</div>' . PHP_EOL;
	      }
        $content .= '</div>'.PHP_EOL;
        if($i<count($data)-1) $content .= '<hr />' . PHP_EOL;
      }
    } else {
      $content .= '<p class="info">' . _t('divers','nodata') . '</p>';
    }
    $content .= get_linkin_page($current_link, $bdd_nb_com, $debut, $pas);

    echo $content;
  }
}

/**
 * DisplayOneProject()
 * Affichage d'un projet en détail
 *
 * @param integer $project_id
 * @return string $stat status name
 */
if(!function_exists('DisplayOneProject')) {

  function DisplayOneProject($project_id)
  {

    $data = $GLOBALS['sql_object']->DBSelect(SQL_getoneCompleteProject($project_id, array('P', 'PA')));
    $content = '';

    if($data == 0) error_redirect();
    
    // getting tags
    include_once('../class/class.tag.php');
    $otag = new tag();
    $tags = $otag->getTags('project', $project_id, false);
    
    $sep = ' <span class="separator">/</span> ';

    if (count($data) != 1) exit;
    else {
      $link_scale = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['scale']['linkvalue'], 'id' => $data[0]['project_scale_id'], 'name' => $data[0]['scale_denomination']);
      $link_priority = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['priority']['linkvalue'], 'id' => $data[0]['project_priority_id'], 'name' => $data[0]['project_priority']);
      $link_user = array('rub' => $GLOBALS['links'][U_L]['user-profile']['linkvalue'], 'id' => $data[0]['project_posted_by'], 'name' => $data[0]['user_login']);
      $link_parent = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'id' => $data[0]['project_parent_id'], 'name' => $data[0]['parent_name']);
      $link_self = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'], 'id' => $project_id);
      $link_tag = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'], 'filter' => 'tag');
      
      $project_coordinator = empty_nc(getAssociatedActors($project_id, 'coordinator'));
      $project_partners = empty_nc(getAssociatedActors($project_id, 'partner'));
      $project_managers = empty_nc(getAssociatedManagers($project_id));

      $project_name = formatText($data[0]['project_name'], '2HTML');
      $project_goal = formatText($data[0]['project_goal'], '2HTML');
      $project_description = linkin_content(formatText($data[0]['project_description'], '2HTML'));
      $project_body = linkin_content(formatText($data[0]['project_body'], '2HTML'));
      $project_budget = formatText(empty_nc(fnumber_format($data[0]['project_budget'], 0, false)), '2HTML');
      $project_budget_comment = formatText($data[0]['project_budget_comment'], '2HTML');
      $project_team = formatText($data[0]['project_team'], '2HTML');
      $project_elected = formatText($data[0]['project_elected'], '2HTML');
      $project_parent = formatText($data[0]['parent_name'], '2HTML');
      $project_scale = formatText($data[0]['scale_denomination'], '2HTML');
      $project_priority = formatText($data[0]['project_priority'], '2HTML');
      $project_begin_date = formatText(empty_nc($data[0]['project_begin_date_display']), '2HTML');
      $project_estimated_date = formatText(empty_nc($data[0]['project_estimated_date_display']), '2HTML');
      $project_end_date = formatText(empty_nc($data[0]['project_end_date_display']), '2HTML');
      $project_progression = $data[0]['project_completed'];
      $workshop_id = formatText(empty_nc($data[0]['project_workshop_id']), '2HTML');
      $workshop_name = formatText(empty_nc($data[0]['workshop_denomination']), '2HTML');
      $scale_id = $data[0]['project_scale_id'];
      $project_level_id = $data[0]['project_level_id'];
      
      $levels = $GLOBALS['sql_object']->DBSelect(SQL_getLevelsList());
      $level = getLevelParent($levels, $data[0]['project_level_id'], 0);
      if(is_array($level)) {
      	$link_level = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['level']['linkvalue'], 'id' => $level['id'], 'name' => $level['name']);
      }

      $schedule_table = getScheduleTable($data[0]['project_begin_date_display'], $data[0]['project_estimated_date_display'], $data[0]['project_end_date_display']);

      $project_posted_on = formatText($data[0]['project_published_date_display'], '2HTML');
      $project_modify_on = formatText($data[0]['project_last_modify_display'], '2HTML');
      $project_posted_by = formatText($data[0]['user_login'], '2HTML');
      $project_status = $data[0]['project_statut'];

      if(commentEnabled('project')) {
        postCommentAction(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $project_id));
        $content .= '<div id="anchor-comments">'.PHP_EOL;
        $content .= getCommentsAnchor(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $project_id));
        if($project_status == 'P') $content .= getPostCommentAnchor();
        $content .= '</div>'.PHP_EOL;
      }
      $content .= '<h1>' . $project_name . '</h1>' . PHP_EOL;
      $content .= '<p class="published_by">' . PHP_EOL;
      $content .= '<span class="published-on">'._t('statut','published_on') . '</span> <span class="date">' . $project_posted_on . '</span> ';
      $content .= _t('divers','by').' <a href="' . HrefMaker($link_user) . '" title="' . $GLOBALS['links'][U_L]['user-profile']['desc'] . ' (' . $project_posted_by . ')">' . $project_posted_by . '</a>';
      if ($project_status == 'PA') {
        $content .= ' (' . _t('statut','archived_on') . ' ' . $project_modify_on . ')';
      }
      $content .= formatted_permalink($link_self, ' - ');
      $content .= '</p>' . PHP_EOL;
      if($data[0]['project_parent_id'] != 0) {
        $content .= '<div id="parent_project">' . PHP_EOL;
        $content .= mb_ucfirst(_t('project','parent')) . ' : ';
        $content .= '<a href="' . HrefMaker($link_parent) . '" title="' . _t('project','parent') . ' : ' . formatText($project_parent, '2ATT') . '" class="filter_info_parent">' . $project_parent . '</a> ';
        $content .= '</div>' . PHP_EOL;
      }
      
      if(!empty($project_goal)) $content .= '<div class="project-goal"><span class="label">'.mb_ucfirst(_t('project', 'goal')).' : </span>' . $project_goal . '</div>' . PHP_EOL;
      
      $content .= '<div class="grid">' . PHP_EOL;
      $content .= '<div class="grid3-1 grid has-gutter-xl">' . PHP_EOL;
      $content .= '<div class="schedule two-thirds">' . $schedule_table . '</div>' . PHP_EOL;
      $content .= '<div class="progression one-third">'.mb_ucfirst( _t('project','progression')). '<br />' .getDynamicProgressbar($project_progression, 80). '</div>' . PHP_EOL;
      $content .= '</div>' . PHP_EOL;
      $content .= '</div>' . PHP_EOL;
      if(defined('PROJECT_FINALITIES') && PROJECT_FINALITIES == 1) {
      	$content .= '<div class="finalities"><h3>' . _t('project','finalities') . '</h3>';
      	$content .= getFinalities($project_id, 'read');
      	$content .= '</div>';
      }
      
      $content .= '<div class="chapo clear">' . $project_description . '</div>' . PHP_EOL;

      
      
      if(!empty($project_body)) $content .= '<div class="body">' . $project_body . '</div>' . PHP_EOL;
      
			$content .= '<div class="management grid">';
			$content .= '<div class="grid2 grid has-gutter-xl">';
			
			$content .= '<div class="steering">';
			$content .= '<h3>' . _t('project','steering_title') . '</h3>';
			$content .=  mb_ucfirst(_t('project','elected')) . ' : <span>' . empty_nc($project_elected) . '</span><br />';
			$content .=  mb_ucfirst(_t('project','coordinator')) . ' : <span>' . $project_coordinator . '</span><br />' . mb_ucfirst(_t('project','partners')) . ' : <span>' . $project_partners .'</span><br />';
			$content .=  mb_ucfirst(_t('project','manager')) . ' : <span>' . $project_managers . '</span><br />';
			$content .=  mb_ucfirst(_t('project','team')) . ' : <div>' . empty_nc($project_team) . '</div><br />';
			$content .= '</div>';
			
			$content .= '<div class="budget">';
			$content .= '<h3>' . _t('project','budget_title') . '</h3>';
			$content .= mb_ucfirst(_t('project','budget')). ' : <span>' . $project_budget . '</span>';
			if(!empty($project_budget_comment)) $content .= '<div>' . $project_budget_comment . '</div>';
			$content .= '</div>';
			
			$content .= '</div>' . PHP_EOL;
			$content .= '</div>' . PHP_EOL;

      $content .= getProjectChildren($project_id);
      //$content .= getAssociatedIndicators($project_id, $scale_id);
      $content .= getAssociatedIndicatorsValues($project_id);
      $content .= getAssociatedWorkshop($workshop_id, $workshop_name);
      $content .= '<div class="filter_info">' . PHP_EOL;
      $content .= mb_ucfirst(_t('project','priority')) . ' : ';
      $content .= '<a href="' . HrefMaker($link_priority) . '" title="' . $GLOBALS['filters'][U_L]['priority']['desc'] . ' : ' . formatText($project_priority, '2ATT') . '" class="filter_info_priority">' . mb_ucfirst($project_priority) . '</a>' . $sep . PHP_EOL;
      $content .= ' ' . _t('divers','scale') . ' : <a href="' . HrefMaker($link_scale) . '" title="' . $GLOBALS['filters'][U_L]['scale']['desc'] . ' : ' . formatText($project_scale, '2ATT') . '" class="filter_info_scale">' . $project_scale . '</a>' . $sep . PHP_EOL;
      if(is_array($level)) $content .=  ' ' . $level['label'] . ' : <a href="' . HrefMaker($link_level) . '" title="' . $GLOBALS['filters'][U_L]['level']['desc'] . ' : ' . formatText($level['name'], '2ATT') . '" class="filter_info_theme">' . $level['name'] . '</a>'. $sep . PHP_EOL;
      if(!empty($tags)) {
      	$content .= '<div class="tags">' . PHP_EOL;
      	$content .= ' ' . mb_ucfirst(_t('tag','name')) . ' : ' . $otag->linkTags($tags, $link_tag). PHP_EOL;
      	$content .= '</div>' . PHP_EOL;
      }
      $content .= '</div>' . PHP_EOL;
    }


    // including sparkline code
    footerAddJS('../lib/js/jquery.sparkline.min.js');
    footerAddInlineJS("$('.inlinebar').sparkline('html', {type: 'bar', barColor: '#8DA8CB'} );");

    echo $content;
    return GetStatusName($project_status);
  }
}

/**
 * GetProjectChildren()
 *
 * @param  $id
 * @return string
 */
if(!function_exists('getProjectChildren')) {

  function getProjectChildren($id)
  {
    $data = $GLOBALS['sql_object']->DBSelect(SQL_getProjectChildren($id));

    $content = '';
    if (count($data) != 0 && $data[0]!=0) {

      $content .= '<div id="project_children">'.PHP_EOL;
      $content .= '<p>'.mb_ucfirst(_t('project','sub-projects')).' : </p><ul>'.PHP_EOL;
      for($i = 0; $i < count($data); $i++) {
        $link = array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'id' => $data[$i]['project_id'], 'name' => $data[$i]['project_name']);
        $name = formatText($data[$i]['project_name'], '2HTML');

        $content .= '<li><a href="' . HrefMaker($link) . '" title="' . _t('project','parent') . ' : ' . formatText($name, '2ATT') . '" class="filter_info_parent">' . $name . '</a></li>' .PHP_EOL;
      }
      $content .= '</ul></div>'.PHP_EOL;
    }

    return $content;
  }
}

/**
 * GetStatusName()
 *
 * @param  $status
 * @return $stat Status name
 */
if(!function_exists('GetStatusName')) {

  function GetStatusName($status)
  {
    switch ($status) {
      case 'P':
        $stat = 'public';
        break;
      case 'PA':
        $stat = 'archives_p';
        break;
      case 'AA':
        $stat = 'archives_a';
        break;
      default:
        $stat = 'public';
    }
    return $stat;
  }
}

/**
 * getScheduleTable()
 *
 * @param string $s_date
 * @param string $es_date
 * @param string $e_date
 * @return string $content
 */
if(!function_exists('getScheduleTable')) {

  function getScheduleTable($s_date, $es_date, $e_date) {

    $es_date_class = 'nothing';
    $e_date_class = 'nothing';

    if(!isNullDate($es_date)) {
      if(!isNullDate($e_date)) $es_date_class = date_compare($e_date, $es_date, '>') ? 'warn' : 'good';
      else $es_date_class = date_compare(date("Y-m-d"), $es_date, '>') ? 'bad' : 'good';
    }
    if(!isNullDate($e_date)) {
      if(!isNullDate($es_date)) $e_date_class = date_compare($e_date, $es_date, '>') ? 'bad' : 'good';
      else $e_date_class = 'good';
    } else {
      if(!isNullDate($es_date)) {
        $e_date_class = date_compare(date("Y-m-d"), $es_date, '>') ? 'warn' : 'nothing';
      }
    }

    $content  = '<table class="project" summary="">'.PHP_EOL;
    $content .= '<thead>'.PHP_EOL;
    $content .= '<tr>'.PHP_EOL;
    $content .= '<td>'.mb_ucfirst(_t('project','begin_date')).'</td>'.PHP_EOL;
    $content .= '<td>'.mb_ucfirst(_t('project','estimated_date')).'</td>'.PHP_EOL;
    $content .= '<td>'.mb_ucfirst(_t('project','end_date')).'</td>'.PHP_EOL;
    $content .= '</tr>'.PHP_EOL;
    $content .= '</thead>'.PHP_EOL;
    $content .= '<tbody>'.PHP_EOL;
    $content .= '<tr>'.PHP_EOL;
    $content .= '<td>'.formatText(empty_nc($s_date)).'</td>'.PHP_EOL;
    $content .= '<td class="'.$es_date_class.'">'.formatText(empty_nc($es_date)).'</td>'.PHP_EOL;
    $content .= '<td class="'.$e_date_class.'">'.formatText(empty_nc($e_date)).'</td>'.PHP_EOL;
    $content .= '</tr>'.PHP_EOL;
    $content .= '</tbody>'.PHP_EOL;
    $content .= '</table>'.PHP_EOL;
    return $content;
  }
}

/**
 * getAssociatedWorkshop()
 *
 * @param  $id
 * @return string
 */
if(!function_exists('getAssociatedWorkshop')) {

  function getAssociatedWorkshop($wid, $wname)
  {
    $content = '';
    if($wid != 0) {
      $link = array('rub' => $GLOBALS['links'][U_L]['workgroup']['linkvalue'], 'id' => $wid, 'name' => $wname);
      $content .= '<div id="project_workshop">'.PHP_EOL;
      $content .= '<h3>'.ucfirst(_t('project','workshop')).'</h3>'.PHP_EOL;
      $content .= '<p><a href="' . HrefMaker($link) . '" title="' . _t('project','workshop') . ' : ' . formatText($wname, '2ATT') . '">' . $wname . '</a></p>' .PHP_EOL;
      $content .= '</div>'.PHP_EOL;
    }

    return $content;
  }
}


/**
 * getFinalities()
 *
 * @param  $id (optionnal)
 * @param  $mode (optionnal) : take value 'read' or 'write'
 * @param  $selected (optionnal) : array with selected values - useful when adding / changing current values
 * @return array
 */
if(!function_exists('getFinalities')) {

	function getFinalities($id = false, $mode = 'read', $selected = array())
	{
		// we get all values
		$init = $GLOBALS['sql_object']->DBSelect(SQL_getFinalities(false));
		
		
		// we get finalities for the given project if needed
		// and we merge all selected values in $selected array
		if(is_numeric($id)) {
			$data = $GLOBALS['sql_object']->DBSelect(SQL_getFinalities($id));
			if(isset($data[0]['finality_id'])) {
			  foreach ($data as $item) {
			    if(!in_array($item['finality_id'], $selected)) array_push($selected, $item['finality_id']);
			  }
			}
		}

		$content = '';


		if (isset($init[0]['finality_id'])) {
			
			if($mode == 'read') {
				$content .= '<div><ul class="finalities">';
				for($i = 0; $i < count($init); $i ++) {
					$name = formatText($init[$i]['finality_name'], '2HTML');
					if(in_array($init[$i]['finality_id'], $selected)) $box='<span class="finality-active">☑ </span>';
					else $box='<span class="finality-inactive">☐ </span>';

					$content .= '<li id="finality-'.$init[$i]['finality_id'].'">'. $box . $name .'</li>';
				}
				$content .= '</ul></div>';
			}
			
			if($mode != 'read') $content = get_checkbox($init, 'finalities[]', 'finality_name', 'finality_id', $selected);

		}

		return $content;
	}
}

/**
 * getAssociatedActors()
 *
 * @param  $id
 * @param  $type
 * @return string
 */
if(!function_exists('getAssociatedActors')) {

	function getAssociatedActors($id, $type)
	{
		$data = $GLOBALS['sql_object']->DBSelect(SQL_getAssociatedActors($id, $type));

		$content = '';
		$sep = '';
		
		if (count($data) != 0 && $data[0]!= 0) {

			for($i = 0; $i < count($data); $i++) {
				$name = formatText($data[$i]['actor_name'], '2HTML');

				$content .= $sep.$name;
				$sep =', ';
			}

		}

		return $content;
	}
}

/**
 * getAssociatedManagers()
 *
 * @param  $id
 * @return string
 */
if(!function_exists('getAssociatedManagers')) {

	function getAssociatedManagers($id)
	{
		$data = $GLOBALS['sql_object']->DBSelect(SQL_getAssociatedManagers($id));

		$content = '';
		$sep = '';

		if (count($data) != 0 && $data[0]!= 0) {

			for($i = 0; $i < count($data); $i++) {
				$name = formatText($data[$i]['user_login'], '2HTML');

				$content .= $sep.$name;
				$sep =', ';
			}

		}

		return $content;
	}
}

/**
 * getAssociatedWorkshop()
 *
 * @param  $id
 * @return string
 */
if(!function_exists('getAssociatedIndicators')) {

  function getAssociatedIndicators($id, $scale_id, $linkto = true)
  {
    $data = $GLOBALS['sql_object']->DBSelect(SQL_getProjectSdi($id));

    $content = '';
    if (count($data) != 0 && $data[0]!=0) {

      $content .= '<div id="project_indicators" class="listed">'.PHP_EOL;
      $content .= '<h3>'.ucfirst(_t('project','sdi')).'</h3>'.PHP_EOL;
      $content .= '<ul>'.PHP_EOL;
      for($i = 0; $i < count($data); $i++) {
        $link = array('rub' => $GLOBALS['links'][U_L]['dashboard']['linkvalue'], 'id' => $data[$i]['sdii_id'], 'parentid' => $scale_id, 'name' => $data[$i]['sdii_name']);
        $name = formatText($data[$i]['sdii_name'], '2HTML');
				if($linkto) {
        	$content .= '<li><a href="' . HrefMaker($link) . '" title="' . _t('project','sdi') . ' : ' . formatText($name, '2ATT') . '">' . $name . '</a></li>' .PHP_EOL;
				} else {
					$content .= '<li>' . $name . '</li>' .PHP_EOL;
				}
      }
      $content .= '</ul></div>'.PHP_EOL;
    }

    return $content;
  }
}

/**
 * getAssociatedWorkshop()
 *
 * @param  $id
 * @return string
 */
if(!function_exists('getAssociatedIndicatorsValues')) {

	function getAssociatedIndicatorsValues($id, $extraclass ='', $cursorcssposition = 0, $addvalues = false)
	{
		global $l21auth;
		global $sql_object;

		include_once('../dashboard/display.php');
		include_once('../dashboard/mysql.inc.php');
				
		$result_sdi = $GLOBALS['sql_object']->DBSelect(SQL_getProjectSdiValues($id));

		$content = '';
		$id_filter= 1; // scale id value

		if (CURRENT_APP == 'admin' && ($l21auth->isProjectManager($l21auth->GetSessionElement('id'), $sql_object, $id) || $l21auth->isSuperAdmin())) {
			$displayLink = true;
		} else {
			$displayLink = false;
		}
		
		if (count($result_sdi) != 0 && $result_sdi[0]!=0) {

			$content .= '<div class="project-dashboard '.$extraclass.'" id="project-'.$id.'-dashboard">'.PHP_EOL;
			$content .= '<h3>'.ucfirst(_t('project','sdi')).'</h3>'.PHP_EOL;

			// table header
			$content .= '<table class="table_dashboard">' . PHP_EOL;
			$content .= '<thead class="visually-hidden">' . PHP_EOL;
			$content .= '<tr>' . PHP_EOL;
			$content .= '<td class="graphic-values pt2">'.mb_ucfirst(_t('dashboard','graphic_value')).'</td>' . PHP_EOL;
			//$content .= '<td>'.mb_ucfirst(_t('dashboard','numeric_value')).'</td>' . PHP_EOL;
			$content .= '<td>'.mb_ucfirst(_t('dashboard','label_value')).'</td>' . PHP_EOL;
			if($displayLink === true) $content .= '<td>'.mb_ucfirst(_t('divers','actions')).'</td>' . PHP_EOL;
			$content .= '</tr>' . PHP_EOL;
			$content .= '</thead>' . PHP_EOL;
			$content .= '<tbody>' . PHP_EOL;
			

			for ($j = 0;$j < count($result_sdi);$j++) {
			
				// setting $threshold_value
				// By default initial value
				$threshold_value = $result_sdi[$j]['sdii_threshold_value'];
				// if set, we get the latest for the given scale
				$r = $GLOBALS['sql_object'] -> DBSelect(SQL_getlastInsertByPublicationDate($result_sdi[$j]['sdii_id'], 1));
				if(isset($r[0]['sdiv_value']) && !is_null($r[0]['sdiv_threshold'])) {
					$threshold_value = $r[0]['sdiv_threshold'];
				}
				
				if($displayLink === true) {
					$link_add_values = './index.php?rub=dashboard&todo=add&id='.$result_sdi[$j]['sdii_id'].'&scale_id='.$id_filter;
					$addvalues_link  = "<div class=\"iconetab\">\n";
					$addvalues_link .= "<a href=\"".$link_add_values."\" class=\"ico_add\" title=\"".mb_ucfirst(_t('project','add_indicator_value'))."\"><i class=\"icon-plus-circled\"></i><span>" . mb_ucfirst(_t('project','add_indicator_value')) . "</span></a>\n";
					$addvalues_link .= "</div>\n";
				} else $addvalues_link = '';			
				

				if(CURRENT_APP == 'admin') {
					$link_det_sdi = './index.php?rub=dashboard&todo=det&id='.$result_sdi[$j]['sdii_id'].'&scale_id='.$id_filter;

				} else {
					$link_det_sdi= HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id'=>$result_sdi[$j]['sdii_id'], 'parentid'=> $id_filter, 'name' => $result_sdi[$j]['sdii_name']));

				}
				$content .= "<tr>" . PHP_EOL;
				$content .= "<td class=\"graphic-values indicator-".$result_sdi[$j]['sdii_type']."\">";
				$content .= getViz($GLOBALS['sql_object'], $id_filter, $result_sdi[$j], $threshold_value, null, $cursorcssposition);
				$content .= "</td>";
				if($displayLink === true || CURRENT_APP != 'admin') $content .= "<td><a href=\"" . $link_det_sdi . "\" title=\"" . formatText($result_sdi[$j]['sdii_name'], '2ATT') . "\">" . formatText(cutText($result_sdi[$j]['sdii_name'], 53), '2HTML') . "</a></td>" . PHP_EOL;
				else $content .= "<td>" . formatText(cutText($result_sdi[$j]['sdii_name'], 53), '2HTML') . "</td>" . PHP_EOL;
				if($displayLink === true) $content .= "<td>" . $addvalues_link . "</td>" . PHP_EOL;
				$content .= "</tr>" . PHP_EOL;
				
			
			}
			
			$content .= "</tbody>" . PHP_EOL;
			$content .= "</table>" . PHP_EOL;
			$content .= "</div>" . PHP_EOL;
		}
		
			$js = '<script type="text/javascript">
							$(document).ready(function() {
								$(".dashboard-indicator-gauge .cursor").removeAttr("title");
								$(".infobox").hover(
									function() {
										$(this).next().fadeIn("fast");
									},
									function() {
										$(this).next().hide();
									}
								);
								});
						</script>';
		footerAddInlineJS($js, 'default', false);
		

		return $content;

	}
}


?>