<?php
/**
 * Default workgroup template
 * 
 * This file can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../workshop/display.php'));

SetHTMLTitle(_t('workshop','section'));

$GLOBALS['filters'][U_L]['level']['active'] = 0; // filter activation

$link_workgroup = array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue']);
$link_archive= array('rub'=> $GLOBALS['links'][U_L]['workgroup-archives']['linkvalue']);

/* Post Values instances */
//filter level & scale
$filter= isset($_REQUEST['filter']) ? $_REQUEST['filter'] : -1;
//value of pagination
$debut= isset($_REQUEST['debut']) ? $_REQUEST['debut'] : 0;
//id for workgroup
$workshop_id= isset($_REQUEST['id']) ? $_REQUEST['id'] : '';
//body for topic
$body= isset($_REQUEST['post-body']) ? $_REQUEST['post-body'] : '';
//title for topic
$title= isset($_REQUEST['post-title']) ? $_REQUEST['post-title'] : '';
// case for test integrity for update a post or add a topic
$confirm= isset($_REQUEST['confirm']) ? $_REQUEST['confirm'] : '';

if(isset($_REQUEST['filter'])) {
	if($_REQUEST['filter']==$GLOBALS['filters'][U_L]['scale']['linkvalue']) $filter='SCALE';
	if($_REQUEST['filter']==$GLOBALS['filters'][U_L]['priority']['linkvalue']) $filter='PRIORITY';
	if($_REQUEST['filter']==$GLOBALS['filters'][U_L]['level']['linkvalue']) $filter='LEVEL';
	if($_REQUEST['filter']==$GLOBALS['filters'][U_L]['tag']['linkvalue']) $filter='TAG';

} else $filter=-1;


if(ActiveItemKey($GLOBALS['activeitem']) == 'topic' || ActiveItemKey($GLOBALS['activeitem']) == 'post-add') {
  $topic_id=$_REQUEST['id'];
  $workshop_id=$_REQUEST['parentid'];
}

if (ActiveItemKey($GLOBALS['activeitem']) == 'post-update') {
  $topic_id=$_REQUEST['parentparentid'];
  $workshop_id=$_REQUEST['parentid'];
  $post_id=$_REQUEST['id'];
}


$is_authenticated=$GLOBALS['l21auth']->isWorkgroupUser($workshop_id, $GLOBALS['sql_object']);


setBreadcrumb(array(ucfirst(_t('workshop', 'section')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue']))));


/** Affichage du lien de consultation d'archives ( si nécessaire
 */
if(ActiveItemKey($GLOBALS['activeitem']) != 'workgroup-archives')  {

	echo '<div class="switchnav">';
	echo '<a class="button" href="'.HrefMaker($link_archive).'" title="'._t('divers','goto_archives').'">'._t('divers','goto_archives').'</a>'.PHP_EOL;
	echo '</div>';
}

/** Affichage du lien de consultation de la liste courante ( si nécessaire
 */
if(ActiveItemKey($GLOBALS['activeitem']) == 'workgroup-archives')  {

	SetHTMLTitle(_t('archives','name')); // set HTML title
	setBreadcrumb(array(ucfirst(formatText(_t('archives', 'name'), '2HTML')) => HrefMaker($link_archive)));


	echo '<div class="switchnav">';
	echo '<a class="button" href="'.HrefMaker($link_workgroup).'" title="'._t('divers','goto_currentlist').'">'._t('divers','goto_currentlist').'</a>'.PHP_EOL;
	echo '</div>';
}


//display list workgroup
if (!isset($_REQUEST['id']) || isset($_REQUEST['filter']))
{
  echo "<h1>"._t('workshop','h1_public')."</h1>";
  echo "<div class=\"sub-title\">"._t('workshop','h1_public_comment')."</div>";
  DisplayListWorkshop($workshop_id, $filter);
}
else
{

	$r = $GLOBALS['sql_object'] -> DBSelect( SQL_getoneCompleteWorkshop($workshop_id));
	$workshop_status = $r[0]['workshop_statut'];
	
	if($workshop_status != 'P') {
		SetHTMLTitle(_t('archives','name')); // set HTML title
		setBreadcrumb(array(ucfirst(formatText(_t('archives', 'name'), '2HTML')) => HrefMaker($link_archive)));
	}
	
  //display one workgroup
  $result=$GLOBALS['sql_object']->DBSelect(SQL_getWorkshopDenomination($workshop_id));
  
  $workshop_name = formatText($result[0]['workshop_denomination'], '2HTML');
  $workshop_restricted = $result[0]['workshop_restricted'];
  SetHTMLTitle($workshop_name);
  setBreadcrumb(array($workshop_name => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'], 'id'=>$workshop_id))));
  DisplayOneWorkshop($workshop_id, "title");
  ?>
<!-- workgroup data -->
<div id="workshop"><?php DisplayOneWorkshop($workshop_id);?> <?php if (!$is_authenticated) DisplayUrlInscription($workshop_id, $workshop_restricted, $is_authenticated); ?>
</div>
<!-- end workgroup data -->

<?php echo getAssociatedProjects($workshop_id); ?>

<div class="internal-nav">
<ul>
	<li><?php  DisplayUrlCalendar($workshop_id, $workshop_name); ?></li><!-- @whitespace
	<?php if ($is_authenticated) { ?>
	--><li><?php DisplayUrlTopicList($workshop_id, $workshop_name );?></li><!-- @whitespace
	--><li><?php DisplayUrlFiles($workshop_id, $workshop_name); ?></li><!-- @whitespace
	<?php } ?>
	--><li><?php DisplayUrlListerapport($workshop_id, $workshop_name); ?></li><!-- @whitespace
	<?php if ($is_authenticated){ ?>
	--><li><?php DisplayUrlListeutilisateur($workshop_id, $workshop_name); ?></li>
	<?php } else { ?>
	-->
	<?php } ?>
</ul>
</div>


<div class="internal-content <?php echo ActiveItemKey($GLOBALS['activeitem']); ?>"><?php
switch( ActiveItemKey($GLOBALS['activeitem']) )
{
  case "topic-list":
    if($is_authenticated){
      echo "<h2>"._t('workshop','com')."</h2>";
      DisplayListTopic($workshop_id, $debut);
      setBreadcrumb(array(_t('workshop','com_public') => false));
    }
    break;

  case "topic":
    if($is_authenticated){
      echo "<h2>"._t('workshop','com')."</h2>";
      DisplayTopic($workshop_id, $topic_id, $debut);
      setBreadcrumb(array(_t('workshop','com_public') => false));
    }
    break;

  case "files":
    if($is_authenticated){
      echo '<h2>'._t('workshop','shared_files').'</h2>'.PHP_EOL;
      if($workshop_status == 'P') uploadForm($workshop_id);
      echo '<div id="allfiles">'.PHP_EOL;
      DisplayFiles($workshop_id, SITE_ROOT_URL);
      echo '</div>'.PHP_EOL;
      setBreadcrumb(array(_t('workshop','shared_files') => false));
    }
    break;

  case "topic-add":
    if($is_authenticated){
      setBreadcrumb(array(ucfirst(_t('workshop', 'add_com')) => false));
      echo "<h2>"._t('workshop','com')."</h2>";
      AddTopic($workshop_id, $debut, $body, $title, $confirm);
    }
    break;

  case "post-add":
    if($is_authenticated){
      echo "<h2>"._t('workshop','com')."</h2>";
      AddPost($workshop_id, $topic_id, $debut, $body, $title);
    }
    break;

  case "post-update":
    if($is_authenticated){
      echo "<h2>"._t('workshop','com')."</h2>";
      UpdatePost($workshop_id, $topic_id, $debut, $body, $title, $post_id, $confirm);
    }
    break;

  case "user-all":
    echo "<h2>"._t('workshop','participant')."</h2>";
    DisplayUserWorkshop($workshop_id);
    setBreadcrumb(array(_t('workshop','participant') => false));
    break;

  case "report-all":
    echo '<div id="reports">'.PHP_EOL;
    echo "<h2>"._t('workshop','report')."</h2>";
    DisplayListReport($workshop_id, 'P');
    echo '</div>'.PHP_EOL;
    echo '<div id="reports-archived">'.PHP_EOL;
    echo "<h2>"._t('workshop','archived_report')."</h2>";
    DisplayListReport($workshop_id, 'PA');
    echo '</div>'.PHP_EOL;
    setBreadcrumb(array(_t('workshop','barre_report') => false));
    break;

  default:
    echo "<h2>"._t('workshop','calendar')."</h2>";
    DisplayCalendar($workshop_id);
    setBreadcrumb(array(_t('workshop','cal_all') => false));
    break;
}
?>
</div>
<br style="clear: both" />
<?php
}
?>