<?php
/**
 * Public index page
 * 
 * Default front-office index file
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

function optimize($buffer) {
	
	$html = str_get_html($buffer, true, true, CHARSET, false);

	# we set the title
	$current_title = implode(' - ', $GLOBALS['current_title']);
	$title = $html->find('title', 0);
	$title->innertext = $current_title;

  
  # we set the description meta tag or remove it if does not exists
  $desc = $html->find('meta[name=description]', 0);
  if(defined('META_DESCRIPTION') && META_DESCRIPTION != '') {
  	$desc->content = META_DESCRIPTION;
  } else {
  	$desc->outertext = '';
  }
  
  # we set the breadcrumb
  if(defined('BREADCRUMB_CONTAINER')) $container = BREADCRUMB_CONTAINER;
  else $container = 'id=main-container';
  $e = $html->find('div['.$container.']', 0);
  $e->innertext = getBreadcrumb() . $e->innertext ;
  
  $buffer = $html;
  
  // we remove ##BREADCRUMB## placeholder from old templates - @todo remove on next release
  $buffer = trim(str_replace('##BREADCRUMB##', '', $buffer));
  
  // return $buffer is $_SERVER['HTTP_ACCEPT_ENCODING'] does not exist - could happen
  if(!isset($_SERVER['HTTP_ACCEPT_ENCODING'])) return $buffer;
  if(function_exists ('ob_gzhandler') && substr_count($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip')) return ob_gzhandler($buffer, 5);
  
  return $buffer;
}


session_start();
include_once('../config/define.php');

// by default, if rub is not set, takes homepage value
if(!isset($_REQUEST['rub'])) $_REQUEST['rub'] = $GLOBALS['links'][U_L]['home']['linkvalue'];

// ob_start has changed the way is works for PHP version > 5.4.0
if (version_compare(PHP_VERSION, '5.4.0', '>=')) {
	ob_start('optimize', 0, PHP_OUTPUT_HANDLER_STDFLAGS ^ PHP_OUTPUT_HANDLER_REMOVABLE);
} else {
	ob_start('optimize');
}


// check if session is not expired
$l21auth->isActive();

distInclude(THEME_PUBLIC_PATH.SQL.'.inc.php', THEME_PUBLIC_DIST);
include_once('../admin/'.SQL.'.inc.php');
distInclude(THEME_PUBLIC_PATH.'filters.php', THEME_PUBLIC_DIST);
distInclude(THEME_PUBLIC_PATH.'display.php', THEME_PUBLIC_DIST);
ActiveItem();
securityCheck();
IncludeLang();


if(isset($debugbar)) {
  $debugbar['time']->stopMeasure('sqlfiles');
}

// update workgroups ID if needed - only if workgroup section and user logged-in
if(isset($_REQUEST['rub']) && isset($_SESSION['authenticated']) && $_REQUEST['rub'] == $GLOBALS['links'][U_L]['workgroup']['linkvalue']) $GLOBALS['l21auth']->updateCookieWorkshop();

// we include comment functions
include_once(override('../comment/display.php'));
// we include level functions
include_once(override('../level/display.php'));
include_once(THEME_PUBLIC_PATH."index.php");

$GLOBALS['sql_object'] -> DBClose();
@ob_end_flush();
?>