<?php
/**
 * RSS page
 * 
 * Generate and deliver a RSS feed populated by latest news
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once('../config/define.php');
include_once('../lib/no_cache.php');
distInclude('../public/'.SQL.'.inc.php', THEME_PUBLIC_DIST);
include_once('../languages/' . U_L. '/lang_common.' . CHARSET . '.php');

$data=$sql_object -> DBSelect(SQL_getRSS2formatedNews());

$content='';
if($data!=0) {

  for($i=0; $i<count($data); $i++) {
    $news_id=$data[$i]['news_id'];
    $news_title=$data[$i]['news_title'];
    $news_posted_by=$data[$i]['user_login'];
    $news_header=$data[$i]['news_header'];
    $news_body=$data[$i]['news_body'];
    $news_level=$data[$i]['level_name'];
    $news_date=date_rfc2822($data[$i]['news_published_date_display']);
    $link_news=array ('rub'=>$GLOBALS['links'][U_L]['news']['linkvalue'], 'id'=>$news_id, 'name' => $news_title);

    if(!empty($news_header)) $news_content = $news_header;
    else   $news_content = $news_body;

    $content.='<item>'.PHP_EOL;
    $content.='	<title> <![CDATA[ '.$news_title.' ]]></title>'.PHP_EOL;
    $content.='	<link>'.CURRENT_APP_URL . HrefMaker($link_news).'</link>'.PHP_EOL;
    $content.='	<pubDate>'.$news_date.'</pubDate>'.PHP_EOL;
    $content.='	<category> <![CDATA[ '.$news_level.' ]]></category>'.PHP_EOL;
    $content.='	<guid isPermaLink="false">'.$news_id.'@'. CURRENT_APP_URL .'</guid>'.PHP_EOL;
    $content.='	<description>'.PHP_EOL;
    $content.='	<![CDATA[ '.$news_content.' ]]>';
    $content.='	</description>'.PHP_EOL;
    $content.='	<content:encoded><![CDATA['.$news_body.']]></content:encoded>';
    $content.='</item>'.PHP_EOL;
  }
}


/**
 * HEADER RSS
 ****************************************************************/
header('Content-Type: application/xml');
echo '<?xml version="1.0" encoding="UTF-8"?>';
echo '<rss version="2.0" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:sy="http://purl.org/rss/1.0/modules/syndication/"
	xmlns:admin="http://webns.net/mvcb/"
	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
	xmlns:atom="http://www.w3.org/2005/Atom"
	xmlns:content="http://purl.org/rss/1.0/modules/content/">'.PHP_EOL;

echo '<channel>'.PHP_EOL;
echo '	<title>'.SITE_NAME.'</title>'.PHP_EOL;
echo '	<link>'.CURRENT_APP_URL.'</link>'.PHP_EOL;
echo '	<atom:link href="'.CURRENT_APP_URL.'rss2.php" rel="self" type="application/rss+xml" />'.PHP_EOL;
echo '	<description>'.CURRENT_APP_URL.'</description>'.PHP_EOL;
echo '	<language>'.strtolower(U_L).'</language>'.PHP_EOL;
echo '	<copyright>Copyright '.date('Y').' - '.SITE_NAME.'</copyright>'.PHP_EOL;
echo '	<managingEditor>'.SITE_MAIL.'</managingEditor>'.PHP_EOL;
echo '	<webMaster>'.SITE_MAIL.'</webMaster>'.PHP_EOL;
echo '	<lastBuildDate>'.date('r').'</lastBuildDate>'.PHP_EOL;
echo '	<generator>'.SITE_LINEA_NAME.'</generator>'.PHP_EOL;
echo '	<sy:updatePeriod>hourly</sy:updatePeriod>'.PHP_EOL;
echo '	<sy:updateFrequency>1</sy:updateFrequency>'.PHP_EOL;
echo '	<sy:updateBase>2000-01-01T12:00+00:00</sy:updateBase>'.PHP_EOL;
echo '	<image>'.PHP_EOL;
echo '		<url>http://www.linea21.com/logo_linea.gif</url>'.PHP_EOL;
echo '      <link>http://www.linea21.com</link>'.PHP_EOL;
echo '		<title>linea21.com</title>'.PHP_EOL;
echo '	</image>'.PHP_EOL;



echo $content;


/**
 * FOOTER RSS
 **********************************************************/
echo '</channel>'.PHP_EOL;
echo '</rss>';
?>