<?php
/**
 * Publication module
 * 
 * Provides basics methods called from public templates
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\modules\publication
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../publication/'.SQL.'.inc.php'));

if(!function_exists('DisplayListPublication')) {

  function DisplayListPublication($statut, $filter, $id_filter, $debut) {

    if($statut=='public') {
      $pas=100;
      $suffix='';
    } else $pas=SELECT_LIMIT;
    
    $sep = ' <span class="separator">/</span> ';
    
    // getting tags
    include_once('../class/class.tag.php');
    
    if($statut=='archives_p') $suffix=' '._t('statut','PA');
    
    if($filter == 'LEVEL') {
    	$levels = getLevelChildren($GLOBALS['sql_object']->DBSelect(SQL_getLevelsList()), $id_filter);
    	$id_filter = array_extract($levels, 'level_id', true, 'children');
    }
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getPublicationList($debut, $pas, $statut, $filter, $id_filter));
    $datacount=$GLOBALS['sql_object'] -> DBSelect(SQL_getCountPublicationList($statut, $filter, $id_filter));
    $bdd_nb_com=$datacount[0]['num_rows'];
    $bdd_nb_com_display = '<p>'.$bdd_nb_com.' '._t('publication','name2').' '.$suffix.'</p>'.PHP_EOL;
    
    $content= '';

    if($data!=0)
    {
      //echo $bdd_nb_com_display;
      $current_link = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue']);
      $content .= get_linkin_page($current_link,$bdd_nb_com, $debut, $pas);
      
      for($i=0; $i<count($data); $i++) {
      	
      	$levels = $GLOBALS['sql_object']->DBSelect(SQL_getLevelsList());
      	$level = getLevelParent($levels, $data[$i]['level_id'], 0);
      	
        $link_detail= array('rub'=> $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'],'id'=>$data[$i]['publi_id'], 'name' => $data[$i]['publi_title']);
	      if(is_array($level)) {
	    		$link_level = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['level']['linkvalue'], 'id' => $level['id'], 'name' => $level['name']);
	    	}        
	    	$link_scale= array('rub'=> $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'],'filter'=> $GLOBALS['filters'][U_L]['scale']['linkvalue'],'id'=>$data[$i]['publi_scale'], 'name' =>  $data[$i]['scale_denomination']);
        $link_tag = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'], 'filter' => 'tag');
        
        $link_user= array('rub'=> $GLOBALS['links'][U_L]['user-profile']['linkvalue'],'id'=>$data[$i]['publi_posted_by'], 'name' => $data[$i]['user_login']);
        $publi_title=formatText($data[$i]['complete_publi_title'], '2HTML');
        $publi_resume=formatText($data[$i]['publi_resume'], '2HTML');
        $scale_denomination=formatText($data[$i]['scale_denomination'], '2HTML');
        $publi_posted_on=formatText($data[$i]['publi_published_date_display'], '2HTML');
        $publi_posted_by=formatText($data[$i]['user_login'], '2HTML');

        $otag = new tag();
        $tags = $otag->getTags('publication', $data[$i]['publi_id'], false);
        
        $content.='<h2>'.PHP_EOL;
        $content.='<a href="'.HrefMaker($link_detail).'" title="'.$publi_title.'">'.$publi_title.'</a>'.PHP_EOL;
        $content.='</h2>'.PHP_EOL;
        $content.='<p class="published_by">'.PHP_EOL;
        $content.='<span class="published-on">'._t('statut','published_on') . '</span> <span class="date">' .$publi_posted_on.'</span> ';
        $content.=_t('divers','by').' <a href="'.HrefMaker($link_user).'" title="'.formatText($GLOBALS['links'][U_L]['user-profile']['desc']. ' ('.$publi_posted_by.')', '2ATT').'">'.$publi_posted_by.'</a>';
        $content.='</p>'.PHP_EOL;
        $content.='<div class="chapo clear">'.$publi_resume.'</div>'.PHP_EOL;
        $content .= '<a class="readmore" href="'.HrefMaker($link_detail).'">'._t('btn', 'read_more').'</a>';
        $content.='<div class="filter_info">';
        if(is_array($level)) $content .=  ' ' . $level['label'] . ' : <a href="' . HrefMaker($link_level) . '" title="' . $GLOBALS['filters'][U_L]['level']['desc'] . ' : ' . formatText($level['name'], '2ATT') . '" class="filter_info_theme">' . $level['name'] . '</a>'. $sep . PHP_EOL;
        if(!empty($scale_denomination)) $content .= _t('divers','scale') . ' : <a href="'.HrefMaker($link_scale).'" title="'.formatText($GLOBALS['filters'][U_L]['scale']['desc'].' : '.$scale_denomination, '2ATT').'" class="filter_info_scale">'.$scale_denomination.'</a>'.PHP_EOL;
        if(!empty($tags)) {
		      $content .= '<div class="tags">' . PHP_EOL;
		      $content .= mb_ucfirst(_t('tag','name')) . ' : ' . $otag->linkTags($tags, $link_tag). PHP_EOL;
		      $content .= '</div>' . PHP_EOL;
	      }
      	$content .= '</div>' . PHP_EOL;
        $content.='<hr />'.PHP_EOL;
      }
      
      $content .= get_linkin_page($current_link,$bdd_nb_com, $debut, $pas);
      
    }
    else
    {
      $content.='<p class="info">'._t('divers','nodata').'</p>';
    }

    echo $content;
  }
}

if(!function_exists('DisplayOnePublication')) {

  function DisplayOnePublication($publi_id) {

    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getoneCompletePublication($publi_id, array('P', 'PA')));
    $content = '';

    if($data == 0) error_redirect();
    
    $levels = $GLOBALS['sql_object']->DBSelect(SQL_getLevelsList());
    $level = getLevelParent($levels, $data[0]['publi_level'], 0);
    
    $sep = ' <span class="separator">/</span> ';
    
    // getting tags
    include_once('../class/class.tag.php');
    $otag = new tag();
    $tags = $otag->getTags('publication', $publi_id, false);

    if (count($data) != 1) exit;
    else {
    	if(is_array($level)) {
    		$link_level = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['level']['linkvalue'], 'id' => $level['id'], 'name' => $level['name']);
    	}
      $link_scale= array('rub'=> $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'],'filter'=> $GLOBALS['filters'][U_L]['scale']['linkvalue'],'id'=>$data[0]['publi_scale'], 'name' => $data[0]['scale_denomination']);
      $link_user= array('rub'=> $GLOBALS['links'][U_L]['user-profile']['linkvalue'],'id'=>$data[0]['publi_posted_by'], 'name' => $data[0]['user_login']);
      $link_self = array('rub' => $GLOBALS['links'][U_L]['publication']['linkvalue'], 'id' => $publi_id);
      $link_tag = array('rub' => $GLOBALS['links'][U_L][ActiveItemKey($GLOBALS['activeitem'])]['linkvalue'], 'filter' => 'tag');
      
      $publi_title=formatText($data[0]['publi_title'], '2HTML');
      $publi_resume=linkin_content(formatText($data[0]['publi_resume'], '2HTML'));

      $publi_scale_denomination=formatText($data[0]['scale_denomination'], '2HTML');
      $publi_level=formatText($data[0]['level_name'], '2HTML');

      $publi_posted_on=formatText($data[0]['publi_published_date_display'], '2HTML');
      $publi_posted_by=formatText($data[0]['user_login'], '2HTML');
      $publi_modify_on=formatText($data[0]['publi_last_modify_display'], '2HTML');
      $publi_statut=$data[0]['publi_statut'];

      // workrep_workshop_id
    if(commentEnabled('publication')) {
        postCommentAction(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $publi_id));
        $content .= '<div id="anchor-comments">'.PHP_EOL;
        $content .= getCommentsAnchor(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $publi_id));
        if($publi_statut == 'P') $content .= getPostCommentAnchor();
        $content .= '</div>'.PHP_EOL;
      }
      $content.='<h1>'.$publi_title.'</h1>'.PHP_EOL;
      $content.='<p class="published_by">'.PHP_EOL;
      $content.='<span class="published-on">'._t('statut','published_on') . '</span> <span class="date">'.$publi_posted_on.'</span> ';
      $content.=_t('divers','by').' <a href="'.HrefMaker($link_user).'" title="'.$GLOBALS['links'][U_L]['user-profile']['desc']. ' ('.$publi_posted_by.')">'.$publi_posted_by.'</a>';
      if($publi_statut=='PA')  {
        $content.=' ('._t('statut','archived_on').' '.$publi_modify_on.')';
      }
      $content .= formatted_permalink($link_self, ' - ');
      $content.='</p>'.PHP_EOL;
      $content.='<div class="chapo clear">'.$publi_resume.'</div>';

      $content.='<p class="filter_info">';
      if(is_array($level)) $content .=  ' ' . $level['label'] . ' : <a href="' . HrefMaker($link_level) . '" title="' . $GLOBALS['filters'][U_L]['level']['desc'] . ' : ' . formatText($level['name'], '2ATT') . '" class="filter_info_theme">' . $level['name'] . '</a>'. $sep . PHP_EOL;
      //$content._t('divers','sousthemeref').' : '.PHP_EOL;
      //$content.=$publi_theme.PHP_EOL;
      if(!empty($publi_scale_denomination)) $content.=_t('divers','scale').' : <a href="'.HrefMaker($link_scale).'" title="'.formatText($GLOBALS['filters'][U_L]['scale']['desc'].' : '.$publi_scale_denomination, '2ATT').'" class="filter_info_scale">'.$publi_scale_denomination.'</a>'.PHP_EOL;
      if(!empty($tags)) {
		      $content .= '<div class="tags">' . PHP_EOL;
		      $content .= mb_ucfirst(_t('tag','name')) . ' : ' . $otag->linkTags($tags, $link_tag). PHP_EOL;
		      $content .= '</div>' . PHP_EOL;
	      }
      
      $content.='<hr />'.PHP_EOL;


    }
    echo $content;

    return $publi_statut;

  }
}

if(!function_exists('DisplayPublicationParts')) {

  function DisplayPublicationParts($publi_id, $display_empty = false) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getPublicationParts($publi_id));
    $content ='<div class="parts listed">'.PHP_EOL;
    $content.='<h2>'._t('publication','summary').'</h2>'.PHP_EOL;
    if($data!=0)
    {
      $content.='<ol>'.PHP_EOL;
      for($i=0; $i<count($data); $i++) {
        $link_parts= array('rub'=> $GLOBALS['links'][U_L]['publication-part']['linkvalue'],'id'=> $data[$i]['publicon_id'],'parentid'=>$publi_id, 'name' => $data[$i]['publicon_title']);
        $publicon_title=formatText($data[$i]['publicon_title'], '2HTML');
        $content.='<li>'.PHP_EOL;
        $content.='<a href="'. HrefMaker($link_parts).'">';
        $content.=$publicon_title;
        $content.='</a>';
        $content.='</li>'.PHP_EOL;
      }
      $content.='</ol>'.PHP_EOL;
    } else {
    	if($display_empty == false) return ''; // empty result we exit, without displaying any content
      $content.='<p class="info">'._t('publication','no_part').'</p>';
    }
    $content.='</div>'.PHP_EOL;
    //$content.='<hr />';

    echo $content;
  }
}

if(!function_exists('DisplayPublicationLinks')) {

  function DisplayPublicationLinks($publi_id, $display_empty = false) {

    $data=SQL_GetResources($publi_id, 'P', 'LINK', $GLOBALS['sql_object']);
    $content ='<div class="links listed">'.PHP_EOL;
    $content.='<h2>'._t('publication','link_res').'</h2>'.PHP_EOL;
    if($data!=0)
    {
      $content.='<ul>'.PHP_EOL;
      for($i=0; $i<count($data); $i++) {
        $linkres_mask=formatText($data[$i]['linkres_mask'], '2HTML');
        $linkres_text=$data[$i]['linkres_text'];
        $content.='<li>'.PHP_EOL;
        $content.='<a href="'. $linkres_text.'" class="out">';
        $content.=$linkres_mask;
        $content.='</a>';
        $content.='</li>'.PHP_EOL;
      }
      $content.='</ul>'.PHP_EOL;

    } else {
    	if($display_empty == false) return ''; // empty result we exit, without displaying any content
      $content.='<p class="info">'._t('publication','no_link').'</p>';
    }
    $content.='</div>'.PHP_EOL;
    //$content.='<hr />'.PHP_EOL;

    echo $content;
  }
}

if(!function_exists('DisplayPublicationBiblio')) {

  function DisplayPublicationBiblio($publi_id, $display_empty = false) {

    $data=SQL_GetResources($publi_id, 'P', 'BIBLIO', $GLOBALS['sql_object']);
    $content ='<div class="biblio listed">'.PHP_EOL;
    $content.='<h2>'._t('publication','biblio_res').'</h2>'.PHP_EOL;
    if($data!=0)
    {
      $content.='<ul>'.PHP_EOL;
      for($i=0; $i<count($data); $i++) {
        $bibliores_author=formatText($data[$i]['bibliores_author'], '2HTML');
        $bibliores_title=formatText($data[$i]['bibliores_title'], '2HTML');
        $bibliores_sub_title=empty($data[$i]['bibliores_sub_title']) ?  '' : ', '.formatText($data[$i]['bibliores_sub_title'], '2HTML');
        $bibliores_editor=empty($data[$i]['bibliores_editor']) ?  '' : ' - '.formatText($data[$i]['bibliores_editor'], '2HTML');
        $bibliores_date=empty($data[$i]['bibliores_date']) ?  '' : ', '.formatText($data[$i]['bibliores_date'], '2HTML');

        $content.='<li>'.PHP_EOL;
        $content.=$bibliores_author.' - <span class="biblio_title">'.$bibliores_title;
        $content.=$bibliores_sub_title.'</span>'. $bibliores_editor.$bibliores_date;
        $content.='</li>'.PHP_EOL;
      }
      $content.='</ul>'.PHP_EOL;

    } else {
    	if($display_empty == false) return ''; // empty result we exit, without displaying any content
      $content.='<p class="info">'._t('publication','no_biblio').'</p>';
    }
    $content.='</div>'.PHP_EOL;
    //$content.='<hr />'.PHP_EOL;

    echo $content;
  }
}

if(!function_exists('DisplayPublicationMulti')) {

  function DisplayPublicationMulti($publi_id, $display_empty = false) {

    $data=SQL_GetResources($publi_id, 'P', 'MULTI', $GLOBALS['sql_object']);
    $content ='<div class="multi listed">'.PHP_EOL;
    $content.='<h2>'._t('publication','multi_res').'</h2>'.PHP_EOL;
    if($data!=0)
    {
      $content.='<ul>'.PHP_EOL;
      for($i=0; $i<count($data); $i++) {
        $multires_name=formatText($data[$i]['multires_name'], '2HTML');
        $multires_description=formatText($data[$i]['multires_description'], '2HTML');
        if($data[$i]['multires_media_uri'][0]=='m') $multires_media_uri='../'.$data[$i]['multires_media_uri'];
        else $multires_media_uri=$data[$i]['multires_media_uri'];

        $content.='<li>'.PHP_EOL;
        $content.='<a href="'.$multires_media_uri.'" class="out">'.$multires_name.'</a><br />'.PHP_EOL;
        $content.='<div class="desc">'.PHP_EOL;
        $content.=$multires_description.PHP_EOL;
        $content.='</div>'.PHP_EOL;
        $content.='</li>'.PHP_EOL;

      }
      $content.='</ul>'.PHP_EOL;
      
    } else {
    	if($display_empty == false) return ''; // empty result we exit, without displaying any content
      $content.='<p class="info">'._t('publication','no_multi').'</p>';
    }
    $content.='</div>'.PHP_EOL;

    echo $content;
  }
}
?>