<?php
/**
 * Publication module
 * 
 * Modify given publication from back-office
 * 
 * @package linea21\modules\publication
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////
include_once("../lib/input_helpers.php");
include_once(override('../level/mysql.inc.php', THEME_ADMIN_PATH));

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

$mask_statut_P='';
$mask_statut_D='';
$mask_statut_AA='';
$mask_statut_PA='';


$req_det= SQL_getoneCompletePublication($id);
$result=$sql_object->DBSelect($req_det);

// Do record exists?
if(!isset($result[0]['publi_title'])) redirect_to('@module_default');

$publi_title=formatText($result[0]['publi_title'], '2HTML');
$form_title=formatText($result[0]['publi_title'], '2FIELD');
$form_resume=formatText($result[0]['publi_resume'], '2FIELD');
if(empty($result[0]['publi_comment'])) $form_comment='';
else $form_comment=formatText($result[0]['publi_comment'], '2FIELD');
$form_level=$result[0]['publi_level'];
$form_scale=$result[0]['publi_scale'];

$form_author=formatText($result[0]['user_login'], '2FIELD');
$form_statut=$result[0]['publi_statut'];
$current_status=$result[0]['publi_statut'];
$publi_owner=$result[0]['publi_posted_by'];
$form_publication_date = $result[0]['publi_published_date_display'];
if (formatDate($form_publication_date, true) == formatDate('0001-01-01', true)) $form_publication_date = '';

// getting tags
include_once('../class/class.tag.php');
$otag = new tag();
$form_tags = $otag->getTags('publication', $id, true);

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('publication')) ReloadIndex('admin');
if ($l21auth->GetSessionElement('id')!=$publi_owner && !$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////
?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','publication'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('publication','mod'). ' : '. $publi_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
$publication_object= new publication;

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$publication_object->ModifyPublication($id, $data_table, $sql_object);
  
  if($result) {
  	$otag->modifyTags('publication', $id, $data_table['8']);
  }
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if($result) header("Location: ".$link_confirm);
  else  system_error();
}

if(isset($_POST['valider'])) {
  $table[0]=$_POST['publi_title'];
  $table[1]=$_POST['publi_resume'];
  $table[2]=$_POST['publi_level'];
  $table[3]=$_POST['publi_scale'];
  $table[4]=$_POST['publi_author'];
  $table[5]=$_POST['publi_comment'];
  $table[6]=$_POST['publi_statut'];
  $table[7]=$current_status; // statut courant
  $table[8]=$_POST['publi_tags'];
  if($table[6] != 'D') $table['publication_date'] = $_POST['publi_publication_date'];
  else $table['publication_date'] = formatDate('0001-01-01', true);

  $integrity=$publication_object->CheckDataIntegrity($table, $sql_object);

  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
    $table[4]=$integrity['user_id'];
  }
  $form_title=formatText($_POST['publi_title'], $text_format);
  $form_resume=formatText($_POST['publi_resume'], $text_format);
  $form_level=$_POST['publi_level'];
  $form_scale=$_POST['publi_scale'];
  $form_author=formatText($_POST['publi_author'], $text_format);
  $form_comment=formatText($_POST['publi_comment'], $text_format);
  $form_publication_date=$_POST['publi_publication_date'];
  $form_tags=formatText($_POST['publi_tags'], $text_format);

  if($_POST['publi_statut']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($_POST['publi_statut']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
  $table=urlencode(serialize($table));
}

// select-box statut
if($form_statut=='P') $mask_statut_P=' selected="selected"';
if($form_statut=='D') $mask_statut_D=' selected="selected"';
if($form_statut=='AA') $mask_statut_AA=' selected="selected"';
if($form_statut=='PA') $mask_statut_PA=' selected="selected"';
$select_statut="<select name=\"publi_statut\" id=\"publi_statut\">\n";
$select_statut.="<option value=\"P\"".$mask_statut_P.">".display_statut('P')."</option>\n";
$select_statut.="<option value=\"D\"".$mask_statut_D.">".display_statut('D')."</option>\n";
$select_statut.="<option value=\"AA\"".$mask_statut_AA.">".display_statut('AA')."</option>\n";
$select_statut.="<option value=\"PA\"".$mask_statut_PA.">".display_statut('PA')."</option>\n";
$select_statut.="</select>\n";


if(!isset($integrity) || is_string($integrity)) {

  // select-box des niveaux
  $data=$sql_object->DBSelect(SQL_getLevelsList());
  $select_level=LevelSelectBox($data, "publi_level", $form_level);

  // select-box des échelles
  $data=$sql_object->DBSelect($req_list_scale);
  $select_scale=ScaleSelectBox($data, "publi_scale", $form_scale);

}

?>

<?php
if(!isset($integrity) || is_string($integrity)) {
	
	
	// TextboxList CSS/JS inclusion
	addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.css');
	addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.Autocomplete.css');
	footerAddJS('../lib/js/TextboxList-jQuery/Source/GrowingInput.js');
	footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.js');
	footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.Autocomplete.js');
	
	// foundation Datepicker include
	addDynamicCSS('../lib/js/foundation-datepicker/stylesheets/foundation-datepicker.css');
	footerAddJS('../lib/js/foundation-datepicker/js/foundation-datepicker.js');
	?>
	<script type="text/javascript">
	<!--
	$(document).ready( function() {
					// Autocomplete initialization
					var t1 = new $.TextboxList('#publi_tags', {unique: true, plugins: {autocomplete: {onlyFromValues: false, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});
					$.ajax({url: '../admin/_ajax_tag_autocomplete.php', dataType: 'json', success: function(r){
						t1.plugins['autocomplete'].setValues(r);
					}});
					
					$("div.textboxlist").each(function() {
					    $(this).append('<p class="soft-emphase"><?php echo _t('msg','textboxlist_notice') ?><\/p>');
					});

					/** datePicker integration
					---------------------------------------------------*/
					$('.date-pick').fdatepicker({ 
						language: '<?php echo U_L; ?>',
						format: '<?php echo DATE_FORMAT; ?>'
					});
	});
	
	//-->
	</script>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2($publi_title); ?></h2>
<form id="modpublication" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
	<label for="publi_title"><?php echo mb_ucfirst(_t('publication','title')); ?> : *</label>
	<input name="publi_title" type="text" class="textfield" id="publi_title" maxlength="150" value="<?php echo $form_title; ?>" required />
</p>
<p>
	<label for="publi_resume"><?php echo mb_ucfirst(_t('publication','resume')); ?> : *</label>
	<textarea id="publi_resume" name="publi_resume"	class="largetextfield" <?php echo AREA_SETTINGS; ?> required><?php echo $form_resume; ?></textarea>
</p>
<p>
	<label for="publi_author"><?php echo mb_ucfirst(_t('publication','author')); ?> : *</label>
	<input name="publi_author" type="text" class="textfield" id="publi_author" maxlength="150" value="<?php echo $form_author; ?>" required />
</p>
<?php if($current_status == ('P' || 'AA' || 'PA')) { ?>
<p>
  <label for="publi_publication_date"><?php echo mb_ucfirst(_t('statut','published_on')); ?> : </label>
  <input name="publi_publication_date" type="text" maxlength="10" id="publi_publication_date" class="date-pick shorttextfield" value="<?php echo $form_publication_date; ?>" />
</p>
<?php } else { ?>
  <input name="publi_publication_date" type="hidden" value="<?php echo $form_publication_date; ?>" />
<?php } ?>
<p>
	<label for="publi_level"><?php echo mb_ucfirst(_t('publication','level')); ?> : </label>
	<?php echo $select_level; ?>
</p>
<p>
	<label for="publi_scale"><?php echo mb_ucfirst(_t('publication','scale')); ?> : </label>
	<?php echo $select_scale; ?>
</p>
<p>
  <label for="publi_tags"><?php echo mb_ucfirst(_t('tag','name')); ?> : </label>
  <input name="publi_tags" type="text" maxlength="500" id="publi_tags" class="textfield" value="<?php echo $form_tags; ?>" />
</p>
<p>
	<label for="publi_statut"><?php echo mb_ucfirst(_t('publication','statut')); ?> : </label>
	<?php echo $select_statut; ?> <br />
</p>
<p>
	<label for="publi_comment"><?php echo mb_ucfirst(_t('publication','comment')); ?> : </label>
	<textarea id="publi_comment" name="publi_comment" class="largetextfield" <?php echo AREA_SETTINGS; ?>>
	<?php echo $form_comment; ?>
	</textarea>
</p>
<div>
	<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
	<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
	<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
	<?php echo cancel_button('javascript:history.go(-1);'); ?>
	<input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
// Récapitulatif
} else	{
  
  // getting level name
	if($form_level==0) $level_name=empty_nc('');
	else {
		$record=$sql_object->DBSelect(SQL_getoneLevel($form_level));
		$level_name=formatText($record[0]['level_name'], '2HTML');
	}
	
  // getting scale name
  $r = $sql_object->DBSelect(SQL_getonescaleDenomination($form_scale));
  if(isset($r[0]['scale_denomination'])) {
  	$scale_denomination = formatText($r[0]['scale_denomination'], '2HTML');
  } else {
  	$scale_denomination = empty_none('');
  }
  
  $display_form_resume=empty_nc($form_resume);
  $display_form_comment=empty_nc($form_comment);

  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<?php
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('publication','title'))." :</dt>\n";
echo "<dd>". $form_title."</dd>\n";
echo "<dt>".mb_ucfirst( _t('publication','resume')). " :</dt>\n";
echo "<dd>".$display_form_resume."</dd>\n";
if($current_status == ('P' || 'AA' || 'PA')) { 
	echo "<dt>".mb_ucfirst(_t('statut','published_on'))." :</dt>\n";
	echo "<dd>".$form_publication_date."</dd>\n";
}
echo "<dt>".mb_ucfirst(_t('publication','level'))." :</dt>\n";
echo "<dd>".$level_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('publication','author'))." :</dt>\n";
echo "<dd>".$form_author."</dd>\n";
echo "<dt>".mb_ucfirst(_t('publication','scale'))." :</dt>\n";
echo "<dd>".$scale_denomination."</dd>\n";
echo "<dt>".mb_ucfirst(_t('tag','name'))." :</dt>\n";
echo "<dd>".empty_none(str_replace(',', ', ', $form_tags))."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','statut')) ." :</dt>\n";
echo "<dd>". display_statut($_POST['publi_statut']). "</dd>\n";
echo "<dt>".mb_ucfirst(_t('publication','comment')) ." :</dt>\n";
echo "<dd>". $display_form_comment. "</dd>\n";
echo "</dl>\n";
?>
<form id="modpublication" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
	<div>
		<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
		<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
		<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
		<input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
		<?php echo cancel_button('?rub=publication&amp;todo=list'); ?>
		<input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
		<input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
	</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php } ?>