<?php
/**
 * Resources module
 * 
 * Delete given ressource from back-office
 * 
 * @package linea21\modules\resources
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Resource' module is used by 'Publication' and 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

if(isset($_POST['valider'])) {
  $resources_object = new resources;
  if($res=='biblio') $result=$resources_object->DeleteBiblioRes($id, $sql_object);
  if($res=='multi') $result=$resources_object->DeleteMultiRes($id, $sql_object);
  if($res=='link') $result=$resources_object->DeleteLinkRes($id, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&type=".$type."&id=".$parent;
  if($result) header("Location: ".$link_confirm);
  else  system_error();
}

if($type=='P') {
  $requete= SQL_getPublicationTitle($parent);
  $result=$sql_object->DBSelect($requete);
  
  // Do record exists?
  if(!isset($result[0]['publi_title'])) redirect_to('publication');
  
  $current_title=FormatText($result[0]['publi_title'], '2HTML');
  $publi_owner=$result[0]['publi_posted_by'];

  //////////// Check Droits utilisateur ////////////
  if (!$l21auth->hasRight('publication')) ReloadIndex('admin');
  if ($l21auth->GetSessionElement('id')!=$publi_owner && !$l21auth->isSuperAdmin()) ReloadIndex('admin');
  ///////////


}
if($type=='W') {
  $requete= SQL_getWorkshopRepTitleAndGroup($parent);
  $result=$sql_object->DBSelect($requete);
  
  // Do record exists?
  if(!isset($result[0]['workrep_title'])) redirect_to('workshop');
  
  $current_title=FormatText($result[0]['workrep_title'].' ('.$result[0]['workshop_denomination'].')', '2HTML');
  $workshop_id=$result[0]['workrep_workshop_id'];

  //////////// Check Droits utilisateur ////////////
  if (!$l21auth->hasRight('workshop')) ReloadIndex('admin');
  if (!$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $workshop_id) && !$l21auth->isSuperAdmin()) ReloadIndex('admin');
  ///////////

}

if($res=='link') {
  $requete= SQL_getLinkInfo($id);
  $result=$sql_object->DBSelect($requete);
  
  // Do record exists?
  if(!isset($result[0]['linkres_mask']) && $type == 'W') redirect_to('workshop');
  if(!isset($result[0]['linkres_mask']) && $type == 'P') redirect_to('publication');
  
  $current_info=FormatText($result[0]['linkres_mask'], '2HTML');
  $type_display=_t('resources','link_res');
}
if($res=='multi') {
  $requete= SQL_getMultiInfo($id);
  $result=$sql_object->DBSelect($requete);
  
  // Do record exists?
  if(!isset($result[0]['multires_name']) && $type == 'W') redirect_to('workshop');
  if(!isset($result[0]['multires_name']) && $type == 'P') redirect_to('publication');
  
  $current_info=FormatText($result[0]['multires_name'], '2HTML');
  $type_display=_t('resources','multi_res');
}
if($res=='biblio') {
  $requete= SQL_getBiblioInfo($id);
  $result=$sql_object->DBSelect($requete);
  
  // Do record exists?
  if(!isset($result[0]['bibliores_title']) && $type == 'W') redirect_to('workshop');
  if(!isset($result[0]['bibliores_title']) && $type == 'P') redirect_to('publication');
  
  $current_info=FormatText($result[0]['bibliores_title']." <span class=\"text_det_it\">(".$result[0]['bibliores_author'].")</span>", '2HTML');
  $type_display=_t('resources','biblio_res');
}
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu',$mod_inc); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('resources',$mod_inc.'_type')." : ". $current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php echo "<h2>".formatTitleh2($current_title)."</h2>"; ?>
<form id="supresource" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
	<p class="info">
		<i class="icon-trash"></i>
		<?php
		echo _t('resources','supp_info')."'".$type_display."' "._t('resources','next')." \n";
		echo $current_info."\n";
		?>
	</p>
	<p><?php echo _t('divers','sup_confirm'); ?></p>
	<div>
		<input name="id" type="hidden" value="<?php echo $id; ?>" />
		<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
		<input name="res" type="hidden" value="<?php echo $res; ?>" id="res" />
		<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
		<input name="parent" type="hidden" value="<?php echo $parent; ?>" id="parent" />
		<input name="type" type="hidden" value="<?php echo $type; ?>" id="type" />
		<?php echo cancel_button($cancel_link); ?>
		<input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
	</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->