<?php
/**
 * Scale module
 * 
 * Modify given scale from back-office
 * 
 * @package linea21\core\scale
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

if (isset($_GET['id']))	$scale_id=$_GET['id'];
if (isset($_POST['id'])) $scale_id=$_POST['id'];

$scale_object= new scale;

$requete=SQL_getonescale($scale_id);
$data=$sql_object->DBSelect($requete, 'OBJECT');

// Do record exists?
if(!isset($data[0]->scale_denomination)) redirect_to('@module_default');

$current_title=formatText($data[0]->scale_denomination, '2HTML');
$current_scale_dependencies=$data[0]->scale_dependencies;
$current_root=$data[0]->scale_root;

$mask_statut_P='';
$mask_statut_D='';

if(isset($_POST['valider'])) {
  $table[0]=$_POST['denomination'];
  $table[1]=$_POST['surface'];
  $table[2]=$_POST['population'];
  $table[3]=$_POST['root_scale'];
  $table[4]=$_POST['com_scale'];
  $table[5]=$_POST['statut_scale'];
  $table[6]=$current_root;
  $table['cin']=$_POST['cin'];
  $table['extradata']='';
  $integrity=$scale_object->CheckDataIntegrity($table);

  if(is_string($integrity)) $format_text='2FIELD';
  else $format_text='2HTML';
  $form_denomination=formatText($_POST['denomination'], $format_text);
  $form_surface=$_POST['surface'];
  $form_population=$_POST['population'];
  $form_cin=$_POST['cin'];
  $form_comment=$_POST['com_scale'];
  $form_root_scale=$_POST['root_scale'];
  $form_statut_scale=$_POST['statut_scale'];
  $table=urlencode(serialize($table));
}

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$scale_object->ModifyScale($scale_id, $data_table, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$scale_id;
  if($result) header("Location: ".$link_confirm);
  else  system_error();
}

if(!isset($integrity)) {
  $requete=SQL_getonescale($scale_id);
  $data=$sql_object->DBSelect($requete, 'OBJECT');
  $form_denomination=formatText($data[0]->scale_denomination, '2FIELD');
  $form_surface=$data[0]->scale_surface;
  $form_population=$data[0]->scale_inhabitantsnumber;
  $form_cin=$data[0]->scale_cin;
  $form_root_scale=$data[0]->scale_root;
  $form_statut_scale=$data[0]->scale_statut;
  $form_comment=formatText($data[0]->scale_comment, '2FIELD');
}

if($form_statut_scale=='P') $mask_statut_P=' checked="checked"';
if($form_statut_scale=='D') $mask_statut_D=' checked="checked"';
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','scale')?></a></li>
	<li><span><?php echo _t('scale','mod') .' : '.formatNavTitle($current_title);?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php

if($current_scale_dependencies!=0) {
  include_once("../lib/input_helpers.php");
  // select-box des échelles
  $table_exclu=$scale_object->getMaxDepth($scale_id, $sql_object);
  $req_mod=SQL_getMaxScalesDepth($table_exclu["depth"], $table_exclu["exclusion"]);
  $data=$sql_object->DBSelect($req_mod);
  $select_root=ScaleSelectBox($data, "root_scale", $form_root_scale);

  // select box statut
  $select_statut="<label for=\"statut_P\" >".mb_ucfirst(_t('divers','statut')) ." : *</label>\n";
  $select_statut.="<input type=\"radio\" name=\"statut_scale\" id=\"statut_P\" value=\"P\"".$mask_statut_P." required /><span class=\"radio\">"._t('statut','public')."</span>\n";
  $select_statut.="<input type=\"radio\" name=\"statut_scale\" id=\"statut_D\" value=\"D\"".$mask_statut_D." /><span class=\"radio\">"._t('statut','draft')."</span>\n";
} else {
  $select_root  = empty_none('');
  $select_root .="<input type=\"hidden\" name=\"root_scale\" value=\"0\" id=\"root_scale\" />\n";
  $select_statut="<input type=\"hidden\" name=\"statut_scale\" value=\"P\" id=\"statut_scale\" />\n";
}


?>

<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2($current_title); ?></h2>
<form id="modscale" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
	<p>
		<label for="denomination"><?php echo mb_ucfirst(_t('scale','denomination')); ?> : *</label>
		<input name="denomination" type="text" id="denomination" maxlength="200" value="<?php echo $form_denomination; ?>" class="textfield" required />
	</p>
	<p>
		<label for="root_scale"><?php echo mb_ucfirst(_t('scale','root')); ?> : *</label>
		<?php echo $select_root; ?>
	</p>
	<p>
		<label for="surface"><?php echo mb_ucfirst(_t('scale','surface')); ?> (<?php echo SURFACE_UNIT; ?>) :</label>
		<input name="surface" type="text" id="surface" maxlength="8" value="<?php echo $form_surface; ?>" class="textfield" />
	</p>
	<p>
		<label for="population"><?php echo mb_ucfirst(_t('scale','population')); ?> :</label>
		<input name="population" type="text" id="population" maxlength="8" value="<?php echo $form_population; ?>" class="textfield" />
	</p>
	<p>
		<label for="cin"><?php echo mb_ucfirst(_t('scale','cin')); ?> :</label>
		<input name="cin" type="text" id="cin" maxlength="20" value="<?php echo $form_cin; ?>" class="textfield" />
	</p>
	<?php /*<p>
	<?php echo $select_statut; ?>
	</p>
	*/?>
	<p>
		<label for="com_scale"><?php echo mb_ucfirst(_t('scale','comment')); ?> : </label>
		<textarea id="com_scale" name="com_scale" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_comment; ?></textarea>
		<br />
	</p>
	<div>
		<input name="statut_scale" type="hidden" value="P" id="statut_P" />
		<input name="id" type="hidden" value="<?php echo $scale_id; ?>" id="scale_id" />
		<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
		<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
		<?php echo cancel_button('javascript:history.go(-1);'); ?>
		<input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
	</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
// Récapitulatif
} else	{
  $display_form_surface=empty_nc($form_surface);
  $display_form_population=empty_nc($form_population);
  $display_form_cin=empty_nc($form_cin);
  $display_form_comment=empty_none($form_comment);

  // sélection de l'échelle racine si elle en a une (!echelle root)
  if($current_scale_dependencies!=0) {
    $requete=SQL_getonescale($_POST['root_scale']);
    $data=$sql_object->DBSelect($requete);
    $display_root_scale="<dt>"._t('scale','root')." : </dt>\n";
    $display_root_scale.="<dd>".formatText($data[0]['scale_denomination'], '2HTML')."<br /></dd>\n";
  } else $display_root_scale='';
  $display_statut_scale=display_statut($form_statut_scale);
  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo _t('recap','title'); ?></h2>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('scale','denomination')); ?> :</dt>
	<dd><?php echo $form_denomination; ?></dd>
	<?php echo $display_root_scale; ?>
	<dt><?php echo mb_ucfirst(_t('scale','surface')); ?> (<?php echo SURFACE_UNIT; ?>) :</dt>
	<dd><?php echo fnumber_format($display_form_surface, 'auto', false); ?>
	</dd>
	<dt><?php echo mb_ucfirst(_t('scale','population')); ?> :</dt>
	<dd><?php echo fnumber_format($display_form_population, 0, false); ?></dd>
	<dt><?php echo mb_ucfirst(_t('scale','cin')); ?> :</dt>
	<dd><?php echo $display_form_cin; ?></dd>
	<?php /*<dt><?php echo mb_ucfirst(_t('divers','statut')); ?>: </dt>
	<dd><?php echo $display_statut_scale; ?><br /></dd> */ ?>
	<dt><?php echo mb_ucfirst(_t('scale','comment')); ?> :</dt>
	<dd><?php echo formatText($display_form_comment, '2HTML'); ?>
	</dd>
</dl>
<form id="addscale" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"
	method="post">
<div><input name="id" type="hidden" value="<?php echo $scale_id; ?>"
	id="scale_id" /> <input name="rub" type="hidden"
	value="<?php echo $rub; ?>" id="rub" /> <input name="todo"
	type="hidden" value="<?php echo $todo; ?>" id="todo" /> <input
	name="data_table" type="hidden" value="<?php echo $table; ?>"
	id="data_table" /> <?php echo cancel_button('?rub=scale&amp;todo=list'); ?>
<input name="retour" type="button"
	value="<?php echo _t('btn','preview') ?>" class="button" id="retour"
	onclick="history.go(-1);" /> <input name="enregistrer" type="submit"
	value="<?php echo _t('btn','save') ?>" class="button" id="valider" /></div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php } ?>