<?php
/**
 * Scale module
 * 
 * MySQL queries related to scale module
 * 
 * @package linea21\core\scale
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

$req_add = "SELECT scale_id, scale_denomination FROM " . T_SCALE . " WHERE scale_statut<>'E' AND scale_statut<>'I' AND scale_dependencies<" . (MAX_SCALE_LEVEL-1) . " ORDER BY scale_id;";

$req_quickbox_add = "SELECT scale_id, scale_denomination, DATE_FORMAT(scale_date_crea, '".toStringSqlDate('long')."') AS scale_date_crea_display FROM " . T_SCALE . " WHERE scale_statut  <> 'E' ORDER BY scale_date_crea DESC LIMIT 0 , 10;";

$req_quickbox_sup = "SELECT scale_id, scale_denomination, DATE_FORMAT(scale_date_crea, '".toStringSqlDate()."') AS scale_date_crea_display, DATE_FORMAT(scale_last_modify, '".toStringSqlDate('long')."') AS scale_last_modify_display FROM " . T_SCALE . " WHERE scale_statut  = 'E' ORDER BY scale_last_modify DESC
LIMIT 0 , 10;";

$req_quickbox_list = "SELECT scale_id, scale_denomination, DATE_FORMAT(scale_date_crea, '".toStringSqlDate()."') AS scale_date_crea_display, DATE_FORMAT(scale_last_modify, '".toStringSqlDate('long')."') AS scale_last_modify_display FROM " . T_SCALE . " WHERE scale_statut <> 'E' ORDER BY scale_last_modify DESC
LIMIT 0 , 10;";

function SQL_getMaxScalesDepth($depth, $except = -1)
{
  $requete = "SELECT scale_id, scale_denomination FROM " . T_SCALE . " WHERE scale_statut<>'E' AND scale_statut<>'I' AND scale_dependencies<" . $depth;
  if ($except != -1) {
    for($i = 0; $i < count($except); $i++) $requete .= " AND scale_id<>'" . $except[$i] . "'";
  }
  $requete .= " ORDER BY scale_id;";
  return $requete;
}

$req_list = "SELECT  DISTINCT s1.scale_id AS scale_id1, s1.scale_denomination AS scale_denomination1, s2.scale_id AS scale_id2, s2.scale_denomination AS scale_denomination2
			FROM " . T_SCALE . " s1
			LEFT  OUTER  JOIN " . T_SCALE . " s2 ON s2.scale_root = s1.scale_id
			ORDER  BY s1.scale_id, s1.scale_denomination, s2.scale_denomination;";

$req_list2 = "SELECT * FROM " . T_SCALE . " WHERE scale_statut<>'E' ORDER BY scale_dependencies DESC, scale_denomination ASC;";

function SQL_getdetscale($scale_id)
{
  $req_det = "SELECT s1.scale_denomination, s1.scale_surface, s1.scale_inhabitantsnumber, s1.scale_cin, s1.scale_extradata, s1.scale_root, s2.scale_denomination as scale_denomination_root, s1.scale_comment, s1.scale_dependencies, DATE_FORMAT(s1.scale_last_modify, '".toStringSqlDate('long')."') AS scale_last_modify, DATE_FORMAT(s1.scale_date_crea, '".toStringSqlDate()."') AS scale_date_crea, s1.scale_statut FROM " . T_SCALE . "  s1 LEFT  OUTER  JOIN " . T_SCALE . " s2 ON s1.scale_root = s2.scale_id WHERE s1.scale_id =" . $scale_id . ";";
  return $req_det;
}

function SQL_getonescale($scale_id)
{
  $req_one_scale = "SELECT scale_id, scale_denomination, scale_surface, scale_inhabitantsnumber, scale_cin, scale_extradata, scale_root, scale_comment, scale_dependencies, scale_statut FROM " . T_SCALE . " WHERE scale_statut<>'E' AND scale_id=" . $scale_id . ";";
  return $req_one_scale;
}

function SQL_getlistscale($scale_id)
{
  $req_sup = "SELECT scale_id, scale_denomination FROM " . T_SCALE . " WHERE scale_statut<>'E' AND scale_statut<>'I' AND scale_id<>'$scale_id' AND scale_dependencies<" . (MAX_SCALE_LEVEL-1) . " ORDER BY scale_range ASC, scale_id;";
  return $req_sup;
}
?>