<?php
/**
 * Indicator / SDI module
 * 
 * Clone an existing indicator
 * 
 * @package linea21\modules\sdi
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

$id=$_REQUEST['id'];

// 1 - we retrieve indicator info
$req_sdii=SQL_getInfoSdi($id);
$data = $sql_object -> DBSelect($req_sdii);
$info = array();

$suffix = ' ('._t('sdi', 'clone_suffix').')';

if(!isset($data[0]['sdii_name'])) system_error();

// and populate fields
$info[0] = formatText($data[0]['sdii_name'], '2HTML') . $suffix;
$info[1] = formatText($data[0]['sdii_description'], '2HTML');
$info[2] = formatText($data[0]['sdii_comment'], '2HTML');
$info[3] = $data[0]['sdii_level'];
$info[4] = 0; // range
$info[5] = formatText($data[0]['sdii_goal'], '2HTML');
$info[6] = formatText($data[0]['sdii_consulting'], '2HTML');
$info[7] = formatText($data[0]['sdii_unit'], '2HTML');
$info[8] = $data[0]['sdii_max_value'];
$info[9] = $data[0]['sdii_min_value'];
$info[10] = $data[0]['sdii_threshold_value'];
$info[11] = $data[0]['sdii_frequency'];
$info[12] = $data[0]['sdii_statut'];
$info[13] = $data[0]['sdii_threshold_relative'];
$info[14] = $data[0]['sdii_to_dashboard'];
$info[15] = $data[0]['sdii_type'];
$info[16] = $data[0]['sdii_dashboard_viz'];
$info[17] = $data[0]['sdii_detail_viz'];
$info[18] = $data[0]['sdii_value_type'];


// 2 - we retrieve Indicator evaluation
$data = $sql_object -> DBSelect(SQL_getEvaluation($id, $sql_object));

// and populate fields
$eval = array(
					$data[0]['sdie_scale_compare'],
					$data[0]['sdie_fiability'],
					$data[0]['sdie_accessibility'],
					$data[0]['sdie_lisibility'],
					$data[0]['sdie_relevance'],
					$data[0]['sdie_global_performance']
				);


// 3 - we retrieve Indicator provider
$data_provider = $sql_object -> DBSelect(SQL_getProvider($id, $sql_object));

// and populate fields
$provider = array(
							formatText($data_provider[0]['sdip_name'], '2HTML'),
							formatText($data_provider[0]['sdip_service'], '2HTML'),
							formatText($data_provider[0]['sdip_description'], '2HTML'),
							formatText($data_provider[0]['sdip_incharge'], '2HTML'),
							formatText($data_provider[0]['sdip_address'], '2HTML'),
							$data_provider[0]['sdip_phone'],
							$data_provider[0]['sdip_fax'],
							$data_provider[0]['sdip_email']
						);

// 4 - we retrieve Indicator rules
$reglementation = $sql_object -> DBSelect(SQL_getRules($id, $sql_object));

// and populate fields
$rules = array(
						formatText($reglementation[0]['sdir_title'], '2HTML'),
						formatText($reglementation[0]['sdir_body'], '2HTML'),
						formatText($reglementation[0]['sdir_referer_uri'], '2HTML'),
						formatText($reglementation[0]['sdir_mask_uri'], '2HTML')
					);

// 5 - Finally we create another indicator with collected informations
$sdi_object = new sdi;
$r = $sdi_object->AddSdi($info, $sql_object);
$result_e=$sdi_object->ModifyParam($r, $eval, "E", $sql_object);
$result_p=$sdi_object->ModifyParam($r, $provider, "P", $sql_object);
$result_r=$sdi_object->ModifyParam($r, $rules, "R", $sql_object);

$link_confirm="confirm.php?rub=".$rub."&todo=clone&id=".$r;
if(is_numeric($r)) header("Location: ".$link_confirm);
else  system_error();
?>