<?php
/**
 * Indicator / SDI module
 * 
 * Display indicators /SDI list in back-office
 * 
 * @package linea21\modules\sdi
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////
include_once(override('../level/mysql.inc.php', THEME_ADMIN_PATH));

// we get levels
$result=$sql_object->DBSelect(SQL_getLevelsList());
$sdi_object= new sdi;

// we get indicators
$sdi = $sql_object->DBSelect(SQL_getListSdi("R"));


function display_level($parent, $dep, $array, $rub_link, $sdi) {
	$html = "";
	$prev_dep = 0;
	$link_sup=$rub_link."&amp;todo=sup&amp;id=";
	$link_mod=$rub_link."&amp;todo=mod&amp;id=";
	$link_det=$rub_link."&amp;todo=det&amp;id=";
	$link_level="index.php?rub=level&amp;todo=det&amp;id=";

	if (!$dep && !$prev_dep) $html .= "\n<ul>\n";
	foreach ($array as $item) {

		$current_id = $item['level_id'];
		$current_shortname = formatText($item['level_name'], '2HTML');
		$current_name = formatText( $item['level_label'], '2HTML') . ' : ' . formatText($item['level_name'], '2HTML');
		
		if ($parent == $item['level_parent']) {
			
			// we prepare indicators if they are attached to current level
			$sdi_html = '';
			for ($j=0; $j < count($sdi); $j++) {
				if ($current_id == $sdi[$j]['sdii_level']) {
					if(empty($sdi_html)) $sdi_html.="<ul>\n";
			
					// we populate lists
					$sdi_html.="<li class=\"contextual-menu li-indicator\">\n";
					$sdi_html.="\t<a href=\"".$link_det.$sdi[$j]['sdii_id']."\" title=\"".formatText($sdi[$j]['sdii_name'], '2HTML')."\">".cutText(formatText($sdi[$j]['sdii_name'], '2HTML'), 200, 1)."</a>\n";
					if ($sdi[$j]['sdii_statut']=='D') $sdi_html.="<span class=\"state\"> / "._t('statut','draft')."</span>";
					if ($sdi[$j]['sdii_to_dashboard']=='N') $sdi_html.="<span class=\"state\"> / "._t('sdi','not_attached_to_dashboard')."</span>";
					$sdi_html.="\t<a href=\"".$link_sup.$sdi[$j]['sdii_id']."\" title=\""._t('sdi','sup')."\" class=\"ico_sup\"><i class=\"icon-trash\"></i><span>" . _t('sdi','sup') . "</span></a>\n";
					$sdi_html.="\t<a href=\"".$link_mod.$sdi[$j]['sdii_id']."\" title=\""._t('sdi','mod')."\" class=\"ico_mod\"><i class=\"icon-pencil\"></i><span>" . _t('sdi','mod') . "</span></a>\n";
					$sdi_html.="</li>\n";
				}
			}
			if(!empty($sdi_html)) $sdi_html .= "</ul>\n";
			
			if ($prev_dep < $dep) $html .= "\n<ul>\n";

			$link =	"\t<a href=\"".$link_level.$current_id."\" title=\"".$current_name."\">" . $current_shortname. "</a>\n";

			$html .= "<li class=\"li".$dep."\">" . $link;
			$html .= $sdi_html;
			
			$prev_dep = $dep;
			$html .= display_level($item['level_id'], ($dep + 1), $array, $rub_link, $sdi);
		}
	}
	if (($prev_dep == $dep) && ($prev_dep != 0)) $html .= "</ul>\n</li>\n";
	else if ($prev_dep == $dep) $html .= "</ul>\n";
	else $html .= "</li>\n";
	return $html;
}


?>
<div id="chemin">
  <ul>
  	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
  	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','sdi');?></a></li>
  	<li><span><?php echo _t('sdi','list'); ?></span></li>
  </ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
<div id="content">
  <div id="tree">
    <?php echo display_level(0,0,$result, $rub_link, $sdi); ?>
  </div>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->