<?php
/**
 * Indicator / SDI module - modify indicator main information
 * 
 * Modify given main information indicator from back-office
 * 
 * @package linea21\modules\sdi
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////


include_once("../lib/input_helpers.php");
include_once(override('../level/mysql.inc.php', THEME_ADMIN_PATH));

if(!isset($_GET['id']) && !isset($_POST['id'])) {
  $id="1";
} else {
  if(isset($_REQUEST['id']))	$id=$_REQUEST['id'];
}

$link_mod_e=$rub_link."&amp;todo=mod_e&amp;id=";
$link_mod_r=$rub_link."&amp;todo=mod_r&amp;id=";
$link_mod_p=$rub_link."&amp;todo=mod_p&amp;id=";


if (isset($_POST['enregistrer'])) {

  $data_table = unserialize(urldecode($_POST['data_table']));
  $sdi_object= new sdi;

  $result=$sdi_object->ModifySdi($id, $data_table, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id;
  if(isset($result)) header("Location: ".$link_confirm);
  else  system_error();
}

$sdi_object= new sdi;
$req_sdii=SQL_getInfoSdi($id);
$data_form_sdi = $sql_object -> DBSelect($req_sdii);

// Do record exists?
if(!isset($data_form_sdi[0]['sdii_name'])) redirect_to('@module_default');

$form_name = formatText($data_form_sdi[0]['sdii_name'], '2FIELD');
$form_level =  $data_form_sdi[0]['sdii_level'];
//$form_range =  $data_form_sdi[0]['sdii_range'];
$form_description =  formatText($data_form_sdi[0]['sdii_description'], '2FIELD');
$form_comment =  formatText($data_form_sdi[0]['sdii_comment'], '2FIELD');
$form_goal =  formatText($data_form_sdi[0]['sdii_goal'], '2FIELD');
$form_consulting = formatText($data_form_sdi[0]['sdii_consulting'], '2FIELD');
$form_unit =  formatText($data_form_sdi[0]['sdii_unit'], '2FIELD');
$form_max_value =  $data_form_sdi[0]['sdii_max_value'];
$form_min_value =  $data_form_sdi[0]['sdii_min_value'];
$form_threshold_value = $data_form_sdi[0]['sdii_threshold_value'];
$form_frequency = $data_form_sdi[0]['sdii_frequency'];
$form_type = $data_form_sdi[0]['sdii_type'];
$form_dashboard_viz = $data_form_sdi[0]['sdii_dashboard_viz'];
$form_detail_viz = $data_form_sdi[0]['sdii_detail_viz'];
$form_value_type = $data_form_sdi[0]['sdii_value_type'];

if($data_form_sdi[0]['sdii_statut']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
if($data_form_sdi[0]['sdii_statut']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
if($data_form_sdi[0]['sdii_to_dashboard']=='Y')  $mask_dashboard="checked=\"checked\""; else $mask_dashboard='';
if($data_form_sdi[0]['sdii_threshold_relative']=='Y')  $mask_threshold_relative="checked=\"checked\""; else $mask_threshold_relative='';

if (isset($_POST['valider1'])) {

  $table[0] = $_POST['sdi_name'];
  $table[1] = $_POST['description'];
  $table[2] = $_POST['comment'];
  $table[3] = $_POST['sdi_level'];
  //$table[4] = $_POST['range'];
  $table[4] = 0;
  $table[5] = $_POST['goal'];
  $table[6] = $_POST['consulting'];
  $table[7] = $_POST['unit'];
  $table[8] = $_POST['max_value'];
  $table[9] = $_POST['min_value'];
  $table[10]= $_POST['threshold_value'];
  $table[11]= $_POST['frequency'];
  $table[12]= $_POST['sdi_statut'];


  if (isset($_POST['threshold_relative'])) {
  	$table[13]="Y";
  	$mask_threshold_relative="checked=\"checked\"";
  } else {
  	$table[13]="N";
  	$mask_threshold_relative="";
  }
  
  if (isset($_POST['attached_to_dashboard'])) {
  	$table[14]="Y";
  	$mask_dashboard="checked=\"checked\"";
  } else {
  	$table[14]="N";
  	$mask_dashboard="";
  }

  $table[15]=$_POST['sdi_type'];
  $table[16]=$_POST['sdi_dashboard_viz'];
  $table[17]=$_POST['sdi_detail_viz'];
  $table[18]=$_POST['sdi_value_type'];

  $sdi_object = new sdi;
  $integrity = $sdi_object -> CheckDataIntegrity_info($table, true, 15);

  $form_type = $_POST['sdi_type'];
  $form_dashboard_viz = $_POST['sdi_dashboard_viz'];
  $form_detail_viz = $_POST['sdi_detail_viz'];
  $form_value_type = $_POST['sdi_value_type'];
  $form_name = formatText($_POST['sdi_name'], '2FIELD');
  $form_level = $_POST['sdi_level'];
  $form_statut =$_POST['sdi_statut'];
  //$form_range = $_POST['range'];
  $form_description = formatText($_POST['description'], '2FIELD');
  $form_comment = formatText($_POST['comment'], '2FIELD');
  $form_goal = formatText($_POST['goal'], '2FIELD');
  $form_consulting = formatText($_POST['consulting'], '2FIELD');
  $form_unit = formatText($_POST['unit'], '2FIELD');
  $form_max_value = $_POST['max_value'];
  $form_min_value = $_POST['min_value'];
  $form_threshold_value = $_POST['threshold_value'];
  $form_threshold_relative=$table[13];
  $form_frequency = $_POST['frequency'];

  if($form_statut=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($form_statut=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';

  $table = urlencode(serialize($table));

}

// select-box des niveaux
$data=$sql_object->DBSelect(SQL_getLevelsList());
$select_level=LevelSelectBox($data, "sdi_level", $form_level);

$select_type=selectBox($lang['sdi']['select_type'], "sdi_type", $form_type);
$select_dashboard_viz = selectBox($lang['sdi']['select_dashboard_viz'], "sdi_dashboard_viz", $form_dashboard_viz, INDICATOR_DASHBOARD_VIZ);
$select_detail_viz = selectBox($lang['sdi']['select_detail_viz'], "sdi_detail_viz", $form_detail_viz);
$select_value_type = selectBox($lang['sdi']['select_value_type'], "sdi_value_type", $form_value_type);

$req_list_sdiname=SQL_getOnesdiname($id);
$data_sdi_name = $sql_object -> DBSelect($req_list_sdiname);
$navtitle=_t('sdi','mod')." : ".$data_sdi_name[0]['sdii_name'];
?>
<div id="chemin">
  <ul>
  	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
  	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','sdi')?></a></li>
  	<li><span><?php echo formatnavTitle($navtitle) ?></span></li>
  </ul>
</div>
<?php
if (!isset($integrity) || is_string($integrity)) {
	
	$js = '
	$("#sdi_type").change(function() {
		
	if($(this).val() == "boolean" || $(this).val() == "qualitative") {

 		if($(this).val() == "qualitative") var text = "'.sprintf(_t('sdi','qualindicator_notice'), '#attached_to_dashboard').'";
 		else var text = "'.sprintf(_t('sdi','boolindicator_notice'), '#attached_to_dashboard').'";
		
		$("#boolean-indic-notice").remove();
		$("#sdi_dashboard_viz option[value=\'sparkline\']").attr("disabled", "disabled");
	
		if($("#sdi_dashboard_viz").val() == "sparkline") $("#sdi_dashboard_viz option[value=\'raw\']").attr("selected", "selected");
		$("#sdi_type").after("<span class=\"soft-emphase input-notice\" id=\"boolean-indic-notice\">" + text + "<\/span>");
		
	} else {
	
		$("#sdi_dashboard_viz option[value=\'sparkline\']").removeAttr("disabled");
		$("#boolean-indic-notice").remove();
	}
		
	});
	
	// we call the function on loading page
	$("#sdi_type").change();
	';
	
	footerAddInlineJS($js);
	
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if (isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<div class="mod_link">
<a href="<?php echo $link_mod_e.$id ;?>"><?php echo _t('sdi','modify_sdi_e');?></a><!-- @whitespace
--><a href="<?php echo $link_mod_p.$id ;?>"><?php echo _t('sdi','modify_sdi_p');?></a><!-- @whitespace
--><a href="<?php echo $link_mod_r.$id ;?>"><?php echo _t('sdi','modify_sdi_r');?></a>
</div>
<br class="brendstep" />
<h2><?php echo mb_ucfirst(_t('sdi','mod_title')); ?></h2>
<div class="subtitle" id="indicator-subtitle"><?php echo formatText($data_sdi_name[0]['sdii_name'], '2HTML'); ?></div>

<form id="addsdi" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
	<label for="sdi_name"><?php echo mb_ucfirst(_t('sdi','name2')) ?> : *</label>
	<input name="sdi_name" type="text" class="textfield" id="sdi_name" maxlength="255" value="<?php echo $form_name; ?>" required />
</p>

<p>
  	<label for="sdi_type"><?php echo mb_ucfirst(_t('sdi','type')) ?> : *</label>
  	<?php echo $select_type; ?>
</p>

<p>
  	<label for="sdi_dashboard_viz"><?php echo mb_ucfirst(_t('sdi','dashboard_viz')) ?> : *</label>
  	<?php echo $select_dashboard_viz; ?>
</p>
<p>
  	<label for="sdi_detail_viz"><?php echo mb_ucfirst(_t('sdi','detail_viz')) ?> : *</label>
  	<?php echo $select_detail_viz; ?>
</p>
<p>
  	<label for="sdi_value_type"><?php echo mb_ucfirst(_t('sdi','value_type')) ?> : *</label>
  	<?php echo $select_value_type; ?>
</p>
<p>
	<label for="sdi_level"><?php echo mb_ucfirst(_t('sdi','level')) ?> : *</label>
	<?php echo $select_level; ?>
</p>
<div class="label"><?php echo mb_ucfirst(_t('divers','statut')); ?> : </div>
<div class="rightpanel">
	<input name="sdi_statut" type="radio" id="statut_P" value="P" <?php echo $mask_statut_P; ?> required />
	<label for="statut_P"><?php echo mb_ucfirst(_t('statut','public')); ?></label>
	<input name="sdi_statut" type="radio" id="statut_D" value="D" <?php echo $mask_statut_D; ?> />
	<label for="statut_D"><?php echo mb_ucfirst(_t('statut','draft')); ?></label>
</div>

<?php
/** <p>
<label for="range" ><?php echo mb_ucfirst(_t('sdi','range')) ?> : *</label>
<input name="range" type="text" class="textfield" id="range" maxlength="150" value="<?php echo $form_range;
?>" />
</p> */
?>
<p>
	<label for="description"><?php echo mb_ucfirst(_t('sdi','description')) ?> : *</label>
	<textarea id="description" name="description" <?php echo AREA_SETTINGS; ?> class="largetextfield" required><?php echo $form_description; ?></textarea>
</p>
<p>
	<label for="goal"><?php echo mb_ucfirst(_t('sdi','goal')) ?> :</label>
	<textarea id="goal" name="goal" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_goal; ?></textarea>
</p>
<p>
	<label for="consulting"><?php echo mb_ucfirst(_t('sdi','consulting')) ?> :</label>
	<textarea id="consulting" name="consulting" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_consulting; ?></textarea>
</p>
<div class="mts">
	<div class="label"><?php echo mb_ucfirst(_t('sdi','attached_to_dashboard')); ?> :</div>
	<div class="rightpanel">
	<input type="checkbox" class="checkbox-switch" name="attached_to_dashboard" value="1" id="attached_to_dashboard" <?php echo $mask_dashboard; ?> />
		<label for="attached_to_dashboard"></label>
	</div>
</div>
<p>
	<label for="comment"><?php echo mb_ucfirst(_t('sdi','comment')) ?> :</label>
	<textarea id="comment" name="comment" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_comment; ?></textarea>
</p>

<h3 class="part"><?php echo mb_ucfirst(_t('sdi','info_mesure')); ?></h3>

<p>
	<label for="unit"><?php echo mb_ucfirst(_t('sdi','unit')) ?> : *</label>
	<input name="unit" type="text" class="textfield" id="unit" maxlength="100" value="<?php echo $form_unit; ?>" required />
</p>
<p>
	<label for="min_value"><?php echo mb_ucfirst(_t('sdi','min_value')) ?> : </label>
	<input name="min_value" type="text" class="textfield" id="min_value" maxlength="100" value="<?php echo $form_min_value; ?>" />
</p>
<p>
	<label for="max_value"><?php echo mb_ucfirst(_t('sdi','max_value')) ?> : </label>
	<input name="max_value" type="text" class="textfield" id="max_value" maxlength="6" value="<?php echo $form_max_value; ?>" />
</p>
<p>
	<label for="threshold_value"><?php echo mb_ucfirst(_t('sdi','initial_threshold_value')) ?> : </label>
	<input name="threshold_value" type="text" class="textfield" id="threshold_value" maxlength="100" value="<?php echo $form_threshold_value; ?>" />
</p>
<p>
	<label for="frequency"><?php echo mb_ucfirst(_t('sdi','frequency')) ?> : *</label>
	<input name="frequency" type="text" class="textfield" id="frequency" maxlength="11" value="<?php echo $form_frequency; ?>" required />
</p>
<div class="label"><?php echo mb_ucfirst(_t('sdi','threshold_relative')) ?> : *</div>
<div class="rightpanel">
	<input type="checkbox" name="threshold_relative" id="threshold_relative" <?php echo $mask_threshold_relative; ?> />
  <label for="threshold_relative"><?php echo _t('sdi','threshold_relative_comment') ?></label>
</div>

<div>
  <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
  <?php echo cancel_button($rub_link."&amp;todo=det&amp;id=".$id); ?>
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <input name="valider1" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
            // Récapitulatif
} else {
  if (!isset($integrity5) || is_string($integrity5)) {


    $table=unserialize(urldecode($table));

    $display_sdi_name = formatText(empty_nc($table[0]), '2HTML');
    $display_sdi_description =formatText(empty_nc($table[1]), '2HTML');
    $display_sdi_comment =formatText(empty_nc($table[2]), '2HTML');
    //$display_sdi_range = empty_nc($table[4]);
    $display_sdi_goal = formatText(empty_nc($table[5]), '2HTML');
    $display_sdi_consulting = formatText(empty_nc($table[6]), '2HTML');
    $display_sdi_unit = formatText(empty_nc($table[7]), '2HTML');
    $display_sdi_max_value = empty_nc(fnumber_format($table[8], 'auto', false));
    $display_sdi_min_value = empty_nc(fnumber_format($table[9], 'auto', false));
    $display_sdi_threshold_value = empty_none(fnumber_format($table[10], 'auto', false));
    $display_sdi_frequency = empty_nc(fnumber_format($table[11], 'auto', false));
    $display_sdi_statut = empty_nc($table[12]);
    $record=$sql_object->DBSelect(SQL_getoneLevel($table[3]));
    $display_sdi_level=formatText($record[0]['level_name'], '2HTML');

    if ($table[13]=='Y') $display_sdi_threshold_relative = _t('sdi','threshold_relative_Y');
    else $display_sdi_threshold_relative = _t('sdi','threshold_relative_N');

    if ($table[14]=='Y') $display_attached_to_dashboard = _t('divers','yes');
    else $display_attached_to_dashboard = _t('divers','no');

    $display_sdi_type = formatText($lang['sdi']['select_type'][$table[15]], '2HTML');
    $display_sdi_dashboard_viz = formatText($lang['sdi']['select_dashboard_viz'][$table[16]], '2HTML');
    $display_sdi_detail_viz = formatText($lang['sdi']['select_detail_viz'][$table[17]], '2HTML');
    $display_sdi_value_type = formatText($lang['sdi']['select_value_type'][$table[18]], '2HTML');

    $table = urlencode(serialize($table));

    ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));

?>
<div id="content">
<h2><?php echo mb_ucfirst(_t('recap','title')); ?></h2>
<div class="subtitle" id="indicator-subtitle"><?php echo formatText($data_sdi_name[0]['sdii_name'], '2HTML'); ?></div>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('sdi','name2')); ?> :</dt>
	<dd><?php echo $display_sdi_name; ?></dd>
	<?php /*
	<dt><?php echo mb_ucfirst(_t('sdi','type')) ?> : </dt>
	<dd><?php echo mb_ucfirst($display_sdi_type);?></dd>
	*/ ?>
	<dt><?php echo mb_ucfirst(_t('sdi','dashboard_viz')) ?> : </dt>
	<dd><?php echo mb_ucfirst($display_sdi_dashboard_viz);?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','detail_viz')) ?> : </dt>
	<dd><?php echo mb_ucfirst($display_sdi_detail_viz);?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','value_type')) ?> : </dt>
	<dd><?php echo mb_ucfirst($display_sdi_value_type);?></dd>
	<dt><?php echo mb_ucfirst(_t('divers','statut')); ?> :</dt>
	<dd><?php echo display_statut($display_sdi_statut); ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','level')); ?> :</dt>
	<dd><?php echo $display_sdi_level; ?></dd>
	<?php
	/*<dt><?php echo mb_ucfirst(_t('sdi','range')); 	?> :</dt>
	<dd><?php echo $display_sdi_range; ?><br /></dd> */
	?>
	<dt><?php echo mb_ucfirst(_t('sdi','description')); ?> :</dt>
	<dd><?php echo $display_sdi_description; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','goal')); ?> :</dt>
	<dd><?php echo $display_sdi_goal; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','consulting')); ?> :</dt>
	<dd><?php echo $display_sdi_consulting; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','attached_to_dashboard'));	?> :</dt>
	<dd><?php echo $display_attached_to_dashboard;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','comment')); ?> :</dt>
	<dd><?php echo $display_sdi_comment; ?></dd>
</dl>
<h3 class="part"><?php echo mb_ucfirst(_t('sdi','info_mesure')); ?></h3>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('sdi','unit')); ?> :</dt>
	<dd><?php echo $display_sdi_unit; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','min_value')); ?> :</dt>
	<dd><?php echo $display_sdi_min_value;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','max_value')); ?> :</dt>
	<dd><?php echo $display_sdi_max_value; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','initial_threshold_value'));	?> :</dt>
	<dd><?php echo $display_sdi_threshold_value; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','threshold_relative'));	?> :</dt>
	<dd><?php echo $display_sdi_threshold_relative;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','frequency')); ?> :</dt>
	<dd><?php echo $display_sdi_frequency;	?></dd>
</dl>
<form id="addsdi5" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <div>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
    <?php echo cancel_button($rub_link."&amp;todo=det&amp;id=".$id); ?>
    <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
    <input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
  }
}
?>