<?php
/**
 * Tag module
 * 
 * MySQL queries related to tag module
 * 
 * @package linea21\core\tag
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

// ////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
// //////////


$req_liste = "SELECT * FROM " . T_TAG . " WHERE level_statut<>'E' ORDER BY level_range ASC;";

$q_quickbox = "SELECT tag_id, tag_name, DATE_FORMAT(tag_last_modify, '".toStringSqlDate('long')."') AS tag_last_modify_display, tag_last_modify, DATE_FORMAT(tag_date_crea, '".toStringSqlDate()."') AS tag_date_crea_display  
						FROM " . T_TAG . "
						ORDER BY tag_last_modify DESC
						LIMIT 0 , 10;";

function SQL_getTags() 
{	
	$q = 'SELECT *, count(jta_id) as counter, DATE_FORMAT(tag_date_crea, \''.toStringSqlDate().'\') AS tag_date_crea_display FROM '. T_TAG .' LEFT OUTER JOIN '. J_TAG .' ON jta_tag_id = tag_id 	GROUP BY jta_tag_id';
	return $q;
}

function SQL_getNewsByTag($tag_id)
{
	$q = 'SELECT N.* FROM '. T_NEWS .' AS N 
	LEFT OUTER JOIN '. J_TAG .' ON jta_module_id = news_id
	LEFT OUTER JOIN '. T_TAG .' AS T ON jta_tag_id = tag_id
	WHERE jta_module = \'news\' AND news_statut <> \'E\' AND jta_tag_id = '.$tag_id.' ORDER BY news_range ASC, news_published_date DESC';
	return $q;
}

function SQL_getProjectsByTag($tag_id)
{
	$q = 'SELECT P.* FROM '. T_PROJECT .' AS P
	LEFT OUTER JOIN '. J_TAG .' ON jta_module_id = project_id
	LEFT OUTER JOIN '. T_TAG .' AS T ON jta_tag_id = tag_id
	WHERE jta_module = \'project\' AND project_statut <> \'E\' AND jta_tag_id = '.$tag_id.' ORDER BY project_range ASC, project_published_date DESC';
	return $q;
}

function SQL_getPublicationsByTag($tag_id)
{
	$q = 'SELECT P.* FROM '. T_PUBLI .' AS P
	LEFT OUTER JOIN '. J_TAG .' ON jta_module_id = publi_id
	LEFT OUTER JOIN '. T_TAG .' AS T ON jta_tag_id = tag_id
	WHERE jta_module = \'publication\' AND publi_statut <> \'E\' AND jta_tag_id = '.$tag_id.' ORDER BY publi_published_date DESC';
	return $q;
}

function SQL_getTag($id)
{
  $q = "SELECT tag_id, tag_name, tag_comment, DATE_FORMAT(tag_last_modify, '".toStringSqlDate('long')."') AS tag_last_modify_display, tag_last_modify, DATE_FORMAT(tag_date_crea, '".toStringSqlDate()."') AS tag_date_crea_display  
						FROM " . T_TAG . " WHERE tag_id = ".$id.";";
  return $q;
}


?>