<?php
/**
 * @package linea21\templates\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

// do we allow access only to authentified users
if(defined('FORCE_PUBLIC_AUTH') && FORCE_PUBLIC_AUTH == 1) {
	if(!$l21auth->isAuthenticated() && ActiveItemKey($_REQUEST['rub'])!='user-prefs' && ActiveItemKey($_REQUEST['rub'])!='forgot-password') {
	 	header("Location: ".CURRENT_APP_URL."index.php?rub=".$GLOBALS['links'][U_L]['user-prefs']['linkvalue']);
	 	exit;
	}
}
include_once('../class/class.page.php');
include_once(override('../page/display.php'));
include_once(override('../page/'.SQL.'.inc.php'));

if(isset($debugbar)) {
	$debugbar['time']->startMeasure('header', '... loading Header files');
}
?>

<!DOCTYPE html>
<!--[if lte IE 7 ]><html class="no-js ie67 ie678" lang="<?php echo U_L; ?>"> <![endif]-->
<!--[if IE 8 ]><html class="no-js ie8 ie678" lang="<?php echo U_L; ?>"> <![endif]-->
<!--[if IE 9]><html class="no-js ie9" lang="<?php echo U_L; ?>"> <![endif]-->
<!--[if gt IE 9]> <!--><html class="no-js" lang="<?php echo U_L; ?>"> <!--<![endif]-->
<?php distInclude(THEME_PUBLIC_PATH.'header.php', THEME_PUBLIC_DIST); ?>

<?php if(isset($debugbar)) $debugbar['time']->stopMeasure('header'); ?>

<body>
<?php culture::getInstance()->renderSwitcher(); ?>
<header id="header" role="banner" class="line pam">
	<div class="mw1140p center">
	  <img src="<?php echo THEME_PUBLIC_PATH; ?>images/logo.png" alt="<?php echo (SITE_NAME); ?>" />
	  <h1><?php echo (SITE_NAME); ?></h1>
  </div>
</header><!-- End Header -->
<div class="menu-wrap">
	<nav id="menu" role="navigation" class="mw1140p center">
	  <?php 
	  if(function_exists('dynamicMenu')) {
	  	echo dynamicMenu(0);
	  } else {
	  	echo DisplayMenu();
	  } ?>
	</nav>
</div>
<!-- End Menu -->
<?php if(defined('AJAX_LOGIN') && AJAX_LOGIN == 1) prepareAjaxLogin(); ?>
<div id="main-container"> <!-- do not remove / used by default to insert breadcrumb -->
<section id="main-section" role="main" class="grid pam clear mw1140p center">
<div id="content" class="grid3-1 section_<?php echo ActiveItemKey($GLOBALS['activeitem']); ?> alias_<?php echo ActiveItemAlias($GLOBALS['activeitem']);?> <?php echo getItemId(); ?>">
  <div id="main"><!-- Begin Page -->
  	<div id="printer">
  		<a href="javascript:self.print();" class="button" title="<?php echo _t('divers','print'); ?>"><span><?php echo _t('divers','print'); ?></span></a>
    </div>
    	<?php if(isset($debugbar)) $debugbar['time']->startMeasure('template', '... loading main template'); ?>
    	<?php DisplayTemplate(); ?>
    	<?php if(isset($debugbar)) $debugbar['time']->stopMeasure('template'); ?>
  </div> <!-- End Page -->
  <aside class="">
  	<?php if(isset($debugbar)) $debugbar['time']->startMeasure('sidebar', '... loading sidebar'); ?>
    <?php distInclude(THEME_PUBLIC_PATH.'sidebar.php', THEME_PUBLIC_DIST); ?>
    <?php if(isset($debugbar)) $debugbar['time']->stopMeasure('sidebar'); ?>
  </aside><!-- End Sidebar -->
</div> <!-- End Content -->
</section>

<!-- Footer -->
<?php if(isset($debugbar)) $debugbar['time']->startMeasure('footer', '... loading footer'); ?>
<footer id="footer" role="contentinfo" class="line pam txtcenter">
<div class="mw1140p center">
  <div>
  	<?php displayDefaultFooter(); ?>
  	<p class="version">Linea21 (v <?php echo LINEA_VERSION; ?>), <?php printf(_t('divers','licence') ,'<a href="http://opensource.org/licenses/gpl-3.0.html" title="GNU GPL v3" class="out">GNU GPL v3</a>'); ?></p>
  </div>
</div> <!-- End mw1140p -->
</footer>
<!-- End Footer -->
<?php AddDynamicFooter(); ?>
</div> <!-- End #main-container -->
<?php if(isset($debugbar)) $debugbar['time']->stopMeasure('footer'); ?>
<?php if(isset($debugbar)) echo $debugbarRenderer->render(); ?>
<script>
//Create a clone of the menu, right next to original.
jQuery(function($) {
	$('.menu-wrap').addClass('original').clone().insertAfter('.menu-wrap').addClass('cloned').css('position','fixed').css('top','0').css('margin-top','0').css('z-index','500').removeClass('original').hide();
	scrollIntervalID = setInterval(stickIt, 10);
});


function stickIt() {

	if($( window ).width() < 768) return;
  var orgElementPos = $('.original').offset();
  orgElementTop = orgElementPos.top;               

  if ($(window).scrollTop() >= (orgElementTop)) {
    // scrolled past the original position; now only show the cloned, sticky element.

    // Cloned element should always have same left position and width as original element.     
    orgElement = $('.original');
    coordsOrgElement = orgElement.offset();
    leftOrgElement = coordsOrgElement.left;  
    widthOrgElement = orgElement.css('width');
    $('.cloned').css('left',leftOrgElement+'px').css('top',0).css('width',widthOrgElement).show();
    $('.original').css('visibility','hidden');
  } else {
    // not scrolled past the menu; only show the original menu.
    $('.cloned').hide();
    $('.original').css('visibility','visible');
  }
}
</script>
<script src="<?php echo THEME_PUBLIC_PATH; ?>/js/responsive-menu.js"></script>
</body>
</html>