<?php
/**
 * User module
 * 
 * Provide information regarding latest administration tasks
 * 
 * @package linea21\core\user
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

$qbx_module = _t('menu','user');

if ($todo == 'add') {
  $result = $sql_object->DBSelect($req_quickbox_add);
  $qbx_liste = '';
  $nb = '';
  if ($result == 0) {
    $qbx_liste .= "<li class=\"no-data\">" . _t('divers','nodata') . "</li>";
  } else {
    if (count($result) >= 10) $nb = 10;
    else $nb = count($result);
    for($i = 0; $i < count($result); $i++) {
      $fullname = '';
      if(!empty($result[$i]['profile_firstname']) || $result[$i]['profile_lastname']) {
    	$fullname = ' ('. $result[$i]['profile_firstname'].' '.$result[$i]['profile_lastname'].')';
      }
      $qbx_user_login = formatText(cutText($result[$i]['user_login']. $fullname, 50), '2HTML');
      $qbx_liste .= "<li><a href=\"index.php?id=" . $result[$i]['user_id'] . "&amp;rub=" . $rub . "&amp;todo=det\" title=\"" . _t('divers','last_modify') . " " . $result[$i]['user_last_modify_display'] . " - (" . _t('divers','date_crea') . ": " . $result[$i]['user_date_crea_display'] . ") \">" . $qbx_user_login . "</a></li>\n";
    }
  }
  $qbx_h1 = $nb . _t('user','qb_titleadd');
}

if ($todo == 'mod' || $todo == 'list' || $todo == 'det') {
  $result = $sql_object->DBSelect($req_quickbox_list);
  $qbx_liste = '';
  $nb = '';
  if ($result == 0) {
    $qbx_liste .= "<li class=\"no-data\">" . _t('divers','nodata') . "</li>";
  } else {
    if (count($result) >= 10) $nb = 10;
    else $nb = count($result);
    for($i = 0; $i < count($result); $i++) {
      $fullname = '';
      if(!empty($result[$i]['profile_firstname']) || $result[$i]['profile_lastname']) {
    	$fullname = ' ('. $result[$i]['profile_firstname'].' '.$result[$i]['profile_lastname'].')';
      }
      $qbx_user_login = formatText(cutText($result[$i]['user_login']. $fullname, 50), '2HTML');
      $qbx_liste .= "<li><a href=\"index.php?id=" . $result[$i]['user_id'] . "&amp;rub=" . $rub . "&amp;todo=det\" title=\"" . _t('divers','last_modify') . " " . $result[$i]['user_last_modify_display'] . " - (" . _t('divers','date_crea') . ": " . $result[$i]['user_date_crea_display'] . ") \">" . $qbx_user_login . "</a></li>\n";
    }
  }
  $qbx_h1 = $nb . _t('user','qb_titlemod');
}

if ($todo == 'sup') {
  $result = $sql_object->DBSelect($req_quickbox_sup);
  $qbx_liste = '';
  $nb = '';
  if ($result == 0) {
    $qbx_liste .= "<li class=\"no-data\">" . _t('divers','nodata') . "</li>";
  } else {
    if (count($result) >= 10) $nb = 10;
    else $nb = count($result);
    for($i = 0; $i < count($result); $i++) {
      $fullname = '';
      if(!empty($result[$i]['profile_firstname']) || $result[$i]['profile_lastname']) {
    	  $fullname = ' ('. $result[$i]['profile_firstname'].' '.$result[$i]['profile_lastname'].')';
      }
      $qbx_user_login = formatText(cutText($result[$i]['user_login']. $fullname, 50), '2HTML');
      $qbx_liste .= "<li><a href=\"#\" title=\"" . _t('divers','date_sup') . " " . $result[$i]['user_last_modify_display'] . " - (" . _t('divers','date_crea') . ": " . $result[$i]['user_date_crea_display'] . ") \">" . $qbx_user_login . "</a></li>\n";
    }
  }
  $qbx_h1 = $nb . _t('user','qb_titlesup');
}

echo QuickBoxNow($qbx_module, $qbx_h1, $qbx_liste);
?>