<?php
/**
 * Workshop module - actions on workgroups users
 * 
 * Handle actions on workgroups users
 *  
 * @package linea21\modules\workshop
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
session_start();

include_once('../config/define.php');
include_once('../class/class.workshop.php');
include_once('../class/class.user.php');
include_once('../languages/' . U_L . '/lang_workshop.' . CHARSET . '.php');

// coming from det.php when a user has a pending subscription

include_once('../admin/'.SQL.'.inc.php');


$id=$_GET['id']; // we retrieve given id
$uid = $_GET['u_id'];
$action = $_GET['action'];
isset($_GET['convert']) ? $convert_to = $_GET['convert'] : '';


//////////// Check Droits utilisateur ////////////
if (!$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $id) && !$l21auth->isSuperAdmin())
	ReloadIndex('admin');
////////////

if(!isset($_GET['mode'])) {
	$mode='plain';
} else {
	$mode='ajax';
}

$workshop_object= new workshop;

if($_GET['action'] == 'accept') {

	$r = $workshop_object->acceptUser($id, $uid, $sql_object);

	if($mode == 'plain') {
		$link_confirm = SITE_ROOT_URL."admin/confirm.php?rub=workshop&todo=add_u&id=".$id;
		if($r) header("Location: ".$link_confirm);
		else  system_error();
		// ajax mode
	} else {
		if($r) {
			$status = 1;
			$o = _t('workshop', 'subscription_confirmed');
		}
		/* Return json values */
		echo json_encode(array('status'=> $status,'msg'=> $o, 'action' => $action));
	}
	// if action == unaccept // not implement yet
} elseif($_GET['action'] == 'unaccept') {
	
	$r = $workshop_object->DeleteUserWorkshop($uid, $id, $sql_object);
	
	if($mode == 'plain') {
		$link_confirm = SITE_ROOT_URL."admin/confirm.php?rub=workshop&todo=sup_u&id=".$id;
		if($r) header("Location: ".$link_confirm);
		else  system_error();
		// ajax mode
	} else {
		if($r) {
			$status = 1;
			$o = _t('workshop', 'confirm_sup_u');
		}
		/* Return json values */
		echo json_encode(array('status'=> $status,'msg'=> $o, 'action' => $action, 'type' => $convert_to));
	}
} elseif($_GET['action'] == 'changestatus') {
	
	$usero = new user;
	
	$r = $workshop_object->changeUserStatus($id, $uid, $convert_to, $usero, $sql_object);
	
	if($mode == 'plain') {
		$link_confirm = SITE_ROOT_URL."admin/confirm.php?rub=workshop&todo=changestatus&id=".$id;
		if($r) header("Location: ".$link_confirm);
		else  system_error();
		// ajax mode
	} else {
		if($r) {
			$status = 1;
			$o = _t('workshop', 'confirm_changestatus');
		}
		/* Return json values */
		echo json_encode(array('status'=> $status,'msg'=> $o, 'action' => $action, 'newstatus' => $convert_to));
	}
}
?>