<?php
/**
 * Workshop module - Modify workshop page
 * 
 * Modify workshop page
 * 
 * @package linea21\modules\workshop
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>

<script type="text/javascript">
    $(document).ready( function()
    {
    	// Autocomplete initialization
		var t = new $.TextboxList('#workshop_organizer', {unique: true, plugins: {autocomplete: {onlyFromValues: true, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});

		$.ajax({url: '../workshop/_ajax_user_autocomplete.php?type=O', dataType: 'json', success: function(r){
			t.plugins['autocomplete'].setValues(r);
		}});

		$("div.textboxlist").each(function() {
		    $(this).append('<p class="soft-emphase"><?php echo _t('msg','textboxlist_notice') ?><\/p>');
		});
		
    });
</script>

<?php
include_once("../lib/input_helpers.php");
include_once(override('../level/mysql.inc.php', THEME_ADMIN_PATH));

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin() && !$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $id))
	ReloadIndex('admin');
////////////

// TextboxList CSS/JS inclusion
addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.css');
addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.Autocomplete.css');
footerAddJS('../lib/js/TextboxList-jQuery/Source/GrowingInput.js');
footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.js');
footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.Autocomplete.js');


$req_det= SQL_getoneCompleteWorkshop($id);
$result=$sql_object->DBSelect($req_det);

$mask_archive_P='';
$mask_archive_D='';
$mask_archive_AA='';
$mask_archive_PA='';

// Do record exists?
if(!isset($result[0]['workshop_denomination'])) redirect_to('@module_default');

$workshop_object= new workshop;
$req_user=SQL_getWorkshopUserList($id);
$result_user = $sql_object -> DBSelect($req_user);
//$result_user=$workshop_object->GetWorkshopUserList($id, $sql_object);

$form_organizer='';
$j=0;
for($i=0; $i<count($result_user); $i++) {
  if ($result_user[$i]['jwu_user_right']=='O') {
    $j++;
    if ($j<>1) $form_organizer.=', ';
    $form_organizer.=$result_user[$i]['user_login'];
  }
}

if ($result[0]['workshop_denomination']<>"") {
  $workshop_denomination=$result[0]['workshop_denomination'];
  $form_denomination=formatText($result[0]['workshop_denomination']);
}
else $form_denomination="";
if ($result[0]['workshop_resume']<>"") $form_resume=formatText($result[0]['workshop_resume']);
else $form_resume="";
if ($result[0]['workshop_comment']<>"") $form_comment=formatText($result[0]['workshop_comment']);
else $form_comment="";
$form_level=$result[0]['workshop_level'];
$form_status = $result[0]['workshop_statut'];




if($result[0]['workshop_restricted']==0) $mask_restricted_N="checked=\"checked\""; else $mask_restricted_N='';
if($result[0]['workshop_restricted']==1) $mask_restricted_Y="checked=\"checked\""; else $mask_restricted_Y='';

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$workshop_object->ModifyWorkshop($id, $data_table, $sql_object);
  $result=$workshop_object->StateWorkshop($id,  $data_table[4], $sql_object);
  $result=$workshop_object->ModifyOrganizerWorkshop($id, $data_table[5], $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id;
  if(is_numeric($result))
  header("Location: ".$link_confirm);
  else  system_error();
}

if(isset($_POST['valider'])) {

  $table[0]=$_POST['workshop_denomination'];
  $table[1]=$_POST['workshop_resume'];
  $table[2]=$_POST['workshop_level'];
  $table[3]=$_POST['workshop_comment'];
  $table[4]=$_POST['workshop_statut'];
  $table[5]=$_POST['workshop_organizer'];
  $table[6]=$_POST['workshop_restricted'];

  $workshop_object= new workshop;
  $integrity=$workshop_object->CheckDataIntegrity($table, $sql_object);
  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
  }
  $form_denomination=formatText($_POST['workshop_denomination'], $text_format);
  $form_resume=formatText($_POST['workshop_resume'], $text_format);
  $form_level=$_POST['workshop_level'];
  $form_status=$_POST['workshop_statut'];
  $form_organizer=formatText(str_replace(",",", ", $_POST['workshop_organizer']), $text_format);
  $form_comment=formatText($_POST['workshop_comment'], $text_format);

  if($_POST['workshop_restricted'] == 1) {
  	$display_form_restricted = _t('divers', 'yes');
  } else {
  	$display_form_restricted = _t('divers', 'no');
  }

  if($_POST['workshop_statut']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($_POST['workshop_statut']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
  if($_POST['workshop_restricted']==0) $mask_restricted_N="checked=\"checked\""; else $mask_restricted_N='';
  if($_POST['workshop_restricted']==1) $mask_restricted_Y="checked=\"checked\""; else $mask_restricted_Y='';

  $table=urlencode(serialize($table));
}

// select-box statut
if($form_status=='P') $mask_archive_P=' selected="selected"';
if($form_status=='D') $mask_archive_D=' selected="selected"';
if($form_status=='AA') $mask_archive_AA=' selected="selected"';
if($form_status=='PA') $mask_archive_PA=' selected="selected"';
$select_statut="<select name=\"workshop_statut\" id=\"workshop_statut\">\n";
$select_statut.="<option value=\"P\"".$mask_archive_P.">".display_statut('P')."</option>\n";
$select_statut.="<option value=\"D\"".$mask_archive_D.">".display_statut('D')."</option>\n";
$select_statut.="<option value=\"AA\"".$mask_archive_AA.">".display_statut('AA')."</option>\n";
$select_statut.="<option value=\"PA\"".$mask_archive_PA.">".display_statut('PA')."</option>\n";
$select_statut.="</select>\n";

if(!isset($integrity) || is_string($integrity)) {

  // select-box des niveaux
  $data=$sql_object->DBSelect(SQL_getLevelsList());
  $select_level=LevelSelectBox($data, "workshop_level", $form_level);

}

$navtitle=_t('workshop','mod')." : ".$workshop_denomination;
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','workshop')?></a></li>
	<li><span><?php echo formatnavTitle($navtitle); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<?php afflinkbar($todo,$id, $lang); ?>
<h2><?php echo formatTitleh2(mb_ucfirst(_t('workshop','name'))." : ".$workshop_denomination); ?></h2>

<form id="addworkshop" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
	<label for="workshop_denomination"><?php echo mb_ucfirst(_t('workshop','title')); ?> : *</label>
	<input name="workshop_denomination" type="text" class="textfield" id="workshop_denomination" maxlength="255" value="<?php echo $form_denomination; ?>" required />
</p>
<p>
	<label for="workshop_resume"><?php echo mb_ucfirst(_t('workshop','resume')); ?> : *</label>
	<textarea id="workshop_resume" name="workshop_resume" <?php echo AREA_SETTINGS; ?> class="largetextfield" required><?php echo $form_resume; ?></textarea>
</p>
<p>
	<label for="workshop_organizer"><?php echo mb_ucfirst(_t('workshop','organizer')); ?> :&nbsp;*</label>
	<input name="workshop_organizer" type="text" class="textfield" id="workshop_organizer" maxlength="150" value="<?php echo $form_organizer; ?>" />
</p>
<div class="label"><?php echo mb_ucfirst(_t('workshop','restricted')); ?> : </div>
<div class="rightpanel">
    	<input name="workshop_restricted" type="radio" id="restricted_N" value="0" <?php echo $mask_restricted_N; ?> />
    	<label for="restricted_N"><?php echo mb_ucfirst(_t('divers','no')); ?></label>
    	<input name="workshop_restricted" type="radio" id="restricted_Y" value="1" <?php echo $mask_restricted_Y; ?> />
    	<label for="restricted_Y"><?php echo mb_ucfirst(_t('divers','yes')); ?></label>
</div>
<p>
	<label for="workshop_level"><?php echo mb_ucfirst(_t('workshop','level')); ?> : </label>
	<?php echo $select_level; ?>
</p>
<p>
  <label for="workshop_statut"><?php echo mb_ucfirst(_t('workshop','statut')); ?> :  </label>
  <?php echo $select_statut; ?>
</p>
<p>
	<label for="workshop_comment"><?php echo _t('workshop','comment'); ?> : </label>
	<textarea id="workshop_comment" name="workshop_comment" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_comment; ?></textarea>
</p>
  <div>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <?php echo cancel_button($rub_link."&amp;todo=det&amp;id=".$id); ?>
    <input name="id" type="hidden" value="<?php echo $id; ?>" id="id_workshop" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="valider"  type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
// Récapitulatif
} else	{
	
	if($form_level==0) $level_name=empty_nc('');
	else {
		$record=$sql_object->DBSelect(SQL_getoneLevel($form_level));
		$level_name=formatText($record[0]['level_name'], '2HTML');
	}

  $display_form_resume=empty_nc($form_resume);
  $display_form_comment=empty_nc($form_comment);

?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php afflinkbar($todo,$id, $lang); ?>
<h2><?php echo _t('recap','title') ?></h2>
<?php
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('workshop','title'))." :</dt>\n";
echo "<dd>". $form_denomination."</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshop','resume')). " :</dt>\n";
echo "<dd>".$display_form_resume."</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshop','organizer'))." :</dt>\n";
echo "<dd>".$form_organizer."</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshop','restricted')). " :</dt>\n";
echo "<dd>".$display_form_restricted."</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshop','level'))." :</dt>\n";
echo "<dd>".$level_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','statut')) ." :</dt>\n";
echo "<dd>". display_statut($_POST['workshop_statut']). "</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshop','comment')) ." :</dt>\n";
echo "<dd>". $display_form_comment. "</dd>\n";
echo "</dl>\n";
?>
<form id="addworkshop" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
	<div>
		<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
		<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
		<?php echo cancel_button($rub_link."&amp;todo=det&amp;id=".$id); ?>
		<input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
		<input name="id" type="hidden" value="<?php echo $id; ?>" id="id_workshop" />
		<input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
		<input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
	</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php  } ?>