<?php
/**
 * Workshop module - Modify forum topic page
 * 
 * Modify forum topic page
 * 
 * @package linea21\modules\workshop
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once("../lib/input_helpers.php");
if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

if(isset($_POST['com_id']))	$com_id=$_POST['com_id'];
if(isset($_GET['com_id']))	$com_id=$_GET['com_id'];

if(isset($_POST['mes_id']))	$mes_id=$_POST['mes_id'];
if(isset($_GET['mes_id']))	$mes_id=$_GET['mes_id'];

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $id) && !$l21auth->isSuperAdmin())
ReloadIndex('admin');
////////////

// TextboxList CSS/JS inclusion
addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.css');
addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.Autocomplete.css');
footerAddJS('../lib/js/TextboxList-jQuery/Source/GrowingInput.js');
footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.js');
footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.Autocomplete.js');

$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_add_com=$rub_link."&amp;todo=add_com&amp;id=".$id."&amp;com_id=";

if($com_id <> 0) $link_cancel=$rub_link."&amp;todo=det_com&amp;id=".$id."&amp;com_id=".$com_id;
else $link_cancel=$rub_link."&amp;todo=list_com&amp;id=".$id;

//$user_id=11;
$req_com_mes = SQL_getOnetopicWorkcom($id, $mes_id, $mes_id);
$result_com_mes = $sql_object -> DBSelect($req_com_mes);

$req_com_dis = SQL_getOnetopicWorkcom($id, $com_id, $com_id);
$result_com_dis = $sql_object -> DBSelect($req_com_dis);

// Do record exists?
if(!isset($result_com_dis[0]['workcom_subject'])) redirect_to('@module_default');

$com_dis_subject=formatText($result_com_dis[0]['workcom_subject'], '2FIELD');

$com_root_subject=formatText($result_com_mes[0]['workcom_subject'], '2FIELD');

$form_subject=formatText($result_com_mes[0]['workcom_subject'], '2FIELD');
$form_body=formatText($result_com_mes[0]['workcom_body'], '2FIELD');
$form_owner=formatText($result_com_mes[0]['user_login'], '2FIELD');

$req_det_workshop= SQL_getoneCompleteWorkshop($id);
$result_workshop=$sql_object->DBSelect($req_det_workshop);
$workshop_denomination=formatText($result_workshop[0]['workshop_denomination'], '2FIELD');

$mask_owner='';


$workshop_com_object= new workshop_com;

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  //faire l'ajout de user avec AddUserWorkshop
  $result=$workshop_com_object->ModifyCom($mes_id, $data_table , $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id."&com_id=".$com_id."&mes_id=".$mes_id;
  if($result) header("Location: ".$link_confirm);
  else  system_error();
}

if(isset($_POST['valider'])) {

  $table[0] = $_POST['subject'];
  $table[1] = $_POST['body'];
  $table[2] = $com_id;
  if(isset($_POST['change-owner'])) {
  	$r=$sql_object -> DBSelect(SQL_get_UserInfo($_POST['owner']));
  	$table[3] = $r[0]['user_id'];
  	$mask_owner=' checked="checked"';
  } else {
  	$r=$sql_object -> DBSelect(SQL_get_UserInfo($form_owner));
  	$table[3] = $r[0]['user_id'];
  	$mask_owner='';
  }
  $table[4] = $_POST['id'];

  $integrity=$workshop_com_object->CheckDataIntegrity($table, $sql_object);

  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
  }

  $form_subject=formatText($_POST['subject'], $text_format);
  $form_body=formatText($_POST['body'], $text_format);
  if(isset($_POST['change-owner']) && !empty($_POST['owner'])) {
  	$form_owner=formatText($_POST['owner'], $text_format);
  } else {
  	$form_owner=formatText($form_owner, $text_format);;
  }
  $table=urlencode(serialize($table));
}

if ($com_id == $mes_id) {
  $navtitle=_t('workshop','mod_com')." : ".$com_root_subject;
  $titleh2= _t('workshop','mod_com_mes');
}
else {
  $navtitle=_t('workshop','mod_com_mes')." : ".$com_dis_subject;
  $titleh2=_t('workshop','mod_com_mes'); //.$com_dis_subject;
}
?>
<script type="text/javascript">
    $(document).ready( function()
    {
    	if(!$("#change-owner").is(':checked')) $("#owner-container").hide();

    	$("#change-owner").click(
				function( objEvent ){
					var todo = this.checked;
					if(todo == true ) {
						$("#owner-container").fadeIn("slow");

					} else {
						$("#owner-container").fadeOut("slow");
					}
				}
				);

    	// Autocomplete initialization
		var t = new $.TextboxList('#owner', {unique: true, max:1, plugins: {autocomplete: {onlyFromValues: true, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});

		$.ajax({url: '../workshop/_ajax_user_autocomplete.php?groupmembers=<?php echo $id; ?>', dataType: 'json', success: function(r){
			t.plugins['autocomplete'].setValues(r);
		}});

		$("div.textboxlist").each(function() {
		    $(this).append('<p class="soft-emphase"><?php echo _t('msg','textboxlist_notice') ?><\/p>');
		});
		
    });
</script>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','workshop')?></a></li>
	<li><span><?php echo formatnavTitle($navtitle); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
if(!isset($integrity) || is_string($integrity)) {
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<?php afflinkbar($todo,$id, $lang); ?>
<h2><?php echo formatTitleh2($titleh2); ?></h2>
<div class="subtitle" id="workshop-subtitle"><?php echo $workshop_denomination; ?></div>

<form id="addcom" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<div class="mts">
	<div class="label"><?php echo mb_ucfirst(_t('workshop','com_change_owner')); ?> :</div>
	<div class="rightpanel">
		<input type="checkbox" class="checkbox-switch" name="change-owner" id="change-owner" value="true"<?php echo $mask_owner; ?> />
		<label for="change-owner"></label>
	</div>
</div>
<p id="owner-container">
	<label for="owner"><?php echo mb_ucfirst(_t('workshop','com_owner')); ?> : *</label>
	<input name="owner" type="text" class="textfield" id="owner" maxlength="150" value="<?php echo $form_owner; ?>" />
</p>
<p>
	<label for="subject"><?php echo mb_ucfirst(_t('workshop','com_subject')); ?> : *</label>
	<input name="subject" type="text" class="textfield" id="subject" maxlength="150" value="<?php echo $form_subject; ?>" required />
</p>
<p>
	<label for="body"><?php echo mb_ucfirst(_t('workshop','com_body')); ?> : *</label>
	<textarea id="body" name="body" <?php echo AREA_SETTINGS; ?> class="largetextfield" required><?php echo $form_body; ?></textarea>
</p>
<div>
	<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
	<input name="com_id" type="hidden" value="<?php echo $com_id; ?>" id="com_id" />
	<?php echo cancel_button($link_cancel); ?>
	<input name="mes_id" type="hidden" value="<?php echo $mes_id; ?>" id="mes_id" />
	<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
	<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
	<input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
// Récapitulatif
	} else	{
	  ?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php afflinkbar($todo,$id, $lang); ?>
<h2><?php echo _t('recap','title') ?></h2>
<?php
echo "<dl class=\"summary\">\n";
// we display user login only if we change it
if(isset($_POST['change-owner'])) {
	echo "<dt>".mb_ucfirst(_t('workshop','com_owner'))." : </dt>\n";
	echo "<dd>".$form_owner."</dd>\n";
}
echo "<dt>".mb_ucfirst(_t('workshop','com_subject'))." : </dt>\n";
echo "<dd>".$form_subject."</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshop','com_body')) ." : </dt>\n";
echo "<dd>".$form_body."</dd>\n";
echo "</dl>\n";
?>
<form id="addworkshop" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<div>
	<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
	<input name="com_id" type="hidden" value="<?php echo $com_id; ?>" id="com_id" />
	<?php echo cancel_button($link_cancel); ?>
	<input name="mes_id" type="hidden" value="<?php echo $mes_id; ?>" id="mes_id" />
	<input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
	<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
	<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
	<input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
	<input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php  } ?>