<?php
/**
 * Workshop report module
 * 
 * Provides basics methods called from public templates
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\modules\workshoprep
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Workshoprep' (as Workshop Report) module is used by 'Workshop' modules
 */

include_once(override('../workshoprep/'.SQL.'.inc.php'));


if(!function_exists('DisplayOneWorkshopRep')) {

  function DisplayOneWorkshopRep($work_id) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getoneCompleteWorkshopRep($work_id, array('P', 'PA')));
    $content = '';

    if($data == 0) error_redirect();

    if(count($data)!=1) exit;
    else
    {
      $link_workshop= array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'],'id'=>$data[0]['workrep_workshop_id'], 'name' =>$data[0]['workshop_denomination']);
      $link_self= array('rub'=> $GLOBALS['links'][U_L]['report']['linkvalue'],'id' => $work_id);

      $workrep_title=formatText($data[0]['workrep_title'], '2HTML');
      $workrep_resume=formatText($data[0]['workrep_resume'], '2HTML');
      $workshop_denomination=formatText($data[0]['workshop_denomination'], '2HTML');

      $workrep_posted_on=formatText($data[0]['workrep_published_date_display'], '2HTML');
      $workrep_modify_on=formatText($data[0]['workrep_last_modify_display'], '2HTML');
      $workrep_statut=$data[0]['workrep_statut'];

      if(commentEnabled('report')) {
        postCommentAction(array('module'=> 'report', 'module_id'=> $work_id));
        $content .= '<div id="anchor-comments">'.PHP_EOL;
        $content .= getCommentsAnchor(array('module'=> 'report', 'module_id'=> $work_id));
        if($workrep_statut == 'P') $content .= getPostCommentAnchor();
        $content .= '</div>'.PHP_EOL;
      }
      $content.='<h1>'.$workrep_title.'</h1>'.PHP_EOL;
      $content.='<p class="published_by">'.PHP_EOL;
      $content.='<span class="published-on">'._t('statut','published_on') . '</span> <span class="date">'.$workrep_posted_on.'</span> - ';
      $content.=_t('workshoprep','workshop_product').' : <a href="'.HrefMaker($link_workshop).'" title="'.formatText($GLOBALS['links'][U_L]['workgroup']['desc']. ' ('.$workshop_denomination, '2ATT').')">'.$workshop_denomination.'</a>';
      if($workrep_statut=='PA')  {
        $content.=' ('._t('statut','archived_on').' '.$workrep_modify_on.')';
      }
      $content .= formatted_permalink($link_self, ' - ');
      $content.='</p>'.PHP_EOL;
      $content.='<div class="chapo clear">'.$workrep_resume.'</div>';
      $content.='<hr />';

    }
    echo $content;
  }
}

if(!function_exists('DisplayWorkshopRepParts')) {

  function DisplayWorkshopRepParts($work_id) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopParts($work_id));

    $content ='<div class="parts listed">'.PHP_EOL;
    $content.='<h2>'.mb_ucfirst(_t('workshoprep','name2')).'</h2>'.PHP_EOL;
    if($data!=0)
    {
      $content.='<ol>'.PHP_EOL;
      for($i=0; $i<count($data); $i++) {
        $link_parts= array('rub'=> $GLOBALS['links'][U_L]['report-part']['linkvalue'],'id'=> $data[$i]['workrepcon_id'],'parentid'=>$work_id, 'name' =>$data[$i]['workrepcon_title']);
        $workrepcon_title=formatText($data[$i]['workrepcon_title'], '2HTML');
        $content.='<li>'.PHP_EOL;
        //$content.='<span class="num">'.($i+1).' - </span>'.PHP_EOL;
        $content.='<a href="'. HrefMaker($link_parts).'">';
        $content.=$workrepcon_title;
        $content.='</a>';
        $content.='</li>'.PHP_EOL;
      }
      $content.='</ol>'.PHP_EOL;
    }
    else
    {
      $content.='<p class="info">'._t('workshoprep','no_part').'</p>';
    }
    $content.='</div>'.PHP_EOL;
    //$content.='<hr />';

    echo $content;
  }
}

if(!function_exists('DisplayWorkshopRepLinks')) {

  function DisplayWorkshopRepLinks($work_id) {

    $data=SQL_GetResources($work_id, 'W', 'LINK', $GLOBALS['sql_object']);
    $content ='<div class="links listed">'.PHP_EOL;
    $content.='<h2>'.mb_ucfirst(_t('workshoprep','link_res')).'</h2>'.PHP_EOL;
    if($data!=0)
    {
      $content.='<ul>'.PHP_EOL;
      for($i=0; $i<count($data); $i++) {
        $linkres_mask=formatText($data[$i]['linkres_mask'], '2HTML');
        $linkres_text=$data[$i]['linkres_text'];
        $content.='<li>'.PHP_EOL;
        $content.='<a href="'. $linkres_text.'" class="out">';
        $content.=$linkres_mask;
        $content.='</a>';
        $content.='</li>'.PHP_EOL;
      }
      $content.='</ul>'.PHP_EOL;

    }
    else
    {
      $content.='<p class="info">'._t('workshoprep','no_link').'</p>';
    }
    $content.='</div>'.PHP_EOL;
    //$content.='<hr />';

    echo $content;
  }
}

if(!function_exists('DisplayWorkshopRepBiblio')) {

  function DisplayWorkshopRepBiblio($work_id) {

    $data=SQL_GetResources($work_id, 'W', 'BIBLIO', $GLOBALS['sql_object']);
    $content ='<div class="biblio listed">'.PHP_EOL;
    $content.='<h2>'.mb_ucfirst(_t('workshoprep','biblio_res')).'</h2>'.PHP_EOL;
    if($data!=0)
    {
      $content.='<ul>'.PHP_EOL;
      for($i=0; $i<count($data); $i++) {
        $bibliores_author=formatText($data[$i]['bibliores_author'], '2HTML');
        $bibliores_title=formatText($data[$i]['bibliores_title'], '2HTML');
        $bibliores_sub_title=empty($data[$i]['bibliores_sub_title']) ? '' : ', '.formatText($data[$i]['bibliores_sub_title'], '2HTML');
        $bibliores_editor=empty($data[$i]['bibliores_editor']) ? '' : ' - '.formatText($data[$i]['bibliores_editor'], '2HTML');
        $bibliores_date=empty($data[$i]['bibliores_date']) ? '' : ', '.formatText($data[$i]['bibliores_date'], '2HTML');

        $content.='<li>'.PHP_EOL;
        $content.=$bibliores_author.' - <span class="biblio_title">'.$bibliores_title;
        $content.=$bibliores_sub_title.'</span>'. $bibliores_editor. $bibliores_date;
        $content.='</li>'.PHP_EOL;
      }
      $content.='</ul>'.PHP_EOL;

    }
    else
    {
      $content.='<p class="info">'._t('workshoprep','no_biblio').'</p>';
    }
    $content.='</div>'.PHP_EOL;
    //$content.='<hr />';

    echo $content;
  }
}
?>