<?php
/**
 * Workshop report module
 * 
 * Set-up module related menu in back-office
 * 
 * @package linea21\modules\workshoprep
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Workshoprep' (as Workshop Report) module is used by 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('workshop')) ReloadIndex('admin');
////////////

$rub_back_workshop="?rub=workshop&amp;todo=det&amp;id=".$work_id;
$search="search.php?rub=".$rub;
if($todo=='add') $title=_t('workshoprep','add');
if($todo=='mod') $title=_t('workshoprep','mod');
if($todo=='sup') $title=_t('workshoprep','sup');
if($todo=='det') $title=_t('workshoprep','det');
?>
<div id="itemenu">
	<h1><?php echo $title; ?></h1>
	<div class="contentlink">
		<?php $dispatcher->notify(new sfEvent('secondary_menu', 'admin_workshoprep.menu_start'));?>
		<a href="<?php echo $rub_back_workshop; ?>" title="<?php echo _t('workshoprep','return_workshop');?>"><i class="icon-level-up"></i><?php echo _t('workshoprep','return_workshop');?></a>
		| <a href="<?php echo $search; ?>" title="<?php echo _t('menu','search');?>"><i class="icon-search"></i><?php echo _t('menu','search');?></a>
		<?php $dispatcher->notify(new sfEvent('secondary_menu', 'admin_workshoprep.menu_end'));?>
	</div>
</div>