<?php
/**
 * Link to local pages
 * 
 * Returns all links based on local contents by module
 * 
 * @package linea21\core\admin
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

header('Content-Type: text/html; charset=utf-8');

// rawurlencode() is needed. If not set, generate a JS error in CKEDITOR link plugin
function encodeURIComponent( $str ){

	$revert = array('%21'=>'!', '%2A'=>'*', '%27'=>"'", '%28'=>'(', '%29'=>')');
	return strtr(rawurlencode($str), $revert);

}

$noplugin = true; // flag for ../config/define.php file
include_once('../config/define.php');

//////////// Check Droits utilisateur ////////////
if ($l21auth->isSimpleUser()) ReloadIndex('admin');
////////////

include_once('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');


$a = array();

//
// Caution :  use 'no_url_rewriting' option if you don't want to use MOD_REWRITE syntax


// Getting News
///////////////////
include_once('../news/' . SQL . '.inc.php');
$data = $sql_object->DBSelect(SQL_getNewsList(0, 999, 'P'));

if(isset($data) && $data != 0) {
	foreach ($data as &$el) {
	
		$module = encodeURIComponent(mb_ucfirst(_t('name', 'news_module'). ' : '));
		$name = encodeURIComponent($el['news_title']);
		$link = HrefMaker(array('rub' => $GLOBALS['links'][U_L]['news']['linkvalue'], 'id' => $el['news_id'], 'name' => $el['news_title'], 'amp_no_conversion'=> true));
	
		$tmp = array($module . $name, $link);
		array_push($a, $tmp);
	}
}


// Getting Pages
///////////////////
include_once('../page/' . SQL . '.inc.php');
$data = $sql_object->DBSelect(SQL_getPagesList(0, 999, 'P'));

if(isset($data) && $data != 0) {
	foreach ($data as &$el) {
		
		$module = encodeURIComponent(mb_ucfirst(_t('name', 'page_module'). ' : '));
		$name = encodeURIComponent($el['page_title']);
		$link = HrefMaker(array('rub' => $GLOBALS['links'][U_L]['page']['linkvalue'], 'id' => $el['page_id'], 'name' => $el['page_title'], 'amp_no_conversion'=> true));
		
		$tmp = array($module . $name, $link);
		array_push($a, $tmp);
	}
}

// Getting Publications
///////////////////
include_once('../publication/' . SQL . '.inc.php');
$data = $sql_object->DBSelect(SQL_getPublicationList(0, 999));

if(isset($data) && $data != 0) {
	foreach ($data as &$el) {
	
		$module = encodeURIComponent(mb_ucfirst(_t('name', 'publication_module'). ' : '));
		$name = encodeURIComponent($el['complete_publi_title']);
		$link = HrefMaker(array('rub' => $GLOBALS['links'][U_L]['publication']['linkvalue'], 'id' => $el['publi_id'], 'name' => $el['complete_publi_title'], 'amp_no_conversion'=> true));
	
		$tmp = array($module . $name, $link);
		array_push($a, $tmp);
	}
}

// Getting Newsletters
///////////////////
include_once('../newsletter/' . SQL . '.inc.php');
$data = $sql_object->DBSelect(SQL_getNewsletterList(0, 999, 'public'));

if(isset($data) && $data != 0) {
	foreach ($data as &$el) {
	
		$module = encodeURIComponent(mb_ucfirst(_t('name', 'newsletter_module'). ' : '));
		$name = encodeURIComponent($el['newsletter_title']);
		$link = HrefMaker(array('rub' => $GLOBALS['links'][U_L]['newsletter']['linkvalue'], 'id' => $el['newsletter_id'], 'name' => $el['newsletter_title'], 'amp_no_conversion'=> true));
	
		$tmp = array($module . $name, $link);
		array_push($a, $tmp);
	}
}

// Getting Projects
///////////////////
include_once('../project/' . SQL . '.inc.php');
$data = $sql_object->DBSelect(SQL_getProjectsList(0, 999, 'default'));

if(isset($data) && $data != 0) {
	foreach ($data as &$el) {
	
		$module = encodeURIComponent(mb_ucfirst(_t('name', 'project_module'). ' : '));
		$name = encodeURIComponent($el['project_name']);
		$link = HrefMaker(array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'], 'id' => $el['project_id'], 'name' => $el['project_name'], 'amp_no_conversion'=> true));
	
		$tmp = array($module . $name, $link);
		array_push($a, $tmp);
	}
}

// Getting Workshops
///////////////////
include_once('../workshop/' . SQL . '.inc.php');
$data = $sql_object->DBSelect(SQL_getWorkshopList(0, 999));

if(isset($data) && $data != 0) {
	foreach ($data as &$el) {
	
		$module = encodeURIComponent(mb_ucfirst(_t('name', 'workshop_module'). ' : '));
		$name = encodeURIComponent($el['workshop_denomination']);
		$link = HrefMaker(array('rub' => $GLOBALS['links'][U_L]['workgroup']['linkvalue'], 'id' => $el['workshop_id'], 'name' => $el['workshop_denomination'], 'amp_no_conversion'=> true));
	
		$tmp = array($module . $name, $link);
		array_push($a, $tmp);
	}
}

// Getting Indicators value
///////////////////
include_once('../dashboard/' . SQL . '.inc.php');
$data = $sql_object->DBSelect(SQL_getIndicatorsAlpha(array('P')));

if(isset($data) && $data != 0) {
	foreach ($data as &$el) {
	
		$module = encodeURIComponent(mb_ucfirst(_t('name', 'sdi_module'). ' : '));
		$name = encodeURIComponent($el['sdii_name']);
		$link = HrefMaker(array('rub' => $GLOBALS['links'][U_L]['dashboard']['linkvalue'], 'id' => $el['sdii_id'], 'name' => $el['sdii_name'], 'parentid' => 1, 'amp_no_conversion'=> true));
	
		$tmp = array($module . $name, $link);
		array_push($a, $tmp);
	}
}

// we finally encode the array into JSON
$string = json_encode($a);
echo $string;
?>