<?php
/**
 * Admin Interface main page
 * 
 * Admin interface main page - always called
 * 
 * @package linea21\core\admin
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
include_once("../config/define.php");
ob_start();
// DO NOT REMOVE
header("Cache-control: private"); // necessary for IE and FF to display form data after clicking the back button

// check if session is not expired
$l21auth->isActive();

if(!isset($_SESSION['authenticated'])) {
  if(!empty($_SERVER["QUERY_STRING"])) $page = "login.php?page=". rawurlencode("index.php?". $_SERVER["QUERY_STRING"]);
  else $page = "login.php";
  header("Location: ". safe_redirect($page));
  exit();
}

if(isset($_REQUEST['rub']))	$rub=$_REQUEST['rub'];
if(!isset($_REQUEST['todo'])) {
  $todo="list";
} else {
  $todo=$_REQUEST['todo'];
}



// if is simple user
if($l21auth->isSimpleUser()) {
	header("Location: login.php");
	exit();
}

// Set_Cookie_last_page() must be after define.php include
$l21auth->setCookieLastPage();


/**
 * Section include if dir exists
 **/
if(isset($rub)) {
    // we check whether rub exists in default architecture or in plugins / themes
  if(is_dir(override('../'.$rub, THEME_ADMIN_PATH))) $dir='../'.$rub;
  else ReloadIndex('admin');
} else {
  $dir='../home';
  $rub='home';
}

/**
 * language include
 **/
IncludeAdminLang($rub);

$rub_link="index.php?rub=".$rub;

include_once(SQL.'.inc.php');
$sql_inc_file=override($dir."/".SQL.".inc.php", THEME_ADMIN_PATH);
if(file_exists($sql_inc_file)) include_once($sql_inc_file);

if(isset($debugbar)) {  
  $debugbar['time']->stopMeasure('sqlfiles');
}

include_once(THEME_ADMIN_PATH."index.php");

$sql_object -> DBClose();
ob_end_flush();
?>