<?php
/**
 * Logout logic page
 * 
 * This page is called for user to log-out from both admin and public page
 * 
 * @package linea21\core\admin
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

////////////////////////////////////
//	on tue les variables de sessions
////////////////////////////////////

include_once("../lib/no_cache.php");
include_once("../config/define.php");

// session is alive, we check token is not different from session logout_token
// if so we abort script execution
if($l21auth->isAuthenticated()) {
    if(! isset($_GET['token']) || $_GET['token'] != $l21auth->GetSessionElement('logout_token')) exit('no way !');
}

$l21auth->logOut();
// we delete user cookie and last_page
// necessary to avoid loop on login page
// when linea21_lastpage is set to inexisting value
setcookie("linea21_lastuser", "", time() - 3600, '/');
setcookie("linea21_lastpage", "", time() - 3600, '/');

header("Location: login.php");
exit();
?>