<?php
/**
 * Handle content for publication and workgroup report modules
 * 
 * Display publication or workgroup report content from back-office
 * 
 * @package linea21\modules\content
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Content' module is used by 'Publication' and 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

$contents_object = new contents;

if($type=='P') {
  $requete= SQL_getPublicationTitle($parent);
  $result=$sql_object->DBSelect($requete);
  
  // Do record exists?
  if(!isset($result[0]['publi_title'])) redirect_to('publication');
  
  $current_title=FormatText($result[0]['publi_title'], '2HTML');
  $current_owner=$result[0]['publi_posted_by'];

  //////////// Check Droits utilisateur ////////////
  if (!$l21auth->hasRight('publication')) ReloadIndex('admin');
  ///////////

  $requete= SQL_getOnePublicationParts($id);
  $result=$sql_object->DBSelect($requete);
  
  // Do record exists?
  if(!isset($result[0]['publicon_title'])) redirect_to('publication');
  
  $display_title=formatText($result[0]['publicon_title'], '2HTML');
  $display_body=formatText($result[0]['publicon_body'],'2HTML');
  $display_date_crea=$result[0]['publicon_date_crea_display'];
  $display_last_modify=$result[0]['publicon_last_modify_display'];

}

if($type=='W') {
  $requete= SQL_getWorkshopRepTitleAndGroup($parent);
  $result=$sql_object->DBSelect($requete);
  
  // Do record exists?
  if(!isset($result[0]['workrep_title'])) redirect_to('workshop');
  
  $current_title=FormatText($result[0]['workrep_title']);
  $current_workshop_id=$result[0]['workrep_workshop_id'];
  $current_workshop_name = FormatText($result[0]['workshop_denomination']);

  //////////// Check Droits utilisateur ////////////
  if (!$l21auth->hasRight('workshop')) ReloadIndex('admin');
  ///////////

  $requete= SQL_getOneWorkshopParts($id);
  $result=$sql_object->DBSelect($requete);
  
  // Do record exists?
  if(!isset($result[0]['workrepcon_title'])) redirect_to('workshop');
  
  $display_title=formatText($result[0]['workrepcon_title'], '2HTML');
  $display_body=formatText($result[0]['workrepcon_body'], '2HTML');
  $display_date_crea=$result[0]['workrepcon_date_crea_display'];
  $display_last_modify=$result[0]['workrepcon_last_modify_display'];
}

$link_sup="?rub=contents&amp;todo=sup&amp;parent=".$parent."&amp;type=".$type."&amp;id=";
$link_mod="?rub=contents&amp;todo=mod&amp;parent=".$parent."&amp;type=".$type."&amp;id=";

?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu',$mod_inc); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('contents',$mod_inc.'_type')." : ". $current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php
echo "<h2>";
echo formatTitleh2($current_title);;
echo "</h2>\n";
if($type=='W') echo '<div class="subtitle" id="workshop-subtitle">'.$current_workshop_name.'</div>'; 
if (($type=='W' && !$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $current_workshop_id)) || ($type=='P' && $l21auth->GetSessionElement('id')==$current_owner) || $l21auth->isSuperAdmin()) {
  echo "\t<a href=\"".$link_sup.$id."\" class=\"ico_sup2\" title=\""._t('contents','sup')."\"><i class=\"icon-trash\"></i><span>" . _t('contents','sup') . "</span></a>\n";
  echo "\t<a href=\"".$link_mod.$id."\" class=\"ico_mod2\" title=\""._t('contents','mod')."\"><i class=\"icon-pencil\"></i><span>" . _t('contents','mod') . "</span></a>\n";
}
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('contents','title'))." :</dt>\n";
echo "<dd>". $display_title."</dd>\n";
echo "<dt>". mb_ucfirst(_t('contents','body')). " :</dt>\n";
echo "<dd>".$display_body."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','date_crea')) ." :</dt>\n";
echo "<dd>". $display_date_crea. "</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','last_modify')) ." :</dt>\n";
echo "<dd>". $display_last_modify. "</dd>\n";
echo "</dl>\n";
?>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->