<?php
/**
 * Export module - pdf
 * 
 * Main PDF report generation page
 * 
 * @package linea21\utils\export
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */

//require_once('../class/system/tcpdf/tcpdf.php');
require_once('../lib/vendor/tcpdf/tcpdf.php');


require_once(override('../export/pdf/extendedTCPDF.php', THEME_PUBLIC_PATH));

$extraCSS = '<style>
            img {text-align:center;}
			table {
  			   border:1px solid #777777;
  		    }
            
			thead td, thead th {
				color:#444444;
				background-color:#eeeeee;
				font-size:7pt;
			}
			td {
				text-align:center;
			}
			</style>';
defined('PDFEXPORT_EXTRACSS') ?  $extraCSS = PDFEXPORT_EXTRACSS : $extraCSS = $extraCSS;

// we prepare var to get sorted objects (projetcs or indicators)
$ordered_items = array();

include_once(override('../export/pdf/pdf.report.inc.php', THEME_PUBLIC_PATH));

# bench start tag
$start_time=getmicrotime();

# we create the pdf
$pdf = new eTCPDF('P', 'mm', 'A4', true, 'UTF-8');
// @todo SET Page unit
// $pdf->setPageUnit('px');
#inclusion propriétés du document
include_once(override('../export/pdf/pdf.doc_define.php', THEME_PUBLIC_PATH));

#inclusion page de garde
if(!$report_settings['quick_export']) include_once(override('../export/pdf/pdf.firstpage.php', THEME_PUBLIC_PATH));

// SDI / dashboard report
if($report_settings['export_module'] == 'dashboard') {
    indicator_recursive(null, $bookmark_level);
    display_orphan_indicators ($bookmark_level);

// project report
} else {
    project_recursive(null, $bookmark_level);
    display_orphan_projects($bookmark_level);
}

#inclusion sommaire
if($report_settings['summary']===true) include_once(override('../export/pdf/pdf.summary.php', THEME_PUBLIC_PATH));




# bench stop tag
$stop_time=getmicrotime();

$total_time=(float) $stop_time-$start_time;

#inclusion page d'infos de génération
if($report_settings['publi_infos']===true) include_once(override('../export/pdf/pdf.lastpage.php', THEME_PUBLIC_PATH));

# pdf output
if($report_settings['export_module'] == 'dashboard') {
    $file = _t('name', 'sdi_module'). '-'.date("d-m-Y_His");
} else {
    $file = _t('name', 'project_module'). '-'.date("d-m-Y_His");
}
ob_end_clean(); // uncomment to prevent unwanted content to be printed / comment to debug
// $pdf->Output($file.'.pdf', 'S');
$pdf->Output($file.'.pdf', $report_settings['file']);
ob_end_flush();

?>