<?php
/**
 * Export module
 *
 * Set report options and retrieve data from database
 *
 * @package linea21\utils\export
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */

/////////////////////////////////////////
//	TRAITEMENT DES DONNEES PHP - RAPPORT
/////////////////////////////////////////


if (!isset($_POST['sauver'])) exit;

include_once(override('../dashboard/'.SQL.'.inc.php'));
include_once(override('../project/'.SQL.'.inc.php'));
include_once(override('../level/display.php', THEME_ADMIN_PATH));
include_once(override('../project/display.php'));

// paramètres utilisateurs.

$report_settings = array();

$report_settings['file'] = 'D';
$report_settings['title'] = isset($_POST['title_report']) ? html_entity_decode(formatText($_POST['title_report']), ENT_QUOTES) : '';
$report_settings['author'] = isset($_POST['author']) ? html_entity_decode($_POST['author'], ENT_QUOTES) : '';
$report_settings['mail_author'] = isset($_POST['mail_author']) ? html_entity_decode($_POST['mail_author'], ENT_QUOTES) : '';
$report_settings['service_author'] = isset($_POST['service_author']) ? html_entity_decode(formatText($_POST['service_author']), ENT_QUOTES) : '';
$report_settings['adress_author'] = isset($_POST['adress_author']) ? strip_tags(html_entity_decode($_POST['adress_author']), ENT_QUOTES) : ''; // remove HTML tags
$report_settings['adress_author'] = str_replace("\r\n", " ", trim(html_entity_decode($report_settings['adress_author'], ENT_QUOTES)));

$report_settings['quick_export'] = isset($_POST['quick_export']) ? true : false;

$report_settings['levels'] = isset($_POST['levels_chapters']) ? true : false;

$report_settings['display_empty_levels'] = isset($_POST['empty_levels']) ? false : true;

$report_settings['firstlevel_description'] = isset($_POST['firstlevel_description']) ? true : false;

$report_settings['dashboard_values'] = isset($_POST['dashboard_values']) ? true : false;

$report_settings['status'] = isset($_POST['notpublished']) ? 'ALL' : 'PUBLIC';

$report_settings['summary'] = isset($_POST['summary']) ? true : false;

$report_settings['publi_infos'] = isset($_POST['publi_info']) ? true : false;

$report_settings['export_module'] = 'project';

/////////////////////////////////////////////////////////////
// when exporting a single value we disable some features
/////////////////////////////////////////////////////////////
if(isset($_REQUEST['id'])) {
    $report_settings['levels'] = false;
    $report_settings['firstlevel_description'] = false;
    $report_settings['dashboard_values']= true;
    $report_settings['status']='ALL';
    $report_settings['summary']=false;
    $report_settings['publi_infos']=false;
    $_POST['projects']='det';
    $_POST['projects_id']=$_REQUEST['id'];
}

// // préparation tableau dénomination des échelles.
// $scale_temp = $sql_object->DBSelect(SQL_getAllScale());
// //print_r($scale_temp);
// $scale_denomination_array = array();
// for($i=0; $i<count($scale_temp); $i++) {
//   $scale_denomination_array[$scale_temp[$i]['scale_id']] = $scale_temp[$i]['scale_denomination'];
// }

// if ($_POST['scale'] == 'det') {
//   $report_settings['scale'] = 'EACH';
//   $scale_array = $_POST['eachscale'];
// } else {
//   $report_settings['scale'] = 'ALL';
//   // initialisation de $scale_array
//   $scale_array = array();
//   for($i=0; $i<count($scale_temp); $i++) {
//     $scale_array[$i] = $scale_temp[$i]['scale_id'];
//   }
// }




if ($_POST['projects'] == 'det') {
    // if no indicator is projects_id - we send all
    if(!isset($_POST['projects_id'])) {
        $report_settings['projects'] = 'ALL';
        $projects_array = -1;
    } else {
        $report_settings['projects'] = 'EACH';
        $projects_array = $_POST['projects_id'];
    }
} else  {
    $report_settings['projects'] = 'ALL';
    $projects_array = -1;
}


/////////////////////////////////////////
//	TRAITEMENT DES DONNEES PHP
/////////////////////////////////////////

// we retrieve all data regarding projects
$project = $sql_object->DBSelect(GetAllProjectsInfo($report_settings['status'], $report_settings['projects'], $projects_array));

// we add extra field with level root
$project = add_root_level($project, 'project_level_id', 'level_root');


?>