<?php
/**
 * Home module - available from back-office only
 * 
 * Display default items provided in home page (back-office)
 * 
 * @package linea21\core\home
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Home' module is used into the back-office
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

include_once(override('../vote/display.php'));

// Comments
if(defined('MOD_COMMENT') && MOD_COMMENT == 1) {
  include_once(override('../comment/display.php'));
  include_once(override('../comment/'.SQL.'.inc.php'));
  include_once('../class/class.comment.php');
  
  if(COMMENT_MODERATION == 1) {
    $status = array('D');
    $comm = new comment();
    $data = $comm->getAllByModule($status, $sql_object, false, 'date');
    $nb_comments = count($data);
    $html_comments = getMarkup($data, true);
  } else {
    $status = array('P');
    $comm = new comment();
    $data = $comm->getAllByModule($status, $sql_object, 10, 'date');
    $nb_comments = count($data);
    $html_comments = getMarkup($data, false);
  }
  echo getAjaxFunction();
}

// workgroups users moderation
if(defined('MOD_WORKSHOP') && MOD_WORKSHOP == 1) {
	include_once(override('../languages/'.U_L.'/lang_workshop.'.CHARSET.'.php'));

	$r = $sql_object -> DBSelect(SQL_getWorkgroupsPendingUsers());

	if (!is_array($r)) $nb_pendingusers=0;
	else $nb_pendingusers = count($r);

	$cnt_pending_users = 0;
	$liste_pendingusers = '';
	
	if ($nb_pendingusers != 0) {

		for ($i = 0;$i < count($r);$i++) {
			// we display only workgroups current user is in charge of
			if ($l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $r[$i]['workshop_id']) || $l21auth->isSuperAdmin()){
				$cnt_pending_users++;
				$link_accept = '../workshop/_user.php?action=accept&amp;id='. $r[$i]['workshop_id'].'&amp;u_id='.$r[$i]['user_id'];
				$link_revoke = '../workshop/_user.php?action=unaccept&amp;id='. $r[$i]['workshop_id'].'&amp;u_id='.$r[$i]['user_id'];
				// we display user link only if admin
				if($l21auth->isSuperAdmin()) {
					$username = '<a href="?rub=user&amp;todo=det&amp;id='.$r[$i]['user_id'].'"  title="' . $GLOBALS['links'][U_L]['user-profile']['desc'].'">'.$r[$i]['user_login'].'</a>';
				} else {
					$username = $r[$i]['user_login'];
				}
				if(!empty($r[$i]['profile_firstname']) || !empty($r[$i]['profile_lastname'])) {
					$username .= ' ('.$r[$i]['profile_firstname']. ' ' . $r[$i]['profile_lastname'] .')';
				}
				$username .= ' - <a href="mailto:'.$r[$i]['profile_email'].'">'.$r[$i]['profile_email'].'</a>';
// 				$liste_pendingusers .= "\t<li class=\"li2 to-moderate\">". formatText($username, '2HTML') . "<br />" .sprintf(_t('workshop', 'workshop_join'), formatText('<a href="?rub=workshop&amp;todo=det&amp;id='.$r[$i]['workshop_id'].'">'.$r[$i]['workshop_denomination'].'</a>', '2HTML')). "<a href=\"".$link_accept."\"  title=\""._t('workshop','add_new_user')."\" class=\"ico_add user-action\"><i class=\"icon-ok\"></i><span>" . _t('workshop','del_user') . "</span></a><a href=\"".$link_revoke."\"  title=\""._t('workshop','del_user')."\" class=\"ico_sup user-action\"><i class=\"icon-cancel\"></i><span>" . _t('workshop','del_user') . "</span></a></li>\n\n";
				$liste_pendingusers .= "\t<li class=\"li2 to-moderate\"><div class=\"iconetab\"><a href=\"".$link_accept."\"  title=\""._t('workshop','add_new_user')."\" class=\"ico_approve user-action\"><i class=\"icon-ok\"></i><span>" . _t('workshop','add_new_user') . "</span></a><a href=\"".$link_revoke."\"  title=\""._t('workshop','del_user')."\" class=\"ico_sup user-action\"><i class=\"icon-cancel\"></i><span>" . _t('workshop','del_user') . "</span></a></div>". formatText($username, '2HTML') . "<br />" .sprintf(_t('workshop', 'workshop_join'), formatText('<a href="?rub=workshop&amp;todo=det&amp;id='.$r[$i]['workshop_id'].'">'.$r[$i]['workshop_denomination'].'</a>', '2HTML')). "</li>\n\n";
			}
		}
		if(empty($liste_pendingusers)) $liste_pendingusers .= "\t<li><div class=\"info\">" ._t('home','noupdate'). "</div></li>\n\n";

		// ajax code
		$js = '$("a.user-action").click(function() {

		var el = this;
		var url = $(this).attr("href") + "&mode=ajax";

		$.ajax({
			type: "GET",
			url: url,
			dataType: "json",
			success: function(data){
				if(data.status==1) {
					// we update the user counter
					$("#cu").text( parseInt($("#cu").text()) - 1);
					alertify.success(data.msg);
					$(el).closest("li").fadeOut();
				} else {
					alertify.error(data.msg);
				}
			}
		});
			
		return false;
		
		});
		';
		
		footerAddInlineJS($js);
	} else   $liste_pendingusers .= "\t<li><div class=\"info\">" ._t('home','noupdate'). "</div></li>\n\n";
}

// Directory : entries to validate
$result_yp = $sql_object -> DBSelect($req_yp);
if (!is_array($result_yp)) $nb_yp=0;
else $nb_yp = count($result_yp);
$link_yp = "index.php?rub=yellowpages&amp;todo=det&amp;id=";
$liste_yp = '';

if ($nb_yp<>0) {
  for ($i = 0;$i < count($result_yp);$i++) {
    $liste_yp .= "\t<li class=\"li2\"><a href=\"" . $link_yp . $result_yp[$i]['yellowp_id'] . "\" title=\"" . formatText($result_yp[$i]['yellowp_name'], '2ATT') . "\">" . formatText($result_yp[$i]['yellowp_name'], '2HTML') . "</a></li>\n\n";
  }
}else   $liste_yp .= "\t<li><div class=\"info\">" ._t('home','noupdate'). "</div></li>\n\n";


// Indicators to update
$result_sdi = $sql_object -> DBSelect($req_sdi);
if (!is_array($result_sdi)) $nb_dashboard=0;
else $nb_dashboard = count($result_sdi);
$liste_dashboard = '';
$link_dashboard = "index.php?rub=dashboard&amp;todo=det&amp;id=";
if ($nb_dashboard<>0) {
  for ($i = 0;$i < count($result_sdi);$i++) {
    $liste_dashboard .= "\t<li class=\"li2\"><a href=\"" . $link_dashboard . $result_sdi[$i]['sdii_id'] . "&amp;scale_id=" . $result_sdi[$i]['scale_id'] . "\" title=\"" . formatText($result_sdi[$i]['sdii_name'], '2ATT') . "\">" . formatText($result_sdi[$i]['sdii_name'], '2HTML') . "</a> <span class=\"scale\">   (" . formatText($result_sdi[$i]['scale_denomination'], '2HTML') . ") </span></li>\n\n";
  }
}else   $liste_dashboard .= "\t<li><div class=\"info\">" ._t('home','noupdate'). "</div></li>\n\n";


// New users since last connexion
if (isset($_SESSION['lastcon'])){

  $req_user = SQL_getUser($_SESSION['lastcon']);
  $resultu = $sql_object -> DBSelect($req_user);

  if (!is_array($resultu)) $nb_user=0;
  else $nb_user = count($resultu);

  $liste_user = '';
  $link_user = "index.php?rub=user&amp;todo=det&amp;id=";

  if ($nb_user<>0) {
    for ($i = 0;$i < count($resultu);$i++) {
      $fullname = '';
      if(!empty($resultu[$i]['profile_firstname']) || $resultu[$i]['profile_lastname']) {
    	$fullname = ' - '. $resultu[$i]['profile_firstname'].' '.$resultu[$i]['profile_lastname'];
      }
      $liste_user .= "\t<li class=\"li2\"><a href=\"" . $link_user . $resultu[$i]['user_id'] . "\" title=\"" . formatText($resultu[$i]['user_login'], '2ATT') . "\">" . formatText($resultu[$i]['user_login'], '2HTML')  . "</a>".$fullname."</li>\n\n";
    }
  }else   $liste_user .= "\t<li><div class=\"info\">" ._t('home','noresult'). "</div></li>\n\n";
}

// Latest news
$result_news = $sql_object -> DBSelect($req_news);
$liste_news = '';
if (!is_array($result_news)) $nb_news=0;
else $nb_news = count($result_news);
$link_news = "index.php?rub=news&amp;todo=det&amp;id=";
if ($nb_news<>0) {
  for ($i = 0;$i < count($result_news);$i++) {
    $liste_news .= "\t<li class=\"li2\"><a href=\"" . $link_news . $result_news[$i]['news_id'] . "\" title=\"" . formatText($result_news[$i]['news_title'], '2ATT') . "\">" . formatText($result_news[$i]['news_title'], '2HTML') . "</a></li>\n\n";
  }
} else   $liste_news .= "\t<li><div class=\"info\">" ._t('home','noresult'). "</div></li>\n\n";

// Latest connected users
$r = $sql_object -> DBSelect(SQL_Get_LatestConnectedUsers(100));
$connected_users = '';
if (!is_array($r)) $nb_connected_users = 0;
else $nb_connected_users = count($r);
$link = "index.php?rub=user&amp;todo=det&amp;id=";
if ($nb_connected_users <> 0) {
	for ($i = 0;$i < count($r);$i++) {
		$connected_users .= "\t<li class=\"li2\"><a href=\"" . $link . $r[$i]['user_id'] . "\" title=\"" . formatText($r[$i]['user_login'], '2ATT') . "\">" . formatText($r[$i]['user_login'], '2HTML') .' ('. $r[$i]['user_last_con_display'] .  ")</a></li>\n\n";
	}
} else   $connected_users .= "\t<li><div class=\"info\">" ._t('home','noresult'). "</div></li>\n\n";

// Latest publications
$result_publi = $sql_object -> DBSelect($req_publi);
$link_publi = "index.php?rub=publication&amp;todo=det&amp;id=";
if (!is_array($result_publi)) $nb_publi=0;
else $nb_publi = count($result_publi);
if ($nb_publi<>0) $liste_publi = "\t<li class=\"li2\"><a href=\"" . $link_publi . $result_publi[0]['publi_id'] . "\" title=\"" . formatText($result_publi[0]['publi_title'], '2HTML') . "\">" . formatText($result_publi[0]['publi_title'], '2HTML') . "</a></li>\n\n";
else  $liste_publi = "\t<li><div class=\"info\">" ._t('home','noresult'). "</div></li>\n\n";

// Latest workgroups reports
$result_rep = $sql_object -> DBSelect($req_rep);
if (!is_array($result_rep)) $nb_rep=0;
else $nb_rep = count($result_rep);
$link_rep = "index.php?rub=workshoprep&amp;todo=det&amp;id=";
if ($nb_rep<>0) $liste_rep = "\t<li class=\"li2\"><a href=\"" . $link_rep . $result_rep[0]['workrep_id'] . "\" title=\"" . formatText($result_rep[0]['workrep_title'], '2ATT') . "\">" . formatText($result_rep[0]['workrep_title'], '2HTML') . "</a></li>\n\n";
else  $liste_rep = "\t<li><div class=\"info\">" ._t('home','noresult'). "</div></li>\n\n";

// Projects with a close deadline
$rProjects = $sql_object->DBSelect(SQL_getProjects(), 'OBJECT');
$lProjects = '';
if (!is_array($rProjects)) $nbProjects=0;
else $nbProjects = count($rProjects);
$link_projects = "index.php?rub=project&amp;todo=det&amp;id=";
if ($nbProjects > 0) {
  for ($i = 0;$i < count($rProjects);$i++) {
    $lProjects .= "\t<li class=\"li2\"><a href=\"" . $link_projects . $rProjects[$i]->project_id . "\" title=\"" . formatText($rProjects[$i]->project_name, '2ATT') . "\">" . formatText($rProjects[$i]->project_name, '2HTML') .' ('. $rProjects[$i]->project_estimated_date_display . ")</a></li>\n\n";
  }
} else   $lProjects .= "\t<li><div class=\"info\">" ._t('home','noresult'). "</div></li>\n\n";


?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a>
	</li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));

?>
<div id="content">
<?php
$listing = '';

if ($l21auth->isSuperAdmin() && defined('MOD_COMMENT') && MOD_COMMENT == 1) {
	if($nb_comments > 0) $class='block';
	else $class='none';
	$c = ($class == 'block') ? 'open' : '';

  if(COMMENT_MODERATION == 1) {
    $title = sprintf(_t('home','comment_to_moderate'), '<span id="cc">'.$nb_comments.'</span>');
  } else {
    $title = sprintf(_t('home','comment'), $nb_comments);
  }
  $listing .= "<div class=\"toggle_title\"><a href=\"#\" class=\"". $c ."\">" . $title. "</a></div>";
  $listing .= "<div class=\"contboxgray\" id=\"comments\" style=\"display:".$class.";\">\n";
  if(!empty($html_comments)) $listing .= $html_comments;
  else $listing .= "<div class=\"info\">"._t('home','noresult')."</div>";
  $listing .= "</div>\n";
}

if ($l21auth->hasRight('workshop') && defined('MOD_WORKSHOP') && MOD_WORKSHOP == 1) {
	if($cnt_pending_users > 0) $class='block';
	else $class='none';
	$c = ($class == 'block') ? 'open' : '';

	$title = sprintf(_t('home','workshop_pending_users'), '<span id="cu">'.$cnt_pending_users.'</span>');
	$listing .= "<div class=\"toggle_title\"><a href=\"#\" class=\"". $c ."\">" . $title . "</a></div>";
	$listing .= "<div class=\"contboxgray\" id=\"workgroup-users\" style=\"display:".$class.";\">\n";
	$listing .= "<ul>\n";
	$listing .= $liste_pendingusers;
	$listing .= "</ul>\n";
	$listing .= "</div>\n";
}

if ($l21auth->hasRight('dashboard') && defined('MOD_DASHBOARD') && MOD_DASHBOARD == 1) {
	if($nb_dashboard > 0) $class='block';
	else $class='none';
	$c = ($class == 'block') ? 'open' : '';

  $listing .= "<div class=\"toggle_title\"><a href=\"#\" class=\"". $c ."\">" . $nb_dashboard . " " . _t('home','dashboard') . "</a></div>";
  $listing .= "<div class=\"contboxgray\" id=\"general\" style=\"display:".$class.";\">\n";
  $listing .= "<ul>\n";
  $listing .= $liste_dashboard;
  $listing .= "</ul>\n";
  $listing .= "</div>\n";
}

if ($l21auth->isSuperAdmin() && defined('MOD_YELLOWPAGES') && MOD_YELLOWPAGES == 1){
	if($nb_yp > 0) $class='block';
	else $class='none';
	$c = ($class == 'block') ? 'open' : '';

	$listing .= "<div class=\"toggle_title\"><a href=\"#\" class=\"". $c ."\">" . $nb_yp . " " . _t('home','yp') . "</a></div>";
	$listing .= "<div class=\"contboxgray\" id=\"yp\" style=\"display:".$class.";\">\n";
	$listing .= "<ul>\n";
	$listing .= $liste_yp;
	$listing .= "</ul>\n";
	$listing .= "</div>\n";
}

if ($l21auth->hasRight('project') && defined('MOD_PROJECT') && MOD_PROJECT == 1) {
  $listing .= "<div class=\"toggle_title\"><a href=\"#\">" . _t('home','project') . "</a></div>";
  $listing .= "<div class=\"contboxgray\" id=\"projects\" style=\"display:none;\" >\n";
  $listing .= "<ul>\n";
  $listing .= $lProjects;
  $listing .= "</ul>\n";
  $listing .= "</div>\n";
}

if ($l21auth->isSuperAdmin() && defined('MOD_USER') && MOD_USER == 1){
  	if($nb_user > 0) $class='block';
  	else $class='none';
  	$c = ($class == 'block') ? 'open' : '';
  	
    $listing .= "<div class=\"toggle_title\"><a href=\"#\" class=\"". $c ."\">" . $nb_user . " " . _t('home','user') . "</a></div>";
    $listing .= "<div class=\"contboxgray\" id=\"user\" style=\"display:".$class.";\">\n";
    $listing .= "<ul>\n";
    $listing .= $liste_user;
    $listing .= "</ul>\n";
    $listing .= "</div>\n";
}

if ($l21auth->isSuperAdmin()) {
	if($nb_connected_users > 1) {
		$class='block';
		$ulclass='col-3';
	}
	else {
		$class='none';
		$ulclass='';
	}
	$c = ($class == 'block') ? 'open' : '';
	
	$listing .= "<div class=\"toggle_title\"><a href=\"#\" class=\"". $c ."\">" . sprintf(_t('home','latest_connected_users'), $nb_connected_users ) . "</a></div>";
	$listing .= "<div class=\"contboxgray\" id=\"user\" style=\"display:".$class.";\">\n";
	$listing .= "<ul class=\"".$ulclass."\">\n";
	$listing .= $connected_users;
	$listing .= "</ul>\n";
	$listing .= "</div>\n";
}

if ($l21auth->hasRight('news') && defined('MOD_NEWS') && MOD_NEWS == 1){
  $listing .= "<h3>" . mb_ucfirst(_t('home','news')) . "</h3>";
  $listing .= "<div class=\"contboxgray\">\n";
  $listing .= "<ul>\n";
  $listing .= $liste_news;
  $listing .= "</ul>\n";
  $listing .= "</div>\n";
}
if ($l21auth->hasRight('publication') && defined('MOD_PUBLICATION') && MOD_PUBLICATION == 1) {
  $listing .= "<h3>" . mb_ucfirst(_t('home','publi')) . "</h3>";
  $listing .= "<div class=\"contboxgray\">\n";
  $listing .= "<ul>\n";
  $listing .= $liste_publi;
  $listing .= "</ul>\n";
  // $listing .= "<div class=\"scale\">" . formatText($result_publi[0]['publi_resume'], '2HTML') . "</div>";
  $listing .= "</div>\n";
}
if ($l21auth->hasRight('workshop') && defined('MOD_WORKSHOP') && MOD_WORKSHOP == 1) {
  $listing .= "<h3>" . mb_ucfirst(_t('home','report')) . "</h3>";
  $listing .= "<div class=\"contboxgray\">\n";
  $listing .= "<ul>\n";
  $listing .= $liste_rep;
  $listing .= "</ul>\n";
  $listing .= "</div>\n";
}



echo "<h2>" . _t('home','accueil') . "</h2><br class=\"brendstep\" />";

// we create a hook
$dispatcher->notify(new sfEvent('home', 'admin_mainpage.top'));

echo $listing;
// we create a hook
$dispatcher->notify(new sfEvent('home', 'admin_mainpage.bottom'));

?>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->