<?php

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// UPDATE FROM VERSION 2.0
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
@unlink('../class/class.theme.php');
@SureRemoveDir('../class/system/pChart/', true);
@SureRemoveDir('../class/system/tcpdf/', true);
@SureRemoveDir('../theme/', true);
@unlink('../dashboard/rap.php');
@unlink('../export/phpsql.process.php');
@unlink('../languages/fr/lang_theme.utf-8.php');
@unlink('../languages/es/lang_theme.utf-8.php');
@unlink('../languages/en/lang_theme.utf-8.php');
@unlink('../languages/it/lang_theme.utf-8.php');
@SureRemoveDir('../lib/js/jquery-ui/', true);
@SureRemoveDir('../lib/js/jquery-ui-multiselect/', true);
@SureRemoveDir('../lib/js/jquery.datePicker.l10n/', true);
@SureRemoveDir('../lib/js/jquery.textboxList/', true);
@SureRemoveDir('../lib/js/nicEdit/', true);
@SureRemoveDir('../lib/js/timeline/', true);
@SureRemoveDir('../lib/vendor/jQuery-File-Upload/', true);

@SureRemoveDir('../lib/vendor/cron-expression/tests/', true);
@SureRemoveDir('../lib/vendor/PHP-Color/testing/', true);
@SureRemoveDir('../lib/vendor/PHP-Excel/Documentation/', true);
@SureRemoveDir('../lib/vendor/PHP-Excel/Examples/', true);
@SureRemoveDir('../lib/vendor/PHPWord/docs/', true);
@SureRemoveDir('../lib/vendor/PHPWord/samples/', true);
@SureRemoveDir('../lib/vendor/PHPWord/tests/', true);
@SureRemoveDir('../lib/vendor/Stringy/tests/', true);

@unlink('../project/timeline-xml.php');
@unlink('../lib/js/jquery.min.js');
@unlink('../lib/js/timeline.js');


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Generics actions : Finally we update config.ini and add new constants if necessary
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// we parse the current config.ini file (before update)
$config_ini = parse_ini_file("../config/config.ini");


// we set admin theme to 2018
if(isset($config_ini['THEME_ADMIN'])) $config_ini['THEME_ADMIN'] = '2018';

$l21config->setParams($config_ini);

// we add NEW_WIN_PDF constant if needed
if(!isset($config_ini['NEW_WIN_PDF'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'NEW_WIN_PDF', 1)));

// we add NEW_WIN_EXTLINK constant if needed
if(!isset($config_ini['NEW_WIN_EXTLINK'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'NEW_WIN_EXTLINK', 1)));

// we add NEW_WIN_EXTLINK constant if needed
if(!isset($config_ini['CRONJOBS_LOG_ENABLED'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'CRONJOBS_LOG_ENABLED', 0)));

// we add HTML_MAIL_TEMPLATE constant if needed
if(!isset($config_ini['HTML_MAIL_TEMPLATE'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'HTML_MAIL_TEMPLATE', 0)));

// we add LOG_ACCESS constant if needed
if(!isset($config_ini['LOG_ACCESS'])) $l21config->addParams(array(array('LOGS_SETTINGS', 'LOG_ACCESS', '../logs/access.log')));

// we delete LOG_PUBLIC_ACCESS constant
if(isset($config_ini['LOG_PUBLIC_ACCESS'])) $l21config->rmParams(array(array('LOGS_SETTINGS', 'LOG_PUBLIC_ACCESS')));

// we delete LOG_ADMIN_ACCESS constant
if(isset($config_ini['LOG_ADMIN_ACCESS'])) $l21config->rmParams(array(array('LOGS_SETTINGS', 'LOG_ADMIN_ACCESS')));

// we delete LOG_ADMIN_ACCESS constant
if(isset($config_ini['LOG_KEYWORDS'])) $l21config->rmParams(array(array('LOGS_SETTINGS', 'LOG_KEYWORDS')));

// we delete MOD_THEME constant
if(isset($config_ini['MOD_THEME'])) $l21config->rmParams(array(array('MODULES_SETTINGS', 'MOD_THEME')));

// we delete AUTO_LINK constant
if(isset($config_ini['AUTO_LINK'])) $l21config->rmParams(array(array('SYSTEM_SETTINGS', 'AUTO_LINK')));



// we write the new file
if($l21config->writeReleaseParams()) {
	echo "<p><strong>Writing new configuration file : /config/config.ini</strong></p>";
} else {
	echo "<p><strong>Problem writing new configuration file : /config/config.ini</strong></p>";
}

?>