<?php
/**
 * Level module
 * 
 * Provides basics methods called from public templates
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\modules\level
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../level/'.SQL.'.inc.php'));
include_once('../class/class.level.php');

if(!function_exists('getLevelParent')) {
	
	/**
	 * getLevelParent()
	 * For a given level, return parent with the given $depth ($wanteddepth)
	 * if passed else return the last parent
	 * 
	 * @param array $data
	 * @param integer $id
	 * @param integer $currentdepth
	 * @param integer $wanteddepth
	 */
	function getLevelParent($data, $id, $currentdepth, $wanteddepth = 9) {
		
		foreach ($data as $item) {
	
			if($item['level_id'] == $id) {
				
				$current_id = $item['level_id'];
				$parent_id = $item['level_parent'];
				
				$current_label = '<span class="label-info">' .formatText( $item['level_label'], '2HTML'). ' : </span>';
				$current_name = formatText($item['level_name'], '2HTML');
				$current_longname = $current_label . $current_name;
				
				$a = array('id' => $current_id, 'label' => $item['level_label'], 'name' => $item['level_name'], 'range' => $item['level_range'],
							'code'=> $item['level_code'], 'main_desc' => $item['level_desc_project'], 'longname' => $current_longname, 'depth' => $currentdepth);
	
				if($parent_id == 0 && $currentdepth !=0) {
					return $a;
				}
				else {
					if($currentdepth == $wanteddepth) {
						return $a;
					}	else {
						return getLevelParent($data, $parent_id, $currentdepth+1, $wanteddepth);
					}
				}
			}
		}
		return false;
	}

}

if(!function_exists('getLevelDepth')) {

	/**
	 * getLevelDepth()
	 * For a given level, return $depth (start from 0)
	 * @param array $data
	 * @param integer $id
	 * @param integer $currentdepth
	 */
	function getLevelDepth($data, $id, $currentdepth) {

		foreach ($data as $item) {

			if($item['level_id'] == $id) {

				$parent_id = $item['level_parent'];

				if($parent_id == 0) {
					return $currentdepth;
				}
				else {
						return getLevelDepth($data, $parent_id, $currentdepth+1);
				}
			}
		}
	}

}


if(!function_exists('getLevelParents')) {

	/**
	 * getLevelParents()
	 * For a given level, return all parents
	 *
	 * @param array $data
	 * @param integer $id
	 */
	function getLevelParents($data, $id) {
		
		$parents = array();
		
		foreach ($data as $item) {

			if($item['level_id'] == $id) {

				$parent = getLevelParents($data, $item['level_parent']);
				if ($parent) {
					$item['parent'] = $parent;
				}
				$parents[] = $item;
			}
		}
		return $parents;
	}

}

if(!function_exists('getLevelChildren')) {

	/**
	 * getLevelChildren()
	 * For a given level, return all children
	 *
	 * @param array $data
	 * @param integer $id
	 */
	function getLevelChildren($data, $id) {
		
		$res = array();
		
		foreach ($data as $item) {

			if($item['level_parent'] == $id) {
				$children = getLevelChildren($data, $item['level_id']);
				if ($children) {
					$item['children'] = $children;
				}
				$res[] = $item;
			}
		}
		return $res;
	}
		
}

	

	/**
	 * add_root_level()
	 * Add root level to dataset
	 * @param array $values
	 */
	
	if(!function_exists('add_root_level')) {
	
		function add_root_level($values, $keyname, $newkey = 'level_root') {
			
			$levels=$GLOBALS['sql_object']->DBSelect(SQL_getLevelsList());
	
			foreach ($values as &$item) {
				
				$a = getLevelParent($levels, $item[$keyname], 0);
				if(is_array($a)) {
					$item[$newkey] = $a['id'];
					$item[$newkey.'_range'] = $a['range'];
					$item[$newkey.'_name'] = $a['name'];
				} else {
					$item[$newkey] = $item[$keyname];
				}
				
			}
	
			return $values;
		}
	
	}

?>