<?php
/**
 * Level module
 * 
 * Modify given level from back-office
 * 
 * @package linea21\core\level
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

if (isset($_GET['id']))	$id=$_GET['id'];
if (isset($_POST['id'])) $id=$_POST['id'];

$data=$sql_object->DBSelect(SQL_getoneLevel($id));

// Do record exists?
if(!isset($data[0]['level_name'])) redirect_to('@module_default');

$display_title=formatText($data[0]['level_name'],'2HTML');

$form_id=$data[0]['level_id'];
$form_parent = $data[0]['parent_id'];
$current_status  =$data[0]['level_status'];

$description_detail_form='';
$form_description_all= '';

$form_name=formatText($data[0]['level_name'],'2FIELD');
$form_label=formatText($data[0]['level_label'],'2FIELD');
$form_code=formatText($data[0]['level_code'],'2FIELD');
$desc_project=formatText($data[0]['level_desc_project'], '2FIELD');
$desc_dashboard=formatText($data[0]['level_desc_dashboard'], '2FIELD');
$desc_publi=formatText($data[0]['level_desc_publication'], '2FIELD');
$desc_workshop=formatText($data[0]['level_desc_workshop'], '2FIELD');
$desc_news=formatText($data[0]['level_desc_news'], '2FIELD');

$level_object = new level;

?>
<div id="chemin">
	<ul>
		<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
		<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','level'); ?></a></li>
		<li><span><?php echo formatnavTitle(_t('level','mod'). " : ".$display_title); ?></span></li>
	</ul>
</div>
<!--end barre haute -->
<?php

if ($current_status == 'D') {
	$mask_status_D = "checked=\"checked\"";
	$mask_status_P = '';
} elseif ($current_status == 'P') {
	$mask_status_D = '';
	$mask_status_P = "checked=\"checked\"";
}
$mask_desc_ALL = '';
$mask_desc_DET = "checked=\"checked\"";
$layer_all_style = "style=\"display:none;\"";
$layer_det_style = "style=\"display:block;\"";


if(isset($_POST['enregistrer'])) {
  $array = unserialize(urldecode($_POST['data_table']));
  $result=$level_object->ModifyLevel($id, $array, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if($result) header("Location: ".safe_redirect($link_confirm));
  else  system_error();
}

if(isset($_POST['valider'])) {
  
  $a = array();
  $a['name']=$_POST['name'];
  $a['label']=$_POST['label'];
  $a['code']=$_POST['code'];
  $a['parent']=$_POST['parent'];
  
  if($_POST['description']=='ALL') {
    $a['desc_det_project']=$_POST['desc_for_all'];
    $a['desc_det_dashboard']=$_POST['desc_for_all'];
    $a['desc_det_publication']=$_POST['desc_for_all'];
    $a['desc_det_news']=$_POST['desc_for_all'];
    $a['desc_det_workshop']=$_POST['desc_for_all'];
  }
	if($_POST['description']=='DET') {
    $a['desc_det_project']=$_POST['desc_det_project'];
    $a['desc_det_dashboard']=$_POST['desc_det_dashboard'];
    $a['desc_det_publication']=$_POST['desc_det_publication'];
    $a['desc_det_news']=$_POST['desc_det_news'];
    $a['desc_det_workshop']=$_POST['desc_det_workshop'];
  }
  $a['status']=$_POST['status'];

  $integrity=$level_object->CheckDataIntegrity($a);
  if(is_string($integrity)) $format_text='2FIELD'; else $format_text='2HTML';

  
  if($_POST['description']=='ALL') {
    $form_description_all=formatText($_POST['desc_for_all'],$format_text);
    $layer_all_style= "style=\"display:block;\"";
    $layer_det_style= "style=\"display:none;\"";
    $mask_desc_ALL="checked=\"checked\"";
    $mask_desc_DET='';
  }
  if($_POST['description']=='DET') {
    if(isset($_POST['desc_det_project'])) $desc_project=formatText($_POST['desc_det_project'], $format_text);
    if(isset($_POST['desc_det_dashboard'])) $desc_dashboard=formatText($_POST['desc_det_dashboard'], $format_text);
    if(isset($_POST['desc_det_publication'])) $desc_publi=formatText($_POST['desc_det_publication'], $format_text);
    if(isset($_POST['desc_det_news'])) $desc_news=formatText($_POST['desc_det_news'], $format_text);
    if(isset($_POST['desc_det_workshop'])) $desc_workshop=formatText($_POST['desc_det_workshop'], $format_text);
    $layer_all_style= "style=\"display:none;\"";
    $layer_det_style= "style=\"display:block;\"";
    $mask_desc_ALL='';
    $mask_desc_DET="checked=\"checked\"";
  }
  
  $form_name=formatText($_POST['name'], $format_text);
  $form_code=formatText($_POST['code'], $format_text);
  $form_label=formatText($_POST['label'], $format_text);
  $form_parent=$_POST['parent'];
  
  if($_POST['status']=='D') $mask_status_D="checked=\"checked\""; else $mask_status_D='';
  if($_POST['status']=='P') $mask_status_P="checked=\"checked\""; else $mask_status_P='';
  
  $a=urlencode(serialize($a));
}

  // preparation affichage detaillé
  if(defined('MOD_PROJECT')) {
    $description_detail_form.= "<p>\n";
    $description_detail_form.= "<label for=\"desc_det_project\" >".mb_ucfirst(_t('level','desc_det_project'))." : </label>\n";
    $description_detail_form.= "<textarea id=\"desc_det_project\"  name=\"desc_det_project\" ".AREA_SETTINGS." class=\"largetextfield\" >".$desc_project."</textarea>\n";
    $description_detail_form.= "</p>\n";
  }
  if(defined('MOD_SDI')) {
    $description_detail_form.= "<p>\n";
    $description_detail_form.= "<label for=\"desc_det_dashboard\" >".mb_ucfirst(_t('level','desc_det_dashboard'))." : </label>\n";
    $description_detail_form.= "<textarea id=\"desc_det_dashboard\"  name=\"desc_det_dashboard\" ".AREA_SETTINGS." class=\"largetextfield\" >".$desc_dashboard."</textarea>\n";
    $description_detail_form.= "</p>\n";
  }
  if(defined('MOD_PUBLICATION')) {
    $description_detail_form.= "<p>\n";
    $description_detail_form.= "<label for=\"desc_det_publication\" >".mb_ucfirst(_t('level','desc_det_publication'))." : </label>\n";
    $description_detail_form.= "<textarea id=\"desc_det_publication\"  name=\"desc_det_publication\" ".AREA_SETTINGS." class=\"largetextfield\" >".$desc_publi."</textarea>\n";
    $description_detail_form.= "</p>\n";
  }
  if(defined('MOD_NEWS')) {
    $description_detail_form.= "<p>\n";
    $description_detail_form.= "<label for=\"desc_det_news\" >".mb_ucfirst(_t('level','desc_det_news'))." : </label>\n";
    $description_detail_form.= "<textarea id=\"desc_det_news\"  name=\"desc_det_news\" ".AREA_SETTINGS." class=\"largetextfield\">".$desc_news."</textarea>\n";
    $description_detail_form.= "</p>\n";
  }
  if(defined('MOD_WORKSHOP')) {
    $description_detail_form.= "<p>\n";
    $description_detail_form.= "<label for=\"desc_det_workshop\" >".mb_ucfirst(_t('level','desc_det_workshop'))." : </label>\n";
    $description_detail_form.= "<textarea id=\"desc_det_workshop\"  name=\"desc_det_workshop\" ".AREA_SETTINGS." class=\"largetextfield\">".$desc_workshop."</textarea>\n";
    $description_detail_form.= "</p>\n";
  }

include_once("../lib/input_helpers.php");
// select-box des niveaux parents
$data=$sql_object->DBSelect(SQL_getLevelsList());
$select_parent=LevelSelectBox($data, "parent", $form_parent, $form_id);

?>

<?php
if(!isset($integrity) || is_string($integrity)) {

$js = "$('#description_ALL').click(function() {
						$('#det').fadeOut();
						$('#all').fadeIn();
					});
					$('#description_DET').click(function() {
						$('#all').fadeOut();
						$('#det').fadeIn();
					});";

footerAddInlineJS($js);
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2($display_title); ?></h2>
		<form id="modlevel" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"	method="post">
			<p>
				<label for="name"><?php echo mb_ucfirst(_t('level','name')); ?> : *</label>
				<input name="name" type="text" class="textfield" id="name" maxlength="200" value="<?php echo $form_name; ?>" required />
			</p>
			<p>
				<label for="code"><?php echo mb_ucfirst(_t('level','code')); ?> : </label>
				<input name="code" type="text" class="textfield" id="code" maxlength="100" value="<?php echo $form_code; ?>"  />
			</p>
			<p>
				<label for="label"><?php echo mb_ucfirst(_t('level','label')); ?> : *</label>
				<input name="label" type="text" class="textfield" id="label" maxlength="200" value="<?php echo $form_label; ?>" required />
			</p>
			<input name="status" type="hidden" id="status" value="P" />
			<p>
				<label for="parent"><?php echo mb_ucfirst(_t('level','parent')); ?> : *</label>
    	<?php echo $select_parent; ?>
			</p>

			<div class="label"><?php echo mb_ucfirst(_t('level','description')); ?> : </div>
			<div class="rightpanel">
				<input name="description" class="radioinline" type="radio" id="description_ALL" value="ALL" <?php echo $mask_desc_ALL; ?> />
				<label for="description_ALL"><?php echo mb_ucfirst(_t('level','description_all')); ?></label>
				<input name="description" class="radioinline" type="radio" id="description_DET" value="DET" <?php echo $mask_desc_DET; ?> />
				<label for="description_DET"><?php echo mb_ucfirst(_t('level','description_det')); ?></label>
			</div>

			<div>
				<div id="all" <?php echo $layer_all_style; ?>>
					<p>
						<label for="desc_for_all"><?php echo _t('level','desc_all'); ?> : </label>
						<textarea id="desc_for_all" name="desc_for_all" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_description_all; ?></textarea>
					</p>
				</div>
				<div id="det" <?php echo $layer_det_style; ?>><?php echo $description_detail_form; ?></div>
				<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
				<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
				<input name="todo" type="hidden" value="<?php echo $todo; ?>"	id="todo" />
    		<?php echo cancel_button('javascript:history.go(-1);'); ?>
    		<input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
			</div>
		</form>
	</div>
	<!-- closing #content -->
</div>
<!-- closing .contentcontainer -->
<?php
// Récapitulatif
} else	{

if($form_parent != 0) {
	$data = $sql_object->DBSelect(SQL_getLevelParent($form_parent));
	$display_parent = formatText($data[0]['level_name'],'2HTML');
}

?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
		<h2><?php echo _t('recap','title') ?></h2>
<?php
echo "<dl class=\"summary\">";
echo "<dt>".formatText(mb_ucfirst(_t('level','name')),'2HTML')." :</dt>";
echo "<dd>". $form_name. "</dd>";
echo "<dt>".formatText(mb_ucfirst(_t('level','code')),'2HTML')." :</dt>";
echo "<dd>". empty_nc($form_code). "</dd>";
echo "<dt>".mb_ucfirst(_t('level','label'))." :</dt>";
echo "<dd>". $form_label."</dd>";
if($form_parent != 0) {
  echo "<dt>". formatText(mb_ucfirst(_t('level','parent')),'2HTML'). " :</dt>";
  echo "<dd>".$display_parent."</dd>";
}
if($_POST['description']=='ALL') {
  echo "<dt>".formatText(mb_ucfirst(_t('level','desc_all')),'2HTML')." :</dt>";
  echo "<dd>". empty_nc(formatText($form_description_all,'2HTML'))."</dd>";
}
if($_POST['description']=='DET') {
  if(defined('MOD_PROJECT')) {
    echo "<dt>".formatText(mb_ucfirst(_t('level','desc_det_project')),'2HTML')."</dt>";
    echo "<dd>". empty_nc($desc_project)."</dd>";
  }
  if(defined('MOD_SDI')) {
    echo "<dt>".formatText(mb_ucfirst(_t('level','desc_det_dashboard')),'2HTML')."</dt>";
    echo "<dd>". empty_nc($desc_dashboard)."</dd>";
  }
  if(defined('MOD_PUBLICATION')) {
    echo "<dt>".formatText(mb_ucfirst(_t('level','desc_det_publication')),'2HTML')."</dt>";
    echo "<dd>". empty_nc($desc_publi)."</dd>";
  }
  if(defined('MOD_NEWS')) {
    echo "<dt>".formatText(mb_ucfirst(_t('level','desc_det_news')),'2HTML')."</dt>";
    echo "<dd>". empty_nc($desc_news)."</dd>";
  }
  if(defined('MOD_WORKSHOP')) {
    echo "<dt>".formatText(mb_ucfirst(_t('level','desc_det_workshop')),'2HTML')."</dt>";
    echo "<dd>". empty_nc($desc_workshop)."</dd>";
  }
}
echo "</dl>";
?>
<form id="modlevel" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"	method="post">
			<div>
				<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
				<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
				<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
				<input name="data_table" type="hidden" value="<?php echo $a; ?>" id="data_table" />
    		<?php echo cancel_button('?rub='.$rub.'&amp;todo=list'); ?>
    		<input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
    		<input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
			</div>
		</form>
	</div>
	<!-- closing #content -->
</div>
<!-- closing .contentcontainer -->
<?php } ?>