<?php
/**
 * Level module
 * 
 * Delete given level from back-office
 * 
 * @package linea21\core\level
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once("../level/display.php");

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];


$mask_mass_del="style=\"display:none;\"";
$mask_mass_mod="style=\"display:none;\"";
$mask_del_meth='';
$mask_mod_meth='';
$form_level_transfert=0;


$level_object = new level;


$levels = $sql_object->DBSelect(SQL_getLevelsList());
$level_children = getLevelChildren($levels, $id);

// get current id affected ressources
$affectedRows = $level_object->get_affected_ressources($id, $sql_object);

// then, we add affected rows from children levels
if(count($level_children) > 0) {
	foreach ($level_children as $child) {
		$affectedRows = $level_object->get_affected_ressources($child['level_id'], $sql_object, $affectedRows);
	}
}



if(isset($_POST['valider'])) {
	
  $integrity=1;

  if(isset($_POST['sup_method'])) {
  	
    $sup_method=$_POST['sup_method'];
    if($sup_method=='delete') {
      $type='MASS_DELETE';
      $mask_mass_del="style=\"display:block;\"";
      $mask_del_meth="checked=\"checked\"";
      $transfer_id = 0;
    }
    if($sup_method=='modify') {
      $type='MASS_MODIFY';
      $mask_mod_meth='checked="checked"';
      $mask_mass_mod="style=\"display:block;\"";
      if($_POST['transfer_id'] == 0) $integrity = _t('level','sup_nolevel');
      else $transfer_id=$_POST['transfer_id'];
    }
    if($_SESSION['securityaction']!=md5($_POST['securitycode'])) {
      $integrity=_t('security','message');
    }
    
    if(!is_string($integrity)) {
      
      if($root == true) $level_object->SetRoot();
      $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
      $result=$level_object->DeleteLevel($id, $sql_object, $type, $transfer_id);
      if(is_numeric($result)) header("Location: ".safe_redirect($link_confirm));
      else  system_error();
    }
    
  }	else  {
    $integrity=_t('level','sup_nomethod');
  }

}

include_once("../lib/input_helpers.php");
// select-box des niveaux parents
$data=$sql_object->DBSelect(SQL_getLevelsList());
$select_parent=LevelSelectBox($data, "transfer_id", $form_level_transfert, $id);

$record = $sql_object->DBSelect(SQL_getoneLevel($id));

// Do record exists?
if(!isset($record[0]['level_name'])) redirect_to('@module_default');

$level_name=formatText($record[0]['level_name'],'2HTML');

$js = "$('#sup_method_del').click(function() {
					$('#mass_modify').hide();
					$('#transfer').hide();
					$('#mass_delete').fadeIn();
				});
				$('#sup_method_mod').click(function() {
					$('#mass_modify').fadeIn();
					$('#transfer').slideDown();
					$('#mass_delete').hide();
				});";

footerAddInlineJS($js);

?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','level')?></a></li>
	<li><span><?php echo formatNavTitle($level_name); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?> <?php echo "<h2>".formatTitleh2($level_name)."</h2>"; ?>
<form id="suplevel" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
	
	<p>
		<input type="radio" name="sup_method" id="sup_method_del" value="delete" <?php echo $mask_del_meth; ?> required />
		<label for="sup_method_del" class="autowidth"><?php echo _t('level','sup_massd'); ?></label>
	</p>
	<p>
		<input type="radio" name="sup_method" id="sup_method_mod" value="modify" <?php echo $mask_mod_meth; ?> />
		<label for="sup_method_mod" class="autowidth"><?php echo _t('level','sup_massm'); ?></label>
	</p>
	<p id="transfer" <?php echo $mask_mass_mod; ?>>
		<label for="transfer_id"><?php echo _t('level','sup_transfert'); ?></label>
		<?php echo $select_parent; ?>
	</p>
	<p class="info">
		<strong><?php echo sprintf(_t('items', 'associated'), $affectedRows['total']); ?></strong><br />
		<span class="small">[<?php echo  _t('content', 'in_news') . ' : ' . $affectedRows['news'] . ' / ' . _t('content', 'in_publication') . ' : ' . $affectedRows['publication'] . ' / ' . _t('content', 'in_project') . ' : ' . $affectedRows['project'] . ' / ' . _t('content', 'in_workgroup') . ' : ' . $affectedRows['workshop']. ' / ' . _t('content', 'in_indicator') . ' : ' . $affectedRows['indicator'] . ' / ' . _t('content', 'in_directory') . ' : ' . $affectedRows['directory'];?>]</span>
	</p>
	<p class="code-confirmation">
	<img src="../lib/securitycode.php" alt="<?php echo _t('security','info2'); ?>" id="securityimg" />
		<label for="securitycode" class="autowidth"><?php echo _t('security','info'); ?></label>
		<input type="text" class="shorttextfield" id="securitycode" maxlength="5" name="securitycode" required />
	</p>
	
	<?php

	echo "<div class=\"info\"  id=\"mass_delete\" ".$mask_mass_del.">\n";
	echo "\t<i class=\"icon-trash\"></i> "._t('level','sup_mass_delete')."\n";
	echo "</div>\n";
	echo "<div class=\"info\" id=\"mass_modify\" ".$mask_mass_mod.">\n";
	echo "\t<i class=\"icon-exchange\"></i> "._t('level','sup_mass_modify')."\n";
	echo "</div>\n";
	?>
	<div>
		<input name="id" type="hidden" value="<?php echo $id; ?>" />
		<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
		<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
		<?php echo cancel_button('javascript:history.go(-1);'); ?>
		<input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
	</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->