CKEDITOR.editorConfig = function( config )
{
	// Define changes to default configuration here.
	
	 config.language = lang;
	 
	// Sets SCAYT language
	 if(lang == 'en') { 
		 langscayt = 'en_GB';
	 } else {
		 langscayt = lang + '_' + lang.toUpperCase();
	 }
	 config.scayt_sLang = langscayt;

	 config.entities = false;
	 config.entities_greek = false;
	 config.entities_latin = false;
	 config.toolbar = 'Linea21';
	 config.width = CKE_windowSize;
	 
	 /**
	 config.resize_maxWidth = 600;
	 config.resize_minWidth = 600;
	 config.removePlugins = 'resize';
	 * */
	 
	 // config.autoGrow_minHeight = 200;
	 config.autoGrow_maxHeight = 800;
	 config.autoGrow_bottomSpace = 20;
	 config.autoGrow_onStartup = true;
	 // config.removePlugins = 'resize';
	 
	 // Deprecated but style work ! : https://docs.ckeditor.com/ckeditor4/docs/#!/api/CKEDITOR.config-cfg-pasteFromWordRemoveFontStyles
	 // see also : https://docs.ckeditor.com/ckeditor4/docs/#!/api/CKEDITOR.editor-event-afterPasteFromWord
	 // Not needed anymore, since we use new filter mechanism on 'afterPasteFromWord' event
	 // config.pasteFromWordRemoveFontStyles = true; 

	 
	 config.embed_provider = '//ckeditor.iframe.ly/api/oembed?url={url}&callback={callback}';
	 
	 config.removePlugins = 'link';
	 config.extraPlugins = 'footnotes,magicline,pastefromword,adv_link,embed,autoembed,image,html5audio,widget,autogrow,autolink,ckawesome';
	 config.allowedContent = CKE_allowContent; // prevent ckeditor removing attributes like id or class from div
	 config.extraAllowedContent = CKE_allowExtraContent; // prevent ckeditor removing attributes like id or class from div
	 config.protectedSource.push(/<i[^>]*><\/i>/g); // ALLOW <i></i>
	 
	 // oembed options
	 // define a css class for the embeded content wrapper (div)
	 // config.oembed_WrapperClass = 'embededContent';
	 
	 config.disableNativeSpellChecker = true;
	 
	 config.toolbar_Linea21 =
	 [
	     ['Cut','Copy','Paste'],
	     ['Undo','Redo','-','Find','Replace','-','RemoveFormat', 'CopyFormatting'],
	     //['Source','About','-','Print'],
	     ['Source','About','-','Print','SpellChecker', 'Scayt'], // enable online spell checker Scayt
	     ['Maximize', 'ShowBlocks'],
	     '/',
	     ['Bold','Italic','Underline','Strike','-','Subscript','Superscript'],
	     ['NumberedList','BulletedList','-','Outdent','Indent','Blockquote'],
	     ['JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'],
	     ['Link','Unlink','Anchor'],
	     ['Image','Embed','Html5audio', 'Table', 'HorizontalRule','SpecialChar'],
	     ['ckawesome', 'TextColor', 'Format','FontSize', 'Styles', 'Footnotes'],
	     // ['Styles','Format','Font','FontSize'],
	     // ['TextColor','BGColor']
	 ];
	 
	// Remove some buttons provided by the standard plugins, which are
		// not needed in the Standard(s) toolbar.
		// config.removeButtons = 'Underline,Subscript,Superscript';

		// Set the most common block elements.
		config.format_tags = 'p;h1;h2;h3;h4;pre';

};
