<?php
/**
 * News module
 * 
 * Add news page
 * 
 * @package linea21\modules\news
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('news')) ReloadIndex('admin');
////////////
?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','news'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('news','add')); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once("../lib/input_helpers.php");
include_once(override('../level/mysql.inc.php', THEME_ADMIN_PATH));

$form_title='';
$form_header='';
$form_body='';
$form_level=0;
$form_scale=0;

$mask_statut_P="checked=\"checked\"";
$mask_statut_D='';
$form_tags='';


$news_object = new news;

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$news_object->AddNews($data_table, $sql_object);
  
  // if attached tags are provided we store them in db
  if(!empty($data_table['10']) && is_numeric($result)) {
	  include_once('../class/class.tag.php');
	  $otag = new tag();
	  
	  $otag->addTags('news', $result, $data_table['10']);
  }
  
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if(is_numeric($result)) header("Location: ".safe_redirect($link_confirm));
  else  system_error();
}

if(isset($_POST['valider'])) {
    
  $table = array();
  $table[0]=$_POST['news_title'];
  $table[1]=$_POST['news_header'];
  $table[2]=$_POST['news_body'];
  $table[3]=$_POST['news_level'];
  $table[4]=$_POST['news_scale'];
  $table[5]=0; //range
  $table[6]=$l21auth->GetSessionElement('id'); // ID posteur
  $table[7]=''; // date de péremption
  $table[8]='N'; // is_national
  $table[9]=$_POST['news_statut'];
  $table[10]=$_POST['news_tags'];

  $integrity=$news_object->CheckDataIntegrity($table);


  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
  }
  $form_title=formatText($_POST['news_title'], $text_format);
  $form_header=formatText($_POST['news_header'], $text_format);
  $form_body=formatText($_POST['news_body'], $text_format);
  $form_level=$_POST['news_level'];
  $form_scale=$_POST['news_scale'];
  $form_tags=$_POST['news_tags'];


  if($_POST['news_statut']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($_POST['news_statut']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
  $table=urlencode(serialize($table));
}


if(!isset($integrity) || is_string($integrity)) {

	// select-box des niveaux
	$data=$sql_object->DBSelect(SQL_getLevelsList());
	$select_level=LevelSelectBox($data, "news_level", $form_level);

  // select-box des échelles
  $data=$sql_object->DBSelect($req_list_scale);
  $select_scale=ScaleSelectBox($data, "news_scale", $form_scale);

}

?>

<?php
if(!isset($integrity) || is_string($integrity)) {
	
	// TextboxList CSS/JS inclusion
	addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.css');
	addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.Autocomplete.css');
	footerAddJS('../lib/js/TextboxList-jQuery/Source/GrowingInput.js');
	footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.js');
	footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.Autocomplete.js');
?>
<script type="text/javascript">
<!--
$(document).ready( function() {
				// Autocomplete initialization
				var t1 = new $.TextboxList('#news_tags', {unique: true, plugins: {autocomplete: {onlyFromValues: false, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});
				$.ajax({url: '../admin/_ajax_tag_autocomplete.php', dataType: 'json', success: function(r){
					t1.plugins['autocomplete'].setValues(r);
				}});
				
				$("div.textboxlist").each(function() {
				    $(this).append('<p class="soft-emphase"><?php echo _t('msg','textboxlist_notice') ?><\/p>');
				});
});

//-->
</script>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2(_t('news','add_title')); ?></h2>
<form id="addnews" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
  <label for="news_title"><?php echo mb_ucfirst(_t('news','title')); ?> : *</label>
  <input name="news_title" type="text" maxlength="200" id="news_title" class="textfield" value="<?php echo $form_title; ?>" required />
</p>
<p>
  <label for="news_header"><?php echo mb_ucfirst(_t('news','header')); ?> : *</label>
  <textarea id="news_header" name="news_header" class="largetextfield" <?php echo AREA_SETTINGS; ?> required><?php echo $form_header; ?></textarea>
</p>
<p>
  <label for="news_body"><?php echo mb_ucfirst(_t('news','body')); ?> : *</label>
  <textarea id="news_body" name="news_body" class="largetextfield" <?php echo AREA_SETTINGS; ?> required><?php echo $form_body; ?></textarea>
</p>
<p>
  <label for="news_level"><?php echo mb_ucfirst(_t('news','level')); ?> : </label>
  <?php echo $select_level; ?>
</p>
<p>
<label for="news_scale"><?php echo mb_ucfirst(_t('news','scale')); ?> : </label>
  <?php echo $select_scale; ?>
</p>
<p>
  <label for="news_tags"><?php echo mb_ucfirst(_t('tag','name')); ?> : </label>
  <input name="news_tags" type="text" maxlength="500" id="news_tags" class="textfield" value="<?php echo $form_tags; ?>" />
</p>
  <div class="label"><?php echo mb_ucfirst(_t('news','statut')); ?> : *</div>
  <div class="rightpanel">
  <input name="news_statut" type="radio" id="statut_P" value="P" <?php echo $mask_statut_P; ?> required /><label for="statut_P"><?php echo mb_ucfirst(_t('statut','public')); ?></label>
  <input name="news_statut" type="radio" id="statut_D" value="D" <?php echo $mask_statut_D; ?> /><label for="statut_D"><?php echo mb_ucfirst(_t('statut','draft')); ?></label>
  </div>
<div>
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <?php echo cancel_button('javascript:history.go(-1);'); ?>
  <input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->

	<?php
	// Récapitulatif
} else	{
	
	// getting level name
	if($form_level==0) $level_name=empty_nc('');
	else {
		$record=$sql_object->DBSelect(SQL_getoneLevel($form_level));
		$level_name=formatText($record[0]['level_name'], '2HTML');
	}
	
	// getting scale name
	$r = $sql_object->DBSelect(SQL_getonescaleDenomination($form_scale));
	if(isset($r[0]['scale_denomination'])) {
		$scale_denomination = formatText($r[0]['scale_denomination'], '2HTML');
	} else {
		$scale_denomination = empty_none('');
	}

  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<?php
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('news','title'))." :</dt>\n";
echo "<dd>". $form_title."</dd>\n";
echo "<dt>". mb_ucfirst(_t('news','header')). " :</dt>\n";
echo "<dd>".empty_nc($form_header)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('news','body'))." :</dt>\n";
echo "<dd>".$form_body."</dd>\n";
echo "<dt>".mb_ucfirst(_t('news','level'))." :</dt>\n";
echo "<dd>".$level_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('news','scale'))." :</dt>\n";
echo "<dd>".$scale_denomination."</dd>\n";
echo "<dt>".mb_ucfirst(_t('tag','name'))." :</dt>\n";
echo "<dd>".empty_none(str_replace(',', ', ', $form_tags))."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','statut'))." :</dt>\n";
echo "<dd>". display_statut($_POST['news_statut']). "</dd>\n";
echo "</dl>\n";
?>
<form id="addscale" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <div>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
    <?php echo cancel_button('?rub=news&amp;todo=list'); ?>
    <input name="retour" type="button" value="<?php echo _t('btn','preview'); ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save'); ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php } ?>