<?php
/**
 * Page module
 * 
 * Add page's page
 * 
 * @package linea21\modules\page
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////
?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','page'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('page','add')); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
$form_title='';
$form_header='';
$form_body='';
$mask_statut_P="checked=\"checked\"";
$mask_statut_D='';
$mask_homepage='';



$page_object = new page;

if(isset($_POST['enregistrer'])) {
  $data_array=unserialize(urldecode($_POST['data_array']));
  $result=$page_object->AddPage($data_array, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if(is_numeric($result)) header("Location: ".safe_redirect($link_confirm));
  else  system_error();
}

if(isset($_POST['valider'])) {
    
  $a = array();
  $a[0]=$_POST['page_title'];
  $a[1]=$_POST['page_header'];
  $a[2]=$_POST['page_body'];
  $a[3]=$l21auth->GetSessionElement('id'); // ID posteur
  $a[4]=$_POST['page_status'];

  $page_object= new page;
  $integrity=$page_object->CheckDataIntegrity($a);

  if(isset($_POST['page_homepage'])) {
  	$mask_homepage =' checked="checked"';
  	$a[5] = true;
  	$homepage_display = _t('divers', 'yes');
  } else {
  	$mask_homepage ='';
  	$a[5] = false;
  	$homepage_display = _t('divers', 'no');
  }


  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
  }
  $form_title=formatText($_POST['page_title'], $text_format);
  $form_header=formatText($_POST['page_header'], $text_format);
  $form_body=formatText($_POST['page_body'], $text_format);


  if($_POST['page_status']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($_POST['page_status']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
  $a=urlencode(serialize($a));
}

?>

<?php
if(!isset($integrity) || is_string($integrity)) {
?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2(_t('page','add_title')); ?></h2>
<form id="addpage" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
  <label for="page_title"><?php echo mb_ucfirst(_t('page','title')); ?> : *</label>
  <input name="page_title" type="text" maxlength="200" id="page_title" class="textfield" value="<?php echo $form_title; ?>" required />
</p>
<p>
  <label for="page_header"><?php echo mb_ucfirst(_t('page','header')); ?> : *</label>
  <textarea id="page_header" name="page_header" class="largetextfield" <?php echo AREA_SETTINGS; ?> required><?php echo $form_header; ?></textarea>
</p>
<p>
  <label for="page_body"><?php echo mb_ucfirst(_t('page','body')); ?> : *</label>
  <textarea id="page_body" name="page_body" class="largetextfield" <?php echo AREA_SETTINGS; ?> required><?php echo $form_body; ?></textarea>
</p>
<div class="mts">
	<div class="label"><?php echo mb_ucfirst(_t('page','is_homepage')); ?> :</div>
	<div class="rightpanel">
  		<input type="checkbox" class="checkbox-switch" name="page_homepage" id="page_homepage" value="" <?php echo $mask_homepage; ?> />
		<label for="page_homepage"></label>
	</div>
</div>
  <div class="label"><?php echo mb_ucfirst(_t('page','statut')); ?> : *</div>
  <div class="rightpanel">
  <input name="page_status" type="radio" id="status_P" value="P" <?php echo $mask_statut_P; ?> required /><label for="status_P"><?php echo mb_ucfirst(_t('statut','public')); ?></label>
  <input name="page_status" type="radio" id="status_D" value="D" <?php echo $mask_statut_D; ?> /><label for="status_D"><?php echo mb_ucfirst(_t('statut','draft')); ?></label>
  </div>
<div>
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <?php echo cancel_button('javascript:history.go(-1);'); ?>
  <input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
	<?php
	// Récapitulatif
} else	{
?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<?php
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('page','title'))." :</dt>\n";
echo "<dd>". $form_title."</dd>\n";
echo "<dt>". mb_ucfirst(_t('page','header')). " :</dt>\n";
echo "<dd>".empty_nc($form_header)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('page','body'))." :</dt>\n";
echo "<dd>".$form_body."</dd>\n";
echo "<dt>".mb_ucfirst(_t('page','is_homepage'))." :</dt>\n";
echo "<dd>".$homepage_display."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','statut'))." :</dt>\n";
echo "<dd>". display_statut($_POST['page_status']). "</dd>\n";
echo "</dl>\n";
?>
<form id="addscale" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <div>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="data_array" type="hidden" value="<?php echo $a; ?>" id="data_array" />
    <?php echo cancel_button('?rub=page&amp;todo=list'); ?>
    <input name="retour" type="button" value="<?php echo _t('btn','preview'); ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save'); ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
}
?>