<?php
/**
 * Page module
 * 
 * Display pages list in back-office
 * 
 * @package linea21\modules\page
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

if(!isset($_GET['statut']) || $_GET['statut']==-1) $statut=-1;
elseif($_GET['statut']!=-1) $statut=$_GET['statut'];


if(!isset($_GET['debut'])) $debut=0;
else $debut=$_GET['debut'];

$mask_statut_1='';
$mask_statut_2='';

if($statut=='public') $mask_statut_1='selected="selected"';
if($statut=='draft') $mask_statut_2='selected="selected"';


// Nombre d'enregistrement total dans la bdd
$result_nb_req=$sql_object->DBSelect($req_count_page);
$bdd_nb=$result_nb_req[0]['num_rows'];
$bdd_nb_display = $bdd_nb." "._t('page','nb_total')."<br />\n";

if($statut!=-1) {
  $link_back="<div class=\"filter\"><a href=\"".$rub_link."&amp;todo=list\">"._t('page','all')."</a></div>";
  $req_count_page=SQL_getCountPagesList($statut);
  $result_nb_req=$sql_object->DBSelect($req_count_page);
  $count_request=$result_nb_req[0]['num_rows'];
  $req_list_page=SQL_getPagesList($debut, SELECT_LIMIT, $statut);
  $result_list=$sql_object->DBSelect($req_list_page);
} else {
  $link_back='';
  $count_request=$bdd_nb;
  $req_list_page=SQL_getPagesList($debut, SELECT_LIMIT, $statut);
  $result_list=$sql_object->DBSelect($req_list_page);
}

if($count_request<=1) $count_request_display = _t('divers','query_result')." : ".$count_request." "._t('divers','record')."<br />\n";
else $count_request_display = _t('divers','query_result')." : ".$count_request." "._t('divers','records')."<br />\n";

$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";
$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_statut=$rub_link."&amp;todo=list&amp;statut=";
$link_self=$link_statut.$statut;


// Liste des statuts disponibles
$select_statut="<select name=\"statut_filter\" id=\"statut_filter\">\n";
$select_statut.="<option value=\"-1\">"._t('page','statut_filter')."</option>\n";
$select_statut.="<option value=\"".$link_statut."public\"".$mask_statut_1.">".display_statut('P')."</option>\n";
$select_statut.="<option value=\"".$link_statut."draft\"".$mask_statut_2.">".display_statut('D')."</option>\n";
$select_statut.="</select>\n";

$js = "	$('#statut_filter').change(function() {
					if($(this).val() != -1) window.location = $(this).val();
				});";

footerAddInlineJS($js);
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','page'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('page','list')); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
<div id="content"><?php
echo $link_back;
?>
<div class="filterselect"><?php
echo $select_statut;
?></div>
<p><?php
echo $bdd_nb_display;
echo $count_request_display;
?></p>
<?php
echo linkin_page($link_self, $count_request, $debut);

if($result_list!=0) {
  echo "<table class=\"sortable multisort\" id=\"sort-table\">\n";
  echo "<thead>\n";
  echo "<tr>\n";
  echo "<td>".mb_ucfirst(_t('page','title'))."</td>\n";
  echo "<td>".mb_ucfirst(_t('page','is_homepage'))."</td>\n";
  echo "<td>".mb_ucfirst(_t('divers','date_crea'))."</td>\n";
  echo "<td>".mb_ucfirst(_t('divers','date_publi'))."</td>\n";
  echo "<td class=\"sorter-false\">&nbsp;<span class=\"visually-hidden\">".mb_ucfirst(_t('divers','actions'))."</span></td>\n";
  echo "</tr>\n";
  echo "</thead>\n";

  echo "<tbody>\n";


  for($i=0; $i<count($result_list); $i++) {
    $page_title=formatText(cutText($result_list[$i]['page_title'],70), '2HTML');
    $page_id = '<span class="page-id">['. $result_list[$i]['page_id']. ']</span>';
    $page_owner=$result_list[$i]['page_posted_by'];
    $page_statut=$result_list[$i]['page_status'];

    if($result_list[$i]['page_homepage'] == 'Y') $homepage = '<div class="is_homepage" title="'._t('divers', 'yes').'"><i class="icon-ok"></i><span>'._t('divers', 'yes').'</span></div>';
    else $homepage = '<div class="is_homepage" title="'._t('divers', 'no').'"><span>'._t('divers', 'no').'</span></div>';

    $page_published_date = $page_statut=='D' ? _t('statut','draft') : $result_list[$i]['page_published_date_display'];
    echo "<tr id=\"page-".$result_list[$i]['page_id']."\">\n";
    echo "<td><a href=\"".$link_det.$result_list[$i]['page_id']."\" title=\""._t('page','det') . ' : ' . formatText($result_list[$i]['page_title'], '2ATT') ."\">".$page_title ."</a>" . $page_id ."</td>\n";
    echo "<td>".$homepage."</td>\n";
    echo "<td>".$result_list[$i]['page_date_crea_display']."</td>\n";
    echo "<td>".$page_published_date."</td>\n";
    echo "<td style=\"width:80px\">\n";

    if ($l21auth->GetSessionElement('id') == $page_owner || $l21auth->isSuperAdmin()) {
      echo "<div class=\"iconetab\">\n";
      echo "<a href=\"".$link_sup.$result_list[$i]['page_id']."\" class=\"ico_sup\" title=\""._t('page','sup')."\"><i class=\"icon-trash\"></i><span>" . _t('page','sup') . "</span></a>\n";
      echo "<a href=\"".$link_mod.$result_list[$i]['page_id']."\" class=\"ico_mod\" title=\""._t('page','mod')."\"><i class=\"icon-pencil\"></i><span>" . _t('page','mod') . "</span></a>\n";
      echo "</div>\n";
    } else echo '';
    echo "</td>\n";
    echo "</tr>\n";
  }

  echo "</tbody>";
  echo "</table>";
} else {
  echo "<div class=\"info\">"._t('page','noresult')."</div>";
}
echo linkin_page($link_self, $count_request, $debut);
?>

<?php
// Ability to sort table
addDynamicCSS('../lib/js/jquery.tablesorter/theme.default.css');
footerAddJS('../lib/js/jquery.tablesorter/jquery.tablesorter.min.js');
$str = '$("table.multisort").tablesorter({	});';
footerAddInlineJS($str);

?>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->