<?php
/**
 * Page module
 * 
 * MySQL queries related to page module
 * 
 * @package linea21\modules\page
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////


$req_count_page = "SELECT COUNT(page_id) as num_rows FROM " . T_PAGE . " WHERE page_status <> 'E';";


$req_quickbox_add = "SELECT page_id, LEFT(page_title, 50) as page_title, page_date_crea, DATE_FORMAT(page_date_crea, '".toStringSqlDate('long')."') AS page_date_crea_display FROM " . T_PAGE . " WHERE page_status  = 'P' OR page_status = 'D'  ORDER BY page_date_crea DESC LIMIT 0 , 10;";
$req_quickbox_sup = "SELECT page_id,  LEFT(page_title, 50) as page_title, page_last_modify, DATE_FORMAT(page_last_modify, '".toStringSqlDate('long')."') AS page_last_modify_display, DATE_FORMAT(page_date_crea, '".toStringSqlDate()."') AS page_date_crea_display FROM " . T_PAGE . " WHERE page_status = 'E' ORDER BY page_last_modify DESC LIMIT 0 , 10;";
$req_quickbox_mod = "SELECT page_id, LEFT(page_title, 50) as page_title, page_last_modify, DATE_FORMAT(page_last_modify, '".toStringSqlDate('long')."') AS page_last_modify_display, DATE_FORMAT(page_date_crea, '".toStringSqlDate()."') AS page_date_crea_display FROM " . T_PAGE . " WHERE page_status  <> 'E' ORDER BY page_last_modify DESC LIMIT 0 , 10;";
$req_quickbox_list = "SELECT page_id,  LEFT(page_title, 50) as page_title, page_published_date, DATE_FORMAT(page_published_date, '".toStringSqlDate('long')."') AS page_published_date_display, DATE_FORMAT(page_date_crea, '".toStringSqlDate()."') AS page_date_crea_display FROM " . T_PAGE . " WHERE page_status <> 'E' AND  page_published_date <> '0001-01-01' ORDER BY page_published_date DESC LIMIT 0 , 10;";


function SQL_getoneCompletePage($page_id, $force_status = false) {

	if($force_status) $force_status = " AND ". sql_status_filter('page_status', $force_status);
	else $force_status = "";

  $q =	"SELECT P.page_title, P.page_header, P.page_homepage, P.page_body, P.page_status, P.page_posted_by, U.user_login, ".
				"DATE_FORMAT(P.page_date_crea, '".toStringSqlDate()."') AS page_date_crea_display, ".
				"DATE_FORMAT(P.page_last_modify, '".toStringSqlDate('long')."') AS page_last_modify_display, ".
				"DATE_FORMAT(P.page_published_date, '".toStringSqlDate()."') AS page_published_date_display ".
				"FROM " . T_PAGE . " AS  P ".
				"LEFT OUTER JOIN ".T_USER." AS U on P.page_posted_by=U.user_id ".
				"WHERE page_id='".$page_id."'". $force_status.";";

  return $q;
}


function SQL_getPagesList($debut, $limite, $status) {
  switch ($status) {
    case 'public':
      $mask=" WHERE page_status = 'P'";
      $orderby="page_published_date DESC";
      break;
    case 'draft':
      $mask=" WHERE page_status = 'D'";
      $orderby="page_date_crea DESC";
      break;
    default:
      $mask=" WHERE page_status <> 'E'";
      $orderby="page_date_crea DESC";
      break;
  }

  $q= "SELECT page_id, LEFT(page_title, 60) AS page_title, page_title AS complete_page_title, page_published_date, page_date_crea, ".
			  "page_homepage, page_header, page_status, page_posted_by, user_login, ".
			  "DATE_FORMAT(page_date_crea, '".toStringSqlDate()."') AS page_date_crea_display, ".
			  "DATE_FORMAT(page_published_date, '".toStringSqlDate()."') AS page_published_date_display, ".
			  "DATE_FORMAT(page_last_modify, '".toStringSqlDate()."') AS page_last_modify_display ".
			  "FROM " . T_PAGE ." ".
			  "LEFT OUTER JOIN ".T_USER." AS U on page_posted_by=U.user_id ".

  $mask." ORDER BY ".$orderby." LIMIT ".$debut." , ".$limite.";";

  return $q;
}

function SQL_getCountPagesList($status) {
  switch ($status) {
    case 'public':
      $mask="WHERE page_status = 'P'";
      break;
    case 'draft':
      $mask="WHERE page_status = 'D'";
      break;
    default:
      $mask="WHERE page_status <> 'E'";
      break;
  }

  $q  = "SELECT COUNT(page_id) AS num_rows FROM " . T_PAGE ." ";
  $q .= $mask.";";
  return $q;
}


function SQL_getPageTitle($page_id, $force_status = false) {

	if($force_status) $force_status = " AND ". sql_status_filter('page_status', $force_status);
	else $force_status = "";

  $q =	"SELECT P.page_title, P.page_posted_by FROM " . T_PAGE . " AS  P WHERE page_id='".$page_id."'". $force_status.";";

  return $q;
}


?>