<?php
/**
 * System module - Files editor
 * 
 * Files edition in back-office
 * Available for themes (templates) and plugins
 * 
 * @package linea21\core\system
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
	include_once ("../lib/lib_common.php");
	ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

include_once('../lib/input_helpers.php');




// we check if we edit PLUGIN or THEME files
if(isset($_REQUEST['plugin'])) {

	$plug = new plugin($_REQUEST['plugin']);
	$infos = $plug->getPluginInfo();
	
	$excluded_files = $infos['restricted_edition']['files'];
	$excluded_folders = $infos['restricted_edition']['folders'];

	$root_folder = '../plugins/'.strip_tags($_REQUEST['plugin']).'/';
	$file = '__init__.php';
	$edit_link=$rub_link."&amp;todo=edit_files&amp;plugin=".strip_tags($_REQUEST['plugin'])."&amp;file=";

	$editor_title = _t('system','plugin_editor'). ' - '. strip_tags($_REQUEST['plugin']);

} else {
	$theme = loadThemeInfo('public', THEME_PUBLIC);	
	$excluded_files = $theme['restricted_edition']['files'];
	$excluded_folders = $theme['restricted_edition']['folders'];

	$root_folder = THEME_PUBLIC_PATH;
	$file = 'index.php';
	$edit_link=$rub_link."&amp;todo=edit_files&amp;file=";

	$editor_title = _t('system','theme_editor');
}

if (isset($_REQUEST['file']) && !empty($_REQUEST['file'])) {
	$file = strip_tags($_REQUEST['file']);
	$file_path = $root_folder . $file;
	
	// if file is contained in $excluded_files we kill the session
	if(in_array($file_path, $excluded_files)) ReloadIndex('admin');
	
} else {
	$file_path = $root_folder . $file; // file already known
}


$link_confirm = "confirm.php?rub=".$rub."&todo=".$todo.'&file='.$file;

if(isset($_REQUEST['plugin'])) {
	$link_confirm .= '&plugin='.strip_tags($_REQUEST['plugin']);
}

if(isset($_POST['save'])) {
	if (get_magic_quotes_gpc()) {
		$savecontent = stripslashes($_POST['file_content']);
	}
	else {
		$savecontent = $_POST['file_content'];
	}
	
    // we restore html content because it was transfered as htmlentities before
	$savecontent = html_entity_decode($savecontent, ENT_QUOTES, 'utf-8');
	
	if(!is_writable($file_path)) {
		$user_msg = array('class' => 'error', 'msg' => _t('system', 'not_writable'));
	} else {
		$r = file_put_contents($file_path, $savecontent, LOCK_EX);

		if(is_numeric($r)) header("Location: ".safe_redirect($link_confirm));
		else  system_error();
	}
}

// we get current file content for edit
$content = '';
if(file_exists($file_path) && is_readable($file_path)) {
	$content = file_get_contents($file_path);
} else {
	$user_msg = array('class' => 'error', 'msg' => _t('system', 'not_accessible'));
}
if(!is_writable($file_path)) {
	$user_msg = array('class' => 'error', 'msg' => _t('system', 'not_writable'));
}

// we get all editables files
$editables = GetAllFiles($root_folder,array('php', 'css', 'js', 'txt', 'xml'), true, $excluded_folders);
// and populate the container
$edit_files = '<ul>';
foreach ($editables as &$item) {
	$shortname = str_replace($root_folder, '', $item);
	$shortname = ltrim($shortname, '/');
	
	if($shortname == $file) {
		$class="active";
	} else {
		$class='';
	}
	$item = str_replace("//", "/", $item);
	if(!in_array($item, $excluded_files)) {
		$edit_files .= '<li><a href="'.$edit_link. $shortname.'" title="'. _t('system', 'edit_file').' : ' .$shortname.'" class="'.$class.'">'. $shortname. "</a></li>";
	}
}
$edit_files .= '</ul>';

?>

<div id="chemin">
	<ul>
		<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
		<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','system')?> </a></li>
		<li><span><?php echo $editor_title; ?> </span></li>
	</ul>
</div>

<!--end barre haute -->
<div class="contentcontainer">
	<?php include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));?>
	<div id="content">
		<h2>
			<?php echo mb_ucfirst($editor_title); ?>
		</h2>
		<h3>
			<?php echo _t('system','current_file'). ' : ' .$file; ?>
		</h3>
		<?php
		// we display user message if needed
		if(isset($user_msg)) {
			echo '<p class="'.$user_msg['class'].'">'.$user_msg['msg'].'</p>';
		}
		?>
		<div id="filelinks">
			<h3>
				<?php echo _t('system','files'); ?>
				:
			</h3>
			<?php echo $edit_files; ?>
		</div>
		<form id="edit_file" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"
			method="post">
			<textarea id="file_content" name="file_content" cols="90" rows="35"><?php echo htmlentities($content, ENT_QUOTES, 'utf-8')  ?></textarea>
			<div>
				<input name="file" type="hidden" value="<?php echo $file; ?>"	id="file" /> <input name="rub" type="hidden"
					value="<?php echo $rub; ?>" id="rub" /> <input name="todo"	type="hidden" value="<?php echo $todo; ?>" id="todo" />
				<?php if(isset($_REQUEST['plugin'])) {
					echo '<input name="plugin" type="hidden" value="'.strip_tags($_REQUEST['plugin']).'" />';
    } ?>
				<?php echo cancel_button('?rub=system&amp;todo=list'); ?>
				<input name="save" type="submit"
					value="<?php echo _t('btn','save') ?>" class="button" id="save" />
			</div>
		</form>
	</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
