<?php
/**
 * @package linea21\templates\admin
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>
<?php 
if(isset($debugbar)) {
	$debugbar['time']->startMeasure('header', '... loading Header files');
}
?>
<!doctype html>
<!--[if lte IE 7]> <html class="no-js ie67 ie678" lang="<?php echo U_L; ?>"> <![endif]-->
<!--[if IE 8]> <html class="no-js ie8 ie678" lang="<?php echo U_L; ?>"> <![endif]-->
<!--[if IE 9]> <html class="no-js ie9" lang="<?php echo U_L; ?>"> <![endif]-->
<!--[if gt IE 9]> <!--><html class="no-js" lang="<?php echo U_L; ?>"> <!--<![endif]-->
<head>
<meta charset="UTF-8">
		<!--[if IE]><meta http-equiv="X-UA-Compatible" content="IE=edge"><![endif]-->
		<title><?php echo _t('header','title');?></title>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<!--[if lt IE 9]>
		<script src="//html5shiv.googlecode.com/svn/trunk/html5.js"></script>
		<![endif]-->
		<link rel="shortcut icon" href="<?php echo THEME_ADMIN_PATH; ?>images/favicon.ico" />
		<link rel="stylesheet" href="<?php echo THEME_ADMIN_PATH; ?>css/knacss.css" media="all" />
		<link rel="stylesheet" href="<?php echo THEME_ADMIN_PATH; ?>css/admin_common.css" media="all" />
		<?php
		// must be included before calling admin_system.css to be able to style .codeMirror
		includeCodeEditor();
		
		if (basename($_SERVER['SCRIPT_NAME']) != 'search.php') {
		  if(file_exists(THEME_ADMIN_PATH. 'css/admin_' . $rub . '.css')) {
		  	echo '<style type="text/css" media="all">';
		    echo '@import url(' .THEME_ADMIN_PATH. 'css/admin_' . $rub . '.css);';
		    echo '</style>';
		  }
		} else {
			echo '<style type="text/css" media="all">';
			echo '@import url(' .THEME_ADMIN_PATH. 'css/admin_search.css);';
			echo '</style>';
		}
		?>
		<link type="text/css" rel="stylesheet" href="../lib/vendor/fontello/css/app.css" />
		<link type="text/css" rel="stylesheet" href="../lib/vendor/fontello/css/animation.css" />
		<!--[if IE 7]>
		<link rel="stylesheet" href="../lib/vendor/fontello/css/app-ie7.css">
		<![endif]-->
		<!--[if lte IE 7]>
		<link type="text/css" rel="stylesheet" href="<?php echo THEME_ADMIN_PATH; ?>css/admin_ie.css" />
		<![endif]-->
		<!--[if IE 8]>
		<style type="text/css" media="all">
		img {
		  	width: auto; /* for ie 8 because max-width does not work in ie8 */
		  }
		.dashboard-indicator-gauge {
			min-width:200px; /** fix bug on IE8 */
		}
		</style>
		<![endif]-->
		<script type="text/javascript">
		var SITE_ROOT_URL= "<?php echo SITE_ROOT_URL; ?>";
		var lang = "<?php echo U_L; ?>";
		</script>
		<script type="text/javascript" src="../lib/js/jquery-1.11.3.min.js"></script>
		<script type="text/javascript" src="../lib/js/jquery-browser.js"></script>
		<link rel="stylesheet" href="../lib/js/alertify.js/dist/css/alertify-bootstrap-min.css" />
		<script type="text/javascript" src="../lib/js/alertify.js/dist/js/alertify.js"></script>
		<script type="text/javascript" src="<?php echo THEME_ADMIN_PATH; ?>/js/main.js"></script>
		<?php IncludeColorboxJs(array("a[href$='.jpg'],a[href$='.jpeg'],a[href$='.png'],a[href$='.gif'], a[href$='.JPG'],a[href$='.JPEG'],a[href$='.PNG'],a[href$='.GIF']")); ?>
		<?php IncludeTooltipJs('abbr[title]'); ?>
		<?php AddDynamicHeader(); ?>
		<?php if(isset($debugbar)) echo $debugbarRenderer->renderHead(); ?>
		<link rel="stylesheet" href="../lib/vendor/font-awesome/css/font-awesome.min.css">
		<?php if(isset($_REQUEST['light-ui'])) echo '<link rel="stylesheet" href="'. THEME_ADMIN_PATH . 'css/light-ui.css" media="all" />'; ?>
</head>
<body>

<?php

include_once("header.php");
if(isset($debugbar)) {
  $debugbar['time']->stopMeasure('header');
  $debugbar['time']->startMeasure('modules', '... loading modules files');
}
culture::getInstance()->renderSwitcher();

// echo '<div id="wrap">';
include_once(override($dir."/index.php", THEME_ADMIN_PATH));
if(isset($debugbar)) {
  $debugbar['time']->stopMeasure('modules');
  $debugbar['time']->startMeasure('footer', '... loading footer and quickbox files');
}


include_once(override($dir."/help.php", THEME_ADMIN_PATH));
// echo '</div><!-- closing #wrap -->';
include_once(override($dir."/quickbox.php", THEME_ADMIN_PATH));
include_once("footer.php");

if(isset($debugbar)) {
  $debugbar['time']->stopMeasure('footer');
}
?>
<script type="text/javascript">
	$(document).ready(function(){
		$("#menu_library").colorbox({iframe:true, innerWidth:"80%", innerHeight:"80%", href: "../library/access.php?langCode=<?php echo U_L; ?>"});
	});
 </script>
<?php if(isset($debugbar)) echo $debugbarRenderer->render(); ?>
</body>
</html>