<?php
/**
 * Default publication template
 * 
 * This file can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>

<?php
//////////////////////////////////////////
/////affichage partie dossier
//////////////////////////////////////////

if(ActiveItemKey($GLOBALS['activeitem']) == 'publication' || ActiveItemKey($GLOBALS['activeitem']) == 'publication-archives') {

	$link_publi = array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue']);
	$link_archive= array('rub'=> $GLOBALS['links'][U_L]['publication-archives']['linkvalue']);
	
  SetHTMLTitle(_t('publication','section')); // set HTML title
  setBreadcrumb(array(ucfirst(formatText(_t('publication', 'section'), '2HTML')) => HrefMaker($link_publi)));


  if(ActiveItemKey($GLOBALS['activeitem']) == 'publication') {
    $GLOBALS['filters'][U_L]['level']['active'] = 0; // filter activation
    $GLOBALS['filters'][U_L]['scale']['active'] = 0; // filter activation
  }
  include_once(override('../publication/display.php'));
  /** préparation des variables
   * 	$statut
   * 	$debut default 0
   * 	$id -> default -1
   * 	$filter default -1
   **/
  if(ActiveItemKey($GLOBALS['activeitem'])=='publication') $statut='public';
  if(ActiveItemKey($GLOBALS['activeitem'])=='publication-archives') $statut='archives_p';
  if(isset($_REQUEST['id'])) $id=$_REQUEST['id']; else $id=-1;
  if(isset($_REQUEST['debut'])) $debut=$_REQUEST['debut']; else $debut=0;
  if(isset($_REQUEST['filter'])) {
    if($_REQUEST['filter']==$GLOBALS['filters'][U_L]['scale']['linkvalue']) $filter='SCALE';
    if($_REQUEST['filter']==$GLOBALS['filters'][U_L]['level']['linkvalue']) $filter='LEVEL';
    if($_REQUEST['filter']==$GLOBALS['filters'][U_L]['tag']['linkvalue']) $filter='TAG';
  } else $filter=-1;


  /** Affichage du lien de consultation d'archives ( si nécessaire
   */
  if(ActiveItemKey($GLOBALS['activeitem']) != 'publication-archives')  {

      if(isset($_REQUEST['filter']) && $_REQUEST['filter'] == $GLOBALS['filters'][U_L]['tag']['linkvalue'] ) {
          // getting tags
          include_once('../class/class.tag.php');
          $otag = new tag;
          $current_tag = $otag->getTagById($_REQUEST['id']);
          
          if($current_tag) echo '<h2 class="tag-filtered">'.sprintf(_t('selected', 'by_tag'), '<span>'.$current_tag['name'].'</span>').'</h2>';
      }
      
    echo '<div class="primary-nav-container"><div class="switchnav">';
    if(isset($_REQUEST['filter'])) echo '<a class="button" href="'.HrefMaker($link_publi).'" title="'._t('divers','goto_currentlist').'">'._t('divers','goto_currentlist').'</a>'.PHP_EOL;
    echo '<a class="button" href="'.HrefMaker($link_archive).'" title="'._t('divers','goto_archives').'">'._t('divers','goto_archives').'</a>'.PHP_EOL;
    echo '</div></div>';
  }

  /** Affichage du lien de consultation de la liste courante ( si nécessaire
   */
  if(ActiveItemKey($GLOBALS['activeitem']) == 'publication-archives')  {
  	
  	SetHTMLTitle(_t('archives','name')); // set HTML title
  	setBreadcrumb(array(ucfirst(formatText(_t('archives', 'name'), '2HTML')) => HrefMaker($link_archive)));

    
    echo '<div class="primary-nav-container"><div class="switchnav">';
    echo '<a class="button" href="'.HrefMaker($link_publi).'" title="'._t('divers','goto_currentlist').'">'._t('divers','goto_currentlist').'</a>'.PHP_EOL;
    echo '</div></div>';
  }

  /** Affichage du Listing Des Dossiers et Dossiers archivés
   */
  if((isset($_REQUEST['id']) && isset($_REQUEST['filter'])) || (!isset($_REQUEST['id']) && !isset($_REQUEST['filter'])))
  {
  	if(is_numeric(strpos(ActiveItemKey($GLOBALS['activeitem']), 'archives'))) {
  		$title = _t('publication','listing') . ' - ' ._t('archives', 'name');
  	} else {
  		$title = _t('publication','listing');
  	}
  	
  	$content= '<h1>'.$title.'</h1>'.PHP_EOL;
  	$content.='<div class="sub-title">';
  	$content.=_t('publication','h1_public_comment');
  	$content.='</div>';

  	echo $content;

    DisplayListPublication($statut, $filter, $id, $debut);
  }


  /** Détail d'un dossier
   */
  if(isset($_REQUEST['id']) && !isset($_REQUEST['filter'])) {
    // set HTML Title
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getPublicationTitle($id));
    SetHTMLTitle(formatText($result[0]['publi_title'], '2HTML'));
    setBreadcrumb(array(ucfirst(formatText(_t('publication', 'section'), '2HTML')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue'])), formatText($result[0]['publi_title'], '2HTML') => false));

    $publi_statut=DisplayOnePublication($id);
    DisplayPublicationParts($id);
    echo '<div id="ressources">'.PHP_EOL;
    DisplayPublicationLinks($id);
    DisplayPublicationMulti($id);
    DisplayPublicationBiblio($id);
    echo '</div>'.PHP_EOL;
    if(commentEnabled('publication')) {
      echo '<h3>'._t('comment', 'section').'</h3>'.PHP_EOL;
      echo '<div id="comments">'.PHP_EOL;
      displayComments(array('module'=> 'publication', 'module_id'=> $id, 'order_by' => 'ASC'), false, true);
      if($publi_statut == 'P') displayCommentForm(array('module'=> 'publication', 'module_id'=> $id));
      echo '</div>'.PHP_EOL;
    }
  }
}

//////////////////////////////////////////
/////affichage rapport de groupe de travail
//////////////////////////////////////////

if(ActiveItemKey($GLOBALS['activeitem']) == 'report') {
  include_once(override('../workshoprep/display.php'));

  SetHTMLTitle(_t('workshoprep','section')); // set HTML title
  setBreadcrumb(array(ucfirst(formatText(_t('workshop', 'name'), '2HTML')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue']))));
  /** préparation des variables
   * 	$id -> default -1
   **/
  if(isset($_REQUEST['id'])) $id=$_REQUEST['id']; else $id=-1;

  /** Détail d'un rapport
   */
  if(isset($_REQUEST['id'])) {
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getoneCompleteWorkshopRep($id));
    $status = $result[0]['workrep_statut'];
    SetHTMLTitle(formatText($result[0]['workrep_title']. ' ('.$result[0]['workshop_denomination'].')', '2HTML'));
    setBreadcrumb(array(formatText($result[0]['workshop_denomination'], '2HTML') => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'], 'id' => $result[0]['workrep_workshop_id'], 'name' => formatText($result[0]['workshop_denomination'], '2HTML')))));

    DisplayOneWorkshopRep($id);
    DisplayWorkshopRepParts($id);
    echo '<div id="ressources">'.PHP_EOL;
    DisplayWorkshopRepLinks($id);
    DisplayWorkshopRepBiblio($id);
    echo '</div>'.PHP_EOL;
    if(commentEnabled('report')) {
      echo '<h3>'._t('comment', 'section').'</h3>'.PHP_EOL;
      echo '<div id="comments">'.PHP_EOL;
      displayComments(array('module'=> 'report', 'module_id'=> $id, 'order_by' => 'ASC'), false, true);
      if($status == 'P') displayCommentForm(array('module'=> 'report', 'module_id'=> $id));
      echo '</div>'.PHP_EOL;
    }
  }

}


//////////////////////////////////////////
/////	affichage Parties par parties
/////	Rapports de groupe de travail et Dossiers
//////////////////////////////////////////

if(ActiveItemKey($GLOBALS['activeitem']) =='report-part' || ActiveItemKey($GLOBALS['activeitem']) == 'publication-part') {
  include_once(override('../contents/display.php'));

  /** préparation des variables
   * 	$id -> default -1
   *   $parentid -> default -1
   **/

  if(isset($_REQUEST['id'])) $id=$_REQUEST['id']; else $id=-1;
  if(isset($_REQUEST['parentid'])) $parentid=$_REQUEST['parentid']; else $parentid=-1;

  /** Détail d'une partie
   */
  if(ActiveItemKey($GLOBALS['activeitem']) =='report-part')
  {
    include_once(override('../workshoprep/display.php'));

    SetHTMLTitle(_t('workshoprep','section')); // set HTML title
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getoneCompleteWorkshopRep($parentid));
    $status = $result[0]['workrep_statut'];
    SetHTMLTitle(formatText($result[0]['workrep_title']. ' ('.$result[0]['workshop_denomination'].')', '2HTML'));
    setBreadcrumb(array(ucfirst(formatText(_t('workshop', 'name'), '2HTML')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue']))));
    setBreadcrumb(array(formatText($result[0]['workshop_denomination'], '2HTML') => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'], 'id' => $result[0]['workrep_workshop_id'], 'name' => formatText($result[0]['workshop_denomination'], '2HTML')))));
    setBreadcrumb(array(formatText($result[0]['workrep_title'], '2HTML') => false));

    $result=$GLOBALS['sql_object']->DBSelect(SQL_getOneWorkshopParts($id));

    SetHTMLTitle(formatText($result[0]['workrepcon_title'], '2HTML'));

    DisplayWorkshopNameAndGroup($parentid);

    if(commentEnabled('report')) {
      postCommentAction(array('module'=> 'report', 'module_id'=> $parentid));
      echo '<div id="anchor-comments">'.PHP_EOL;
      echo getCommentsAnchor(array('module'=> 'report', 'module_id'=> $parentid));
      if($status == 'P') echo getPostCommentAnchor();
      echo '</div>'.PHP_EOL;
    }
    DisplayOneWorkshopPart($id);
    echo '<hr />'.PHP_EOL;
    echo '<div class="nextprev">'.PHP_EOL;
    DisplayLinkParts($id, $parentid, 'PREVIOUS', 'W');
    DisplayLinkParts($id, $parentid, 'NEXT', 'W');
    echo '</div>'.PHP_EOL;
    
    DisplayWorkshopRepLinkinPart($id, $parentid, 'TEXT');
    
    echo '<div id="ressources">'.PHP_EOL;
    DisplayWorkshopRepLinks($parentid);
    DisplayWorkshopRepBiblio($parentid);
    echo '</div>'.PHP_EOL;
    if(commentEnabled('report')) {
      echo '<h3>'._t('comment', 'section').'</h3>'.PHP_EOL;
      echo '<div id="comments">'.PHP_EOL;
      displayComments(array('module'=> 'report', 'module_id'=> $parentid, 'order_by' => 'ASC'), false, true);
      if($status == 'P') displayCommentForm(array('module'=> 'report', 'module_id'=> $parentid));
      echo '</div>'.PHP_EOL;
    }
  }
  if(ActiveItemKey($GLOBALS['activeitem']) == 'publication-part')
  {
    include_once(override('../publication/display.php'));

    SetHTMLTitle(_t('publication','section')); // set HTML title
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getPublicationTitle($parentid));
    $status = $result[0]['publi_statut'];
    SetHTMLTitle(formatText($result[0]['publi_title'], '2HTML'));
    setBreadcrumb(array(ucfirst(formatText(_t('publication', 'section'), '2HTML')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue'])), formatText($result[0]['publi_title'], '2HTML') => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue'], 'id' => $parentid, 'name' => formatText($result[0]['publi_title'], '2HTML')))));
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getOnePublicationParts($id));
    SetHTMLTitle(formatText($result[0]['publicon_title'], '2HTML'));

    
    if(commentEnabled('publication')) {
      postCommentAction(array('module'=> 'publication', 'module_id'=> $parentid));
      echo '<div id="anchor-comments">'.PHP_EOL;
      echo getCommentsAnchor(array('module'=> 'publication', 'module_id'=> $parentid));
      if($status == 'P') echo getPostCommentAnchor();
      echo '</div>'.PHP_EOL;
    }
    
    DisplayPublicationTitle($parentid);
    DisplayOnePublicationPart($id);
    echo '<div class="nextprev">'.PHP_EOL;
    DisplayLinkParts($id, $parentid, 'PREVIOUS', 'P');
    DisplayLinkParts($id, $parentid, 'NEXT', 'P');
    echo '</div>'.PHP_EOL;
    DisplayPublicationLinkinPart($id, $parentid, 'TEXT');
    echo '<div id="ressources">'.PHP_EOL;
    DisplayPublicationLinks($parentid);
    DisplayPublicationMulti($parentid);
    DisplayPublicationBiblio($parentid);
    echo '</div>'.PHP_EOL;
    if(commentEnabled('publication')) {
      echo '<h3>'._t('comment', 'section').'</h3>'.PHP_EOL;
      echo '<div id="comments">'.PHP_EOL;
      displayComments(array('module'=> 'publication', 'module_id'=> $parentid, 'order_by' => 'ASC'), false, true);
      if($status == 'P') displayCommentForm(array('module'=> 'publication', 'module_id'=> $parentid));
      echo '</div>'.PHP_EOL;
    }
  }


}


//////////////////////////////////////////
/////affichage partie news
//////////////////////////////////////////

if(ActiveItemAlias($GLOBALS['activeitem'])=='news') {

	$link_archive= array('rub'=> $GLOBALS['links'][U_L]['news-archives']['linkvalue']);
	$link_news= array('rub'=> $GLOBALS['links'][U_L]['news']['linkvalue']);
	
  SetHTMLTitle(_t('news','section')); // set HTML title
  setBreadcrumb(array(ucfirst(formatText(_t('news', 'section'), '2HTML')) => HrefMaker($link_news)));

  if(ActiveItemKey($GLOBALS['activeitem'])=='news') {
    $GLOBALS['filters'][U_L]['level']['active'] = 0; // filter activation
    $GLOBALS['filters'][U_L]['scale']['active'] = 0; // filter activation
  }
  include_once(override('../news/display.php'));
  /** préparation des variables
   * 	$statut
   * 	$debut default 0
   * 	$id -> default -1
   * 	$filter default -1
   **/
  if(ActiveItemKey($GLOBALS['activeitem'])=='news') $statut='public';
  if(ActiveItemKey($GLOBALS['activeitem'])=='news-archives') $statut='archives_p';
  if(isset($_REQUEST['id'])) $id=$_REQUEST['id']; else $id=-1;
  if(isset($_REQUEST['debut'])) $debut=$_REQUEST['debut']; else $debut=0;
  if(isset($_REQUEST['filter'])) {
    if($_REQUEST['filter']==$GLOBALS['filters'][U_L]['scale']['linkvalue']) $filter='SCALE';
    if($_REQUEST['filter']==$GLOBALS['filters'][U_L]['level']['linkvalue']) $filter='LEVEL';
    if($_REQUEST['filter']==$GLOBALS['filters'][U_L]['tag']['linkvalue']) $filter='TAG';
  } else $filter=-1;

  /** Affichage du lien de consultation d'archives ( si nécessaire
   */

  if(ActiveItemKey($GLOBALS['activeitem']) != 'news-archives')  {

      if(isset($_REQUEST['filter']) && $_REQUEST['filter'] == $GLOBALS['filters'][U_L]['tag']['linkvalue'] ) {
        // getting tags
        include_once('../class/class.tag.php');
        $otag = new tag;
        $current_tag = $otag->getTagById($_REQUEST['id']);
          
        if($current_tag) echo '<h2 class="tag-filtered">'.sprintf(_t('selected', 'by_tag'), '<span>'.$current_tag['name'].'</span>').'</h2>';
    }

    echo '<div class="primary-nav-container"><div class="switchnav">';
    if(isset($_REQUEST['id']) && isset($_REQUEST['filter'])) {
    	echo '<a class="button" href="'.HrefMaker($link_news).'" title="'._t('divers','goto_currentlist').'">'._t('divers','goto_currentlist').'</a>'.PHP_EOL;
    }
    echo '<a class="button" href="'.HrefMaker($link_archive).'" title="'._t('divers','goto_archives').'">'._t('divers','goto_archives').'</a>'.PHP_EOL;
    echo '</div></div>';

  }


  /** Affichage du lien de consultation liste principale ( si nécessaire
   */
  if(ActiveItemKey($GLOBALS['activeitem']) == 'news-archives')  {
    
    SetHTMLTitle(_t('archives','name')); // set HTML title
    setBreadcrumb(array(ucfirst(formatText(_t('archives', 'name'), '2HTML')) => HrefMaker($link_archive)));

    echo '<div class="primary-nav-container"><div class="switchnav">';
    echo '<a class="button" href="'.HrefMaker($link_news).'" title="'._t('divers','goto_currentlist').'">'._t('divers','goto_currentlist').'</a>'.PHP_EOL;
    echo '</div></div>';

  }

  /** Affichage du Listing Actualité + Archives
   */

  if((isset($_REQUEST['id']) && isset($_REQUEST['filter'])) || (!isset($_REQUEST['id']) && !isset($_REQUEST['filter'])))
  {
    DisplayListNews($statut, $filter, $id, $debut);
  }


  /** Détail d'une actualité
   */
  if(isset($_REQUEST['id']) && !isset($_REQUEST['filter'])) {

    // set HTML Title
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getoneCompleteNews($id));
    $news_status = $result[0]['news_statut'];
    if($news_status != 'P') {
   		SetHTMLTitle(_t('archives','name')); // set HTML title
    	setBreadcrumb(array(ucfirst(formatText(_t('archives', 'name'), '2HTML')) => HrefMaker($link_archive)));
    }
    
    SetHTMLTitle(formatText($result[0]['news_title'], '2HTML'));
    setBreadcrumb(array(ucfirst(formatText(_t('news', 'section'), '2HTML')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['news']['linkvalue'])), formatText($result[0]['news_title'], '2HTML') => false));
    
    
    $news_statut=DisplayOneNews($id);
    echo '<hr />'.PHP_EOL;
    echo '<div class="nextprev">'.PHP_EOL;
    DisplayLinkNewsCircles($id, 'PREVIOUS', $news_statut);
    DisplayLinkNewsCircles($id, 'NEXT', $news_statut);
    echo '</div>'.PHP_EOL;
    if(commentEnabled('news')) {
      echo '<h3>'._t('comment', 'section').'</h3>'.PHP_EOL;
      echo '<div id="comments">'.PHP_EOL;
      displayComments(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $id, 'order_by' => 'ASC'), false, true);
      if($news_statut == 'public') displayCommentForm(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $id));
      echo '</div>'.PHP_EOL;
    }
  }


}

//////////////////////////////////////////
/////affichage partie projet
//////////////////////////////////////////

if(ActiveItemAlias($GLOBALS['activeitem'])=='project') {
	
	$link_archive= array('rub'=> $GLOBALS['links'][U_L]['project-archives']['linkvalue']);
	$link_project= array('rub'=> $GLOBALS['links'][U_L]['project']['linkvalue']);

  include_once(override('../project/display.php'));
  SetHTMLTitle(_t('project','section')); // set HTML title
  setBreadcrumb(array(ucfirst(formatText(_t('project', 'section'), '2HTML')) => HrefMaker($link_project)));


  $GLOBALS['filters'][U_L]['priority']['active'] = 0; // filter activation
  /** préparation des variables
  * 	$statut
  * 	$debut default 0
  * 	$id -> default -1
  * 	$filter default -1
  **/
  if(ActiveItemKey($GLOBALS['activeitem'])=='project') $statut='public';
  if(ActiveItemKey($GLOBALS['activeitem'])=='project-archives') $statut='archives_p';
  if(isset($_REQUEST['id'])) $id=$_REQUEST['id']; else $id=-1;
  if(isset($_REQUEST['debut'])) $debut=$_REQUEST['debut']; else $debut=0;
  if(isset($_REQUEST['filter'])) {
    if($_REQUEST['filter']==$GLOBALS['filters'][U_L]['scale']['linkvalue']) $filter='SCALE';
    if($_REQUEST['filter']==$GLOBALS['filters'][U_L]['priority']['linkvalue']) $filter='PRIORITY';
    if($_REQUEST['filter']==$GLOBALS['filters'][U_L]['level']['linkvalue']) $filter='LEVEL';
    if($_REQUEST['filter']==$GLOBALS['filters'][U_L]['tag']['linkvalue']) $filter='TAG';

  } else $filter=-1;

  /** Affichage du lien de consultation d'archives ( si nécessaire
   */

  if(ActiveItemKey($GLOBALS['activeitem']) != 'project-archives')  {

      if(isset($_REQUEST['filter']) && $_REQUEST['filter'] == $GLOBALS['filters'][U_L]['tag']['linkvalue'] ) {
        // getting tags
        include_once('../class/class.tag.php');
        $otag = new tag;
        $current_tag = $otag->getTagById($_REQUEST['id']);  
          
        if($current_tag) echo '<h2 class="tag-filtered">'.sprintf(_t('selected', 'by_tag'), '<span>'.$current_tag['name'].'</span>').'</h2>';
    }
      
  	echo '<div class="primary-nav-container"><div class="switchnav">';
  	if(isset($_REQUEST['id']) && isset($_REQUEST['filter'])) {
  		echo '<a class="button" href="'.HrefMaker($link_project).'" title="'._t('divers','goto_currentlist').'">'._t('divers','goto_currentlist').'</a>'.PHP_EOL;
  	}
  	echo '<a class="button" href="'.HrefMaker($link_archive).'" title="'._t('divers','goto_archives').'">'._t('divers','goto_archives').'</a>'.PHP_EOL;
  	echo '</div></div>';

  }

  /** Affichage du lien de consultation liste principale ( si nécessaire
   */
  if(ActiveItemKey($GLOBALS['activeitem']) == 'project-archives')  {
  	
  	SetHTMLTitle(_t('archives','name')); // set HTML title
  	setBreadcrumb(array(ucfirst(formatText(_t('archives', 'name'), '2HTML')) => HrefMaker($link_archive)));

  	echo '<div class="primary-nav-container"><div class="switchnav">';

  	echo '<a class="button" href="'.HrefMaker($link_project).'" title="'._t('divers','goto_currentlist').'">'._t('divers','goto_currentlist').'</a>'.PHP_EOL;
  	echo '</div></div>';

  }


  /** Affichage du lien de consultation liste principale ( si nécessaire
   */
  //	if(ActiveItemKey($GLOBALS['activeitem']) == 'project-archives')  {
  //
  //		$link_archive= array('rub'=> $GLOBALS['links'][U_L]['project']['linkvalue']);
  //
  //		echo '<div class="primary-nav-container"><div class="switchnav">';
  //		echo '<a class="button" href="'.HrefMaker($link_archive).'" title="'._t('divers','goto_currentlist').'">'._t('divers','goto_currentlist').'</a>'.PHP_EOL;
  //		echo '</div></div>';
  //
  //	}

  /** Affichage du Listing Projets + Archives
   */

  if((isset($_REQUEST['id']) && isset($_REQUEST['filter'])) || (!isset($_REQUEST['id']) && !isset($_REQUEST['filter'])))
  {
  	
  	if(is_numeric(strpos(ActiveItemKey($GLOBALS['activeitem']), 'archives'))) {
  		$title = mb_ucfirst(_t('project','section') . ' - ' ._t('archives', 'name'));
  	} else {
  		$title = mb_ucfirst(_t('project','section'));
  	}
  	echo '<h1>' . $title . '</h1>' . PHP_EOL;
		
    //DisplayListProject($statut, $filter, $id, $debut);
		// DisplayListProjectByLevels($statut, $filter, $id);
  	DisplayListProjectByLevelsWithProgression($statut, $filter, $id);
  }


  /** Détail d'un projet
   */
  if(isset($_REQUEST['id']) && !isset($_REQUEST['filter'])) {

    // set HTML Title
    $result=$GLOBALS['sql_object']->DBSelect(SQL_getProjectName($id));
    SetHTMLTitle(formatText($result[0]['project_name'], '2HTML'));
    setBreadcrumb(array(ucfirst(formatText(_t('project', 'section'), '2HTML')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['project']['linkvalue'])), formatText($result[0]['project_name'], '2HTML') => false));

    $project_status=DisplayOneProject($id);
    if(commentEnabled('project')) {
      echo '<h3>'._t('comment', 'section').'</h3>'.PHP_EOL;
      echo '<div id="comments">'.PHP_EOL;
      displayComments(array('module'=> 'project', 'module_id'=> $id, 'order_by' => 'ASC'), false, true);
      if($project_status == 'public') displayCommentForm(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $id));
      echo '</div>'.PHP_EOL;
    }
  }

}
?>