<?php
/**
 * User module - delete avatar
 * 
 * Delete user avatar. Called from both front & back offices
 * 
 * @package linea21\modules
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once('../config/define.php');
include_once('../admin/'.SQL.'.inc.php');

// admin interface
if(isset($_GET['id'])) {
	$from='admin';
	$id=$_GET['id']; // we retrieve given id
// public interface
} else {
	// we get current user id from DB
	$from='public';
	$data = $GLOBALS['sql_object']->DBSelect(SQL_Get_UserInfo4Auth($_SESSION['userlogin'], base64_decode($_SESSION['userwhois'])));
	if ($data != 0 && count($data) == 1) {
		$id=$data[0]['user_id'];
	} else {
		die();
	}
}

if(!isset($_GET['mode'])) {
	$mode='plain';
} else {
	$mode='ajax';
}

//////////// Check Droits utilisateur ////////////
if($from == 'admin') {
	if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
}
////////////



include_once('../languages/' . U_L . '/lang_user.' . CHARSET . '.php');
// include_once('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');
include_once('../class/class.user.php');


$user = new user;
$r = $user->deleteAvatar($id, $GLOBALS['sql_object']);

if($mode == 'plain') {
	if($from == 'admin') {
		$link_confirm = SITE_ROOT_URL."admin/confirm.php?rub=user&todo=delavatar&id=".$id;
		if($r) header("Location: ".safe_redirect($link_confirm));
	} else {
		if(!$r) system_error(__FUNCTION__ . ' : SQL error when deleting avatar for user ' . $id);
	}
	// ajax mode
} else {
	if($r) {
		$status = 1;
		$o = _t('user', 'confirm_delavatar');
	}
	/* Return json values */
	echo json_encode(array('status'=> $status,'msg'=> $o));
}
?>