<?php
/**
 * User module
 * 
 * User detail page
 * 
 * @package linea21\core\user
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////
$user_object= new user;
if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

$req_det= SQL_getAllUserInfo($id);
$result=$sql_object->DBSelect($req_det);

// Do record exists?
if(!isset($result[0]['user_login'])) redirect_to('@module_default');

// groupes de travail
$r=$user_object->GetUserWorkshops($id, 'both', $sql_object);
$default_wg= array();
$wg_rights = array();
if(isset($r[0]['jwu_workshop_id'])) {
    foreach($r as $value) {
      array_push($default_wg, $value['jwu_workshop_id']);
      $wg_rights[$value['jwu_workshop_id']] = $value['jwu_user_right'];
    }
}
$wg_display = '';
if(!empty($default_wg)) {
  $q=SQL_Get_WorkshopsDenomination($default_wg);
  $workgroups=$sql_object->DBSelect($q);
  foreach($workgroups as $wg) {
  	if($wg['workshop_statut'] == 'PA' || $wg['workshop_statut'] == 'AA') $archived = ' (' . _t('archives', 'singular') . ')';
  	else $archived = '';
  	if($wg_rights[$wg['workshop_id']] == 'O') $mask = ' <span class="small">['.formatText(_t('workshop', 'organizer2'), '2HTML').']</span>';
  	else  $mask = '';
  	
    $wg_display .= '- '.$wg['workshop_denomination']. $archived .  $mask .'<br />'.PHP_EOL;
  }
} else $wg_display .= _t('divers', 'none');

$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";


// formattage des données
$current_title=formatText($result[0]['user_login'], '2HTML');
$user_login=formatText($result[0]['user_login'], '2HTML');
$user_previous_login = '';
if(!empty($result[0]['user_old_logins'])) {
	$user_previous_login .= formatText(str_replace(',', ', ', ltrim($result[0]['user_old_logins'], ',')), '2HTML');
}
$user_email=$result[0]['profile_email'];
$user_email=formatText('<a href="mailto:'.$user_email.'">'.$user_email.'</a>', '2HTML');
$user_groupe=formatText($result[0]['catus_name'], '2HTML');
// droits utilisateur
$rights_dashboard=$result[0]['rights_dashboard'];
$rights_project=$result[0]['rights_project'];
$rights_publication=$result[0]['rights_publication'];
$rights_news=$result[0]['rights_news'];
$rights_workshop=$result[0]['rights_workshop'];

$user_public_email=$result[0]['profile_email_display'];
if($user_public_email=='Y') $user_public_email=_t('divers','yes');
else $user_public_email=_t('divers','no');
$user_profile_firstname=formatText(empty_nc($result[0]['profile_firstname']), '2HTML');
$user_profile_lastname=formatText(empty_nc($result[0]['profile_lastname']), '2HTML');
$user_profile_city=formatText(empty_nc($result[0]['profile_city']), '2HTML');
$user_profile_birthdate=formatText(empty_nc($result[0]['profile_birthdate']), '2HTML');
$user_profile_leisures=formatText(empty_nc($result[0]['profile_leisures']), '2HTML');
$user_profile_job=formatText(empty_nc($result[0]['profile_job']), '2HTML');
$user_profile_quotation=formatText(empty_nc($result[0]['profile_quotation']), '2HTML');
$user_profile_signature=formatText(empty_nc($result[0]['profile_signature']), '2HTML');

if(!empty($result[0]['profile_avatar'])) {
  $complete_uri='../'.$result[0]['profile_avatar'];
  $user_profile_avatar='<img src="'.$complete_uri.'" alt="'._t('user','avatar').' '.$user_login.'" />';
} else $user_profile_avatar=_t('divers','none');

$profile_last_modify_display=$result[0]['profile_last_modify_display'];
$profile_date_crea_display=$result[0]['profile_date_crea_display'];
$user_last_con_display=empty_nc($result[0]['user_last_con_display']);

$user_validity=display_statut(_t('statut','draft'));

$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";

//prepa affichage de droits
$reca_droits='';
$reca_droits.='<h3 class="part">'.mb_ucfirst(_t('user','rights')).'</h3>';
$reca_droits.="<dl class=\"summary\">\n";
$reca_droits.="<dt>".mb_ucfirst(_t('user','groupe'))." :</dt>\n";
$reca_droits.="<dd>".$user_groupe."</dd>\n";
if(defined('MOD_SDI'))  {
  $reca_droits.="<dt> . "._t('menu','dashboard')."</dt>\n";
  $reca_droits.="<dd>".GetDisplayUserRight($rights_dashboard, 'dashboard')."<br /></dd>\n";
}
if(defined('MOD_PROJECT'))  {
	$reca_droits.="<dt> . "._t('menu','project')."</dt>\n";
	$reca_droits.="<dd>".GetDisplayUserRight($rights_project, 'project')."<br /></dd>\n";
}
if(defined('MOD_PUBLICATION'))  {
  $reca_droits.="<dt>  . "._t('menu','publication')."</dt>\n";
  $reca_droits.="<dd>".GetDisplayUserRight($rights_publication)."<br /></dd>\n";
}
if(defined('MOD_WORKSHOP'))  {
  $reca_droits.="<dt>  . "._t('menu','workshop')."</dt>\n";
  $reca_droits.="<dd>".GetDisplayUserRight($rights_workshop, 'workshop')."<br /></dd>\n";
}
if(defined('MOD_NEWS'))  {
  $reca_droits.="<dt>  . "._t('menu','news')."</dt>\n";
  $reca_droits.="<dd>".GetDisplayUserRight($rights_news)."<br /></dd>\n";
}
$reca_droits.="</dl>\n";
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','user');?></a></li>
	<li><span><?php echo formatnavTitle(_t('user','det'). " : " .$current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php

if($result[0]['user_password'] == '@ldap_forward') {
	$suffix= '<i class="icon-universal-access"></i>';
} else {
	$suffix= ' ';
}

echo "<h2>".formatTitleh2($current_title).$suffix."</h2>\n";
echo "\t<a href=\"".$link_sup.$id."\" title=\""._t('user','sup')."\" class=\"ico_sup2\"><i class=\"icon-trash\"></i><span>" . _t('user','sup') . "</span></a>\n";
echo "\t<a href=\"".$link_mod.$id."\" title=\""._t('user','mod')."\" class=\"ico_mod2\"><i class=\"icon-pencil\"></i><span>" . _t('user','mod') . "</span></a>\n";
echo $reca_droits;
echo '<h3 class="part">'._t('user','profile').'</h3>';
echo "<dl class=\"summary\">\n";
echo "<dt>". mb_ucfirst(_t('user','login')). " :</dt>\n";
echo "<dd>".$user_login."</dd>\n";
if(!empty($user_previous_login)) {
	echo "<dt>". mb_ucfirst(_t('user','previous_logins')). " :</dt>\n";
	echo "<dd>".$user_previous_login."</dd>\n";
}
echo "<dt>". mb_ucfirst(_t('user','first_name')). " :</dt>\n";
echo "<dd>".$user_profile_firstname."</dd>\n";
echo "<dt>".mb_ucfirst(_t('user','last_name')). " :</dt>\n";
echo "<dd>".$user_profile_lastname."</dd>\n";
echo "<dt>".mb_ucfirst(_t('user','email')). " :</dt>\n";
echo "<dd>".$user_email."</dd>\n";
echo "<dt>".mb_ucfirst(_t('user','email_display'))." :</dt>\n";
echo "<dd>". $user_public_email."</dd>\n";
echo "<dt>".mb_ucfirst(_t('user','workgroups'))." :</dt>\n";
echo "<dd>". stripslashes($wg_display)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('user','birthdate'))." :</dt>\n";
echo "<dd>". $user_profile_birthdate."</dd>\n";
echo "<dt>".mb_ucfirst(_t('user','city'))." :</dt>\n";
echo "<dd>". $user_profile_city."</dd>\n";
echo "<dt>".mb_ucfirst(_t('user','leisures'))." :</dt>\n";
echo "<dd>". $user_profile_leisures."</dd>\n";
echo "<dt>".mb_ucfirst(_t('user','job'))." :</dt>\n";
echo "<dd>". $user_profile_job."</dd>\n";
echo "<dt>".mb_ucfirst(_t('user','avatar'))." :</dt>\n";
echo "<dd>". $user_profile_avatar."</dd>\n";
echo "<dt>".mb_ucfirst(_t('user','quotation'))." :</dt>\n";
echo "<dd>". $user_profile_quotation."</dd>\n";
echo "<dt>".mb_ucfirst(_t('user','signature'))." :</dt>\n";
echo "<dd>". $user_profile_signature."</dd>\n";
echo "<dt>".mb_ucfirst(_t('user','latest_con'))." :</dt>\n";
echo "<dd>". $user_last_con_display."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','last_modify'))." :</dt>\n";
echo "<dd>". $profile_last_modify_display."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','date_crea'))." :</dt>\n";
echo "<dd>". $profile_date_crea_display."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','statut')) ." :</dt>\n";
echo "<dd>". $user_validity. "</dd>\n";
echo "</dl>\n";
?>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->