<?php
/**
 * Workshop module
 * 
 * Set-up module related menu in back-office
 * 
 * @package linea21\modules\workshop
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('workshop') && !$l21auth->isSuperAdmin())
	ReloadIndex('admin');
////////////

$rub_link_add=$rub_link."&amp;todo=add";
$rub_link_list=$rub_link."&amp;todo=list";
$rub_link_mod=$rub_link."&amp;todo=mod";
$rub_link_det=$rub_link."&amp;todo=det";
$rub_link_det=$rub_link."&amp;todo=sup";
$search="search.php?rub=".$rub;
if($todo=='add') $title=_t('workshop','add');
if($todo=='list') $title=_t('workshop','list');
if($todo=='mod') $title=_t('workshop','mod');
if($todo=='sup') $title=_t('workshop','sup');
if($todo=='det') $title=_t('workshop','det');
if($todo=='sup_u') $title=_t('workshop','del_user');
if($todo=='add_u') $title=_t('workshop','add_new_user');

if($todo=='sup_cal') $title=_t('workshop','sup_cal');
if($todo=='add_cal') $title=_t('workshop','add_cal');
if($todo=='mod_cal') $title=_t('workshop','mod_cal');
if($todo=='list_cal') $title=_t('workshop','list_cal');

if($todo=='sup_com') $title=_t('workshop','sup_com');
if($todo=='lock_com') $title=_t('workshop','lock_com');
if($todo=='add_com') $title=_t('workshop','add_com');
if($todo=='mod_com') $title=_t('workshop','mod_com');
if($todo=='add_com'&& $com_id<>0) $title=_t('workshop','add_com_mes');
if($todo=='mod_com' && $com_id<>0) $title=_t('workshop','mod_com_mes');
if($todo=='sup_com' && $com_id<>0) $title=_t('workshop','sup_com_mes');
if($todo=='list_com') $title=_t('workshop','list_com');
if($todo=='det_com') $title=_t('workshop','det_com');


?>
<div id="itemenu">
	<h1><?php echo $title; ?></h1>
	<div class="contentlink">
		<?php $dispatcher->notify(new sfEvent('secondary_menu', 'admin_workshop.menu_start'));?>
		<?php if ($l21auth->isSuperAdmin()) { ?> <a href="<?php echo $rub_link_add; ?>" title="<?php echo _t('workshop','add');?>"><i class="icon-plus"></i><?php echo _t('workshop','add');?></a>
		<?php } ?> <a href="<?php echo $rub_link_list; ?>" title="<?php echo _t('workshop','list');?>"><i class="icon-list"></i><?php echo _t('workshop','list');?></a>
		<a href="<?php echo $search; ?>" title="<?php echo _t('menu','search');?>"><i class="icon-search"></i><?php echo _t('menu','search');?></a>
		<?php $dispatcher->notify(new sfEvent('secondary_menu', 'admin_workshop.menu_end'));?>
	</div>
</div>